/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.config;

import com.google.common.base.Strings;
import java.util.Optional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class AbstractFeeClientAutoConfigProperties
implements Validator {
    private boolean enabled;
    private String baseUrl;
    private String token;

    protected abstract String getDefaultBaseUrl();

    public String getBaseUrl() {
        return Optional.ofNullable(this.baseUrl).orElseGet(this::getDefaultBaseUrl);
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public boolean supports(Class<?> clazz) {
        return AbstractFeeClientAutoConfigProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        AbstractFeeClientAutoConfigProperties properties = (AbstractFeeClientAutoConfigProperties)target;
        String baseUrl = properties.getBaseUrl();
        if (!Strings.isNullOrEmpty((String)baseUrl)) {
            boolean validProtocol;
            boolean isHttp = baseUrl.startsWith("http://");
            boolean isHttps = baseUrl.startsWith("https://");
            boolean bl = validProtocol = isHttp || isHttps;
            if (!validProtocol) {
                String errorMessage = String.format("'baseUrl' must either start with 'http://' or 'https://' - invalid value: %s", baseUrl);
                errors.rejectValue("baseUrl", "baseUrl.invalid", errorMessage);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractFeeClientAutoConfigProperties)) {
            return false;
        }
        AbstractFeeClientAutoConfigProperties other = (AbstractFeeClientAutoConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        Optional<String> this$token = this.getToken();
        Optional<String> other$token = other.getToken();
        return !(this$token == null ? other$token != null : !((Object)this$token).equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractFeeClientAutoConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        Optional<String> $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractFeeClientAutoConfigProperties(enabled=" + this.isEnabled() + ", baseUrl=" + this.getBaseUrl() + ", token=" + this.getToken() + ")";
    }
}

