/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.blockcypher.config;

import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.blockcypher.BlockcypherFeeApiClient;
import org.tbk.bitcoin.tool.fee.blockcypher.BlockcypherFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.blockcypher.BlockcypherFeeProvider;
import org.tbk.bitcoin.tool.fee.blockcypher.config.BlockcypherFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BlockcypherFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={BlockcypherFeeApiClient.class, BlockcypherFeeProvider.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.blockcypher.enabled"}, havingValue="true", matchIfMissing=true)
public class BlockcypherFeeClientAutoConfiguration {
    private final BlockcypherFeeClientAutoConfigProperties properties;

    public BlockcypherFeeClientAutoConfiguration(BlockcypherFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlockcypherFeeApiClient.class})
    public BlockcypherFeeApiClient blockcypherFeeApiClient() {
        return new BlockcypherFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean(value={BlockcypherFeeProvider.class})
    public BlockcypherFeeProvider blockcypherFeeProvider(BlockcypherFeeApiClient blockcypherFeeApiClient) {
        return new BlockcypherFeeProvider(blockcypherFeeApiClient);
    }
}

