(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'disjunkt'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'disjunkt'.");
    }root.disjunkt = factory(typeof disjunkt === 'undefined' ? {} : disjunkt, kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var throwCCE = Kotlin.throwCCE;
  var equals = Kotlin.equals;
  var hashCode = Kotlin.hashCode;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var NoSuchElementException_init = Kotlin.kotlin.NoSuchElementException_init;
  var Unit = Kotlin.kotlin.Unit;
  Either$Left.prototype = Object.create(Either.prototype);
  Either$Left.prototype.constructor = Either$Left;
  Either$Right.prototype = Object.create(Either.prototype);
  Either$Right.prototype.constructor = Either$Right;
  function Either() {
  }
  Either.prototype.component1 = function () {
    return right(this);
  };
  function Either$Left(left) {
    Either.call(this);
    this.left = left;
  }
  Either$Left.prototype.equals = function (other) {
    var tmp$, tmp$_0;
    if (this === other)
      return true;
    if (other == null || !((tmp$ = Kotlin.getKClassFromExpression(this)) != null ? tmp$.equals(Kotlin.getKClassFromExpression(other)) : null))
      return false;
    Kotlin.isType(tmp$_0 = other, Either$Left) ? tmp$_0 : throwCCE();
    if (!equals(this.left, other.left))
      return false;
    return true;
  };
  Either$Left.prototype.hashCode = function () {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.left) != null ? hashCode(tmp$) : null) != null ? tmp$_0 : 0;
  };
  Either$Left.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Left',
    interfaces: [Either]
  };
  function Either$Right(right) {
    Either.call(this);
    this.right = right;
  }
  Either$Right.prototype.equals = function (other) {
    var tmp$, tmp$_0;
    if (this === other)
      return true;
    if (other == null || !((tmp$ = Kotlin.getKClassFromExpression(this)) != null ? tmp$.equals(Kotlin.getKClassFromExpression(other)) : null))
      return false;
    Kotlin.isType(tmp$_0 = other, Either$Right) ? tmp$_0 : throwCCE();
    if (!equals(this.right, other.right))
      return false;
    return true;
  };
  Either$Right.prototype.hashCode = function () {
    var tmp$, tmp$_0;
    return (tmp$_0 = (tmp$ = this.right) != null ? hashCode(tmp$) : null) != null ? tmp$_0 : 0;
  };
  Either$Right.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Right',
    interfaces: [Either]
  };
  Either.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Either',
    interfaces: []
  };
  function right($receiver) {
    if (Kotlin.isType($receiver, Either$Right))
      return $receiver.right;
    else if (Kotlin.isType($receiver, Either$Left))
      throw NoSuchElementException_init();
    else
      return Kotlin.noWhenBranchMatched();
  }
  function left($receiver) {
    if (Kotlin.isType($receiver, Either$Left))
      return $receiver.left;
    else if (Kotlin.isType($receiver, Either$Right))
      throw NoSuchElementException_init();
    else
      return Kotlin.noWhenBranchMatched();
  }
  function flatMap($receiver, transform) {
    if (Kotlin.isType($receiver, Either$Left))
      return $receiver;
    else if (Kotlin.isType($receiver, Either$Right))
      return transform($receiver.right);
    else
      return Kotlin.noWhenBranchMatched();
  }
  function map$lambda(closure$transform) {
    return function (it) {
      return new Either$Right(closure$transform(it));
    };
  }
  function map($receiver, transform) {
    return flatMap($receiver, map$lambda(transform));
  }
  function flatMapLeft($receiver, transform) {
    if (Kotlin.isType($receiver, Either$Left))
      return transform($receiver.left);
    else if (Kotlin.isType($receiver, Either$Right))
      return $receiver;
    else
      return Kotlin.noWhenBranchMatched();
  }
  function mapLeft$lambda(closure$transform) {
    return function (it) {
      return new Either$Left(closure$transform(it));
    };
  }
  function mapLeft($receiver, transform) {
    return flatMapLeft($receiver, mapLeft$lambda(transform));
  }
  function isLeft($receiver) {
    if (Kotlin.isType($receiver, Either$Right))
      return false;
    else if (Kotlin.isType($receiver, Either$Left))
      return true;
    else
      return Kotlin.noWhenBranchMatched();
  }
  function isRight($receiver) {
    if (Kotlin.isType($receiver, Either$Right))
      return true;
    else if (Kotlin.isType($receiver, Either$Left))
      return false;
    else
      return Kotlin.noWhenBranchMatched();
  }
  function onLeft($receiver, function_0) {
    if (Kotlin.isType($receiver, Either$Left)) {
      function_0($receiver.left);
      return $receiver;
    } else if (Kotlin.isType($receiver, Either$Right))
      return $receiver;
    else
      return Kotlin.noWhenBranchMatched();
  }
  function onRight($receiver, function_0) {
    if (Kotlin.isType($receiver, Either$Left))
      return $receiver;
    else if (Kotlin.isType($receiver, Either$Right)) {
      function_0($receiver.right);
      return $receiver;
    } else
      return Kotlin.noWhenBranchMatched();
  }
  function recover$lambda(closure$transform) {
    return function (it) {
      return new Either$Right(closure$transform(it));
    };
  }
  function recover($receiver, transform) {
    return flatMapLeft($receiver, recover$lambda(transform));
  }
  function onSuccess$lambda(closure$action) {
    return function (it) {
      closure$action(it);
      return Unit;
    };
  }
  function onSuccess($receiver, action) {
    return onRight($receiver, onSuccess$lambda(action));
  }
  function onFailure$lambda(closure$action) {
    return function (it) {
      closure$action(it);
      return Unit;
    };
  }
  function onFailure($receiver, action) {
    return onLeft($receiver, onFailure$lambda(action));
  }
  function orThrow$lambda(closure$exception) {
    return function (f) {
      return closure$exception();
    };
  }
  function orThrow($receiver, exception) {
    return orThrow_1($receiver, orThrow$lambda(exception));
  }
  function orThrow$lambda_0(x) {
    return x;
  }
  function orThrow_0($receiver) {
    return orThrow_1($receiver, orThrow$lambda_0);
  }
  function orThrow_1($receiver, exception) {
    if (Kotlin.isType($receiver, Either$Left))
      throw exception($receiver.left);
    else if (Kotlin.isType($receiver, Either$Right))
      return $receiver.right;
    else
      return Kotlin.noWhenBranchMatched();
  }
  function filter($receiver, predicate) {
    if (Kotlin.isType($receiver, Either$Left))
      return $receiver;
    else if (Kotlin.isType($receiver, Either$Right))
      return predicate($receiver.right) ? $receiver : null;
    else
      return Kotlin.noWhenBranchMatched();
  }
  function filterLeft($receiver, predicate) {
    if (Kotlin.isType($receiver, Either$Left))
      return predicate($receiver.left) ? $receiver : null;
    else if (Kotlin.isType($receiver, Either$Right))
      return $receiver;
    else
      return Kotlin.noWhenBranchMatched();
  }
  Either.Left = Either$Left;
  Either.Right = Either$Right;
  var package$tablestakes = _.tablestakes || (_.tablestakes = {});
  var package$disjunkt = package$tablestakes.disjunkt || (package$tablestakes.disjunkt = {});
  package$disjunkt.Either = Either;
  package$disjunkt.right_rcrf9n$ = right;
  package$disjunkt.left_rcrf9n$ = left;
  package$disjunkt.flatMap_se1p94$ = flatMap;
  package$disjunkt.map_8f2mhc$ = map;
  package$disjunkt.flatMapLeft_322tkq$ = flatMapLeft;
  package$disjunkt.mapLeft_5jpc6n$ = mapLeft;
  package$disjunkt.isLeft_rcrf9n$ = isLeft;
  package$disjunkt.isRight_rcrf9n$ = isRight;
  package$disjunkt.onLeft_7aldje$ = onLeft;
  package$disjunkt.onRight_rvozyj$ = onRight;
  package$disjunkt.recover_556jrh$ = recover;
  package$disjunkt.onSuccess_f1mxne$ = onSuccess;
  package$disjunkt.onFailure_aj3tf2$ = onFailure;
  package$disjunkt.orThrow_pb6uuh$ = orThrow;
  package$disjunkt.orThrow_vx4x3f$ = orThrow_0;
  package$disjunkt.orThrow_4fkvbr$ = orThrow_1;
  package$disjunkt.filter_tqpp8v$ = filter;
  package$disjunkt.filterLeft_t88u7k$ = filterLeft;
  Kotlin.defineModule('disjunkt', _);
  return _;
}));

//# sourceMappingURL=disjunkt.js.map
