/*
 * Decompiled with CFR 0.152.
 */
package io.github.t12y.ssim;

import io.github.t12y.ssim.models.MSSIMMatrix;
import io.github.t12y.ssim.models.Options;

public class IgnoredBoxes {
    protected static void adjustMSSIM(int height, int width, MSSIMMatrix mssimMatrix, Options options) {
        if (options.ignoredBoxes == null || options.ignoredBoxes.length == 0) {
            return;
        }
        int mapHeight = mssimMatrix.height;
        int mapWidth = mssimMatrix.width;
        double[] mapData = mssimMatrix.data;
        for (int y = 0; y < height; ++y) {
            block1: for (int x = 0; x < width; ++x) {
                int mapIdx = (int)((double)mapWidth * Math.floor((double)(mapHeight * y) / (double)height) + Math.floor((double)(mapWidth * x) / (double)width));
                if (mapData[mapIdx] == 1.0) continue;
                for (int i = 0; i < options.ignoredBoxes.length; ++i) {
                    boolean isWithinIgnoreBox;
                    int[] box = options.ignoredBoxes[i];
                    boolean bl = isWithinIgnoreBox = x >= box[0] && x <= box[1] && y >= box[2] && y <= box[3];
                    if (!isWithinIgnoreBox) continue;
                    mapData[mapIdx] = 1.0;
                    continue block1;
                }
            }
        }
        double sum = 0.0;
        for (double mapDatum : mapData) {
            sum += mapDatum;
        }
        mssimMatrix.mssim = sum / (double)mapData.length;
    }
}

