/*
 * Decompiled with CFR 0.152.
 */
package io.github.t12y.resemble;

import java.awt.image.BufferedImage;

public class Result {
    private final int width;
    private final int height;
    public final double mismatchedPercent;
    public final double[] diffPixels;

    public Result(int width, int height, double mismatchedPercent, double[] diffPixels) {
        this.width = width;
        this.height = height;
        this.mismatchedPercent = mismatchedPercent;
        this.diffPixels = diffPixels;
    }

    public BufferedImage toImage() {
        if (this.diffPixels == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        for (int i = 0; i < this.diffPixels.length; i += 4) {
            int red = (int)this.diffPixels[i];
            int green = (int)this.diffPixels[i + 1];
            int blue = (int)this.diffPixels[i + 2];
            int alpha = (int)this.diffPixels[i + 3];
            int column = i / 4 % this.width;
            int row = i / 4 / this.width;
            int rgb = alpha << 24 | red << 16 | green << 8 | blue;
            image.setRGB(column, row, rgb);
        }
        return image;
    }
}

