/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import org.jetbrains.coverage.gnu.trove.HashFunctions;
import org.jetbrains.coverage.gnu.trove.TIntFunction;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;

public class TIntArrayList
implements Serializable,
Cloneable {
    protected transient int[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public TIntArrayList() {
        this(4);
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList(int capacity) {
        void var1_1;
        this._data = new int[var1_1];
        this._pos = 0;
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList(int[] values2) {
        this(Math.max(values2.length, 4));
        void var1_1;
        this.add((int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            void var1_2;
            capacity = Math.max(this._data.length << 1, capacity);
            int[] tmp = new int[capacity];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = var1_2;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    /*
     * WARNING - void declaration
     */
    public void trimToSize() {
        if (this._data.length > this.size()) {
            void var1_1;
            int[] tmp = new int[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(int val) {
        void var1_1;
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + 1);
        this._data[this._pos++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void add(int[] vals) {
        void var1_1;
        this.add(vals, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public void add(int[] vals, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + length);
        System.arraycopy(var1_1, (int)var2_2, this._data, this._pos, length);
        this._pos += var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void insert(int offset, int value) {
        void var2_2;
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[var1_1] = var2_2;
        ++this._pos;
    }

    /*
     * WARNING - void declaration
     */
    public void insert(int offset, int[] values2) {
        void var2_2;
        void var1_1;
        this.insert((int)var1_1, values2, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    public void insert(int offset, int[] values2, int valOffset, int len) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (offset == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        TIntArrayList tIntArrayList = this;
        tIntArrayList.ensureCapacity(tIntArrayList._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(var2_2, (int)var3_3, this._data, (int)var1_1, len);
        this._pos += len;
    }

    /*
     * WARNING - void declaration
     */
    public int get(int offset) {
        void var1_1;
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int getQuick(int offset) {
        void var1_1;
        return this._data[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public void set(int offset, int val) {
        void var2_2;
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int getSet(int offset, int val) {
        void var3_3;
        void var2_2;
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        int old = this._data[offset];
        this._data[var1_1] = var2_2;
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void set(int offset, int[] values2) {
        void var2_2;
        void var1_1;
        this.set((int)var1_1, values2, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    public void set(int offset, int[] values2, int valOffset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, (int)var1_1, var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    public void setQuick(int offset, int val) {
        void var2_2;
        this._data[var1_1] = var2_2;
    }

    public void clear() {
        this.clear(4);
    }

    /*
     * WARNING - void declaration
     */
    public void clear(int capacity) {
        void var1_1;
        this._data = new int[var1_1];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    /*
     * WARNING - void declaration
     */
    public int remove(int offset) {
        void var2_2;
        void var1_1;
        int old = this.get(offset);
        this.remove((int)var1_1, 1);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void remove(int offset, int length) {
        void var2_2;
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            void var1_1;
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (var1_1 + length));
        }
        this._pos -= var2_2;
    }

    public void transformValues(TIntFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    public void reverse(int from, int to) {
        void i;
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap((int)i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void swap(int i, int j) {
        void var3_3;
        int tmp = this._data[i];
        this._data[var1_1] = this._data[j];
        this._data[var2_2] = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        void var1_1;
        TIntArrayList clone = null;
        try {
            clone = (TIntArrayList)super.clone();
            ((TIntArrayList)super.clone())._data = (int[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return var1_1;
    }

    public int[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    public int[] toNativeArray(int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] rv = new int[len];
        this.toNativeArray(rv, (int)var1_1, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void toNativeArray(int[] dest, int offset, int len) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, (int)var2_2, var1_1, 0, (int)var3_3);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TIntArrayList) {
            TIntArrayList that = (TIntArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return (int)var1_1;
    }

    public boolean forEach(TIntProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TIntProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    public void sort(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        Arrays.sort(this._data, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void fill(int val) {
        void var1_1;
        Arrays.fill(this._data, 0, this._pos, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void fill(int fromIndex, int toIndex, int val) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public int binarySearch(int value) {
        void var1_1;
        return this.binarySearch((int)var1_1, 0, this._pos);
    }

    /*
     * WARNING - void declaration
     */
    public int binarySearch(int value, int fromIndex, int toIndex) {
        void var2_2;
        void low;
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int high = toIndex - 1;
        while (low <= high) {
            void mid = low + high >> 1;
            int midVal = this._data[mid];
            if (midVal < value) {
                low = mid + true;
                continue;
            }
            if (midVal > value) {
                high = mid - true;
                continue;
            }
            return (int)mid;
        }
        return (int)(-(var2_2 + true));
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(int value) {
        void var1_1;
        return this.indexOf(0, (int)var1_1);
    }

    public int indexOf(int offset, int value) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(int value) {
        void var1_1;
        TIntArrayList tIntArrayList = this;
        return tIntArrayList.lastIndexOf(tIntArrayList._pos, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(int offset, int value) {
        int i = offset;
        while (i-- > 0) {
            void var1_1;
            if (this._data[i] != value) continue;
            return (int)var1_1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(int value) {
        void var1_1;
        return this.lastIndexOf((int)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList grep(TIntProcedure condition) {
        void var2_2;
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!condition.execute(this._data[i])) continue;
            list.add(this._data[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public TIntArrayList inverseGrep(TIntProcedure condition) {
        void var2_2;
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (condition.execute(this._data[i])) continue;
            list.add(this._data[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int max() {
        void var1_1;
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int max = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int min() {
        void var1_1;
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int min = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            min = Math.min(min, this._data[this._pos]);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TIntProcedure(){

            /*
             * WARNING - void declaration
             */
            public boolean execute(int val) {
                void var1_1;
                buf.append((int)var1_1);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return var1_1.toString();
    }
}

