/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jacoco.core.internal.analysis.ClassAnalyzer;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.InstructionsBuilder;
import org.jacoco.core.internal.analysis.MethodAnalyzer;
import org.jacoco.core.internal.analysis.MethodCoverageCalculator;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.analysis.filter.Filters;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.instr.InstrSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J?\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jacoco/core/internal/analysis/FilteringClassAnalyzer;", "Lorg/jacoco/core/internal/analysis/ClassAnalyzer;", "coverage", "Lorg/jacoco/core/internal/analysis/ClassCoverageImpl;", "probes", "", "stringPool", "Lorg/jacoco/core/internal/analysis/StringPool;", "customFilter", "Lorg/jacoco/core/internal/analysis/filter/IFilter;", "(Lorg/jacoco/core/internal/analysis/ClassCoverageImpl;[ZLorg/jacoco/core/internal/analysis/StringPool;Lorg/jacoco/core/internal/analysis/filter/IFilter;)V", "filter", "addMethodCoverage", "", "name", "", "desc", "signature", "icc", "Lorg/jacoco/core/internal/analysis/InstructionsBuilder;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "createFilters", "visitMethod", "Lorg/jacoco/core/internal/flow/MethodProbesVisitor;", "access", "", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jacoco/core/internal/flow/MethodProbesVisitor;", "delta-coverage-core"})
public class FilteringClassAnalyzer
extends ClassAnalyzer {
    @NotNull
    private final ClassCoverageImpl coverage;
    @Nullable
    private final boolean[] probes;
    @NotNull
    private final StringPool stringPool;
    @NotNull
    private final IFilter filter;

    public FilteringClassAnalyzer(@NotNull ClassCoverageImpl coverage, @Nullable boolean[] probes, @NotNull StringPool stringPool, @NotNull IFilter customFilter) {
        Intrinsics.checkNotNullParameter(coverage, "coverage");
        Intrinsics.checkNotNullParameter(stringPool, "stringPool");
        Intrinsics.checkNotNullParameter(customFilter, "customFilter");
        super(coverage, probes, stringPool);
        this.coverage = coverage;
        this.probes = probes;
        this.stringPool = stringPool;
        this.filter = this.createFilters(customFilter);
    }

    private final IFilter createFilters(IFilter customFilter) {
        return new IFilter(customFilter){
            private final IFilter allFilters;
            final /* synthetic */ IFilter $customFilter;
            {
                this.$customFilter = $customFilter;
                this.allFilters = Filters.all();
            }

            public void filter(@NotNull MethodNode methodNode, @NotNull IFilterContext context, @NotNull IFilterOutput output) {
                Intrinsics.checkNotNullParameter(methodNode, "methodNode");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(output, "output");
                this.allFilters.filter(methodNode, context, output);
                this.$customFilter.filter(methodNode, context, output);
            }
        };
    }

    @Override
    @NotNull
    public MethodProbesVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(desc, "desc");
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        InstructionsBuilder builder = new InstructionsBuilder(this.probes);
        return new MethodAnalyzer(builder, this, name, desc, signature){
            final /* synthetic */ InstructionsBuilder $builder;
            final /* synthetic */ FilteringClassAnalyzer this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $desc;
            final /* synthetic */ String $signature;
            {
                this.$builder = $builder;
                this.this$0 = $receiver;
                this.$name = $name;
                this.$desc = $desc;
                this.$signature = $signature;
                super($builder);
            }

            public void accept(@NotNull MethodNode methodNode, @NotNull MethodVisitor methodVisitor) {
                Intrinsics.checkNotNullParameter(methodNode, "methodNode");
                Intrinsics.checkNotNullParameter(methodVisitor, "methodVisitor");
                super.accept(methodNode, methodVisitor);
                String string = FilteringClassAnalyzer.access$getStringPool$p(this.this$0).get(this.$name);
                Intrinsics.checkNotNullExpressionValue(string, "get(...)");
                String string2 = FilteringClassAnalyzer.access$getStringPool$p(this.this$0).get(this.$desc);
                Intrinsics.checkNotNullExpressionValue(string2, "get(...)");
                FilteringClassAnalyzer.access$addMethodCoverage(this.this$0, string, string2, FilteringClassAnalyzer.access$getStringPool$p(this.this$0).get(this.$signature), this.$builder, methodNode);
            }
        };
    }

    private final void addMethodCoverage(String name, String desc, String signature, InstructionsBuilder icc, MethodNode methodNode) {
        MethodCoverageCalculator methodCoverageCalculator = new MethodCoverageCalculator(icc.getInstructions());
        this.filter.filter(methodNode, this, methodCoverageCalculator);
        MethodCoverageImpl $this$addMethodCoverage_u24lambda_u240 = new MethodCoverageImpl(name, desc, signature);
        boolean bl = false;
        methodCoverageCalculator.calculate($this$addMethodCoverage_u24lambda_u240);
        if ($this$addMethodCoverage_u24lambda_u240.containsCode()) {
            this.coverage.addMethod($this$addMethodCoverage_u24lambda_u240);
        }
    }

    public static final /* synthetic */ void access$addMethodCoverage(FilteringClassAnalyzer $this, String name, String desc, String signature, InstructionsBuilder icc, MethodNode methodNode) {
        $this.addMethodCoverage(name, desc, signature, icc, methodNode);
    }

    public static final /* synthetic */ StringPool access$getStringPool$p(FilteringClassAnalyzer $this) {
        return $this.stringPool;
    }
}

