/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.ObjectInfoRequest;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV2Parser {
    private final TransferConfig transferConfig;

    ProtocolV2Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    private static String consumeCapabilities(PacketLineIn pckIn, Consumer<String> serverOptionConsumer, Consumer<String> agentConsumer) throws IOException {
        String serverOptionPrefix = "server-option=";
        String agentPrefix = "agent=";
        String line2 = pckIn.readString();
        while (!PacketLineIn.isDelimiter(line2) && !PacketLineIn.isEnd(line2)) {
            if (line2.startsWith(serverOptionPrefix)) {
                serverOptionConsumer.accept(line2.substring(serverOptionPrefix.length()));
            } else if (line2.startsWith(agentPrefix)) {
                agentConsumer.accept(line2.substring(agentPrefix.length()));
            }
            line2 = pckIn.readString();
        }
        return line2;
    }

    FetchV2Request parseFetchRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        FetchV2Request.Builder reqBuilder = FetchV2Request.builder();
        reqBuilder.addClientCapability("side-band-64k");
        String line2 = ProtocolV2Parser.consumeCapabilities(pckIn, serverOption -> {
            FetchV2Request.Builder builder2 = reqBuilder.addServerOption((String)serverOption);
        }, agent -> {
            FetchV2Request.Builder builder2 = reqBuilder.setAgent((String)agent);
        });
        if (PacketLineIn.isEnd(line2)) {
            return reqBuilder.build();
        }
        if (!PacketLineIn.isDelimiter(line2)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line2));
        }
        boolean filterReceived = false;
        for (String line22 : pckIn.readStrings()) {
            if (line22.startsWith("want ")) {
                reqBuilder.addWantId(ObjectId.fromString(line22.substring(5)));
                continue;
            }
            if (this.transferConfig.isAllowRefInWant() && line22.startsWith("want-ref ")) {
                reqBuilder.addWantedRef(line22.substring("want-ref".length() + 1));
                continue;
            }
            if (line22.startsWith("have ")) {
                reqBuilder.addPeerHas(ObjectId.fromString(line22.substring(5)));
                continue;
            }
            if (line22.equals("done")) {
                reqBuilder.setDoneReceived();
                continue;
            }
            if (line22.equals("wait-for-done")) {
                reqBuilder.setWaitForDone();
                continue;
            }
            if (line22.equals("thin-pack")) {
                reqBuilder.addClientCapability("thin-pack");
                continue;
            }
            if (line22.equals("no-progress")) {
                reqBuilder.addClientCapability("no-progress");
                continue;
            }
            if (line22.equals("include-tag")) {
                reqBuilder.addClientCapability("include-tag");
                continue;
            }
            if (line22.equals("ofs-delta")) {
                reqBuilder.addClientCapability("ofs-delta");
                continue;
            }
            if (line22.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line22.substring(8)));
                continue;
            }
            if (line22.startsWith("deepen ")) {
                int parsedDepth = Integer.parseInt(line22.substring(7));
                if (parsedDepth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, parsedDepth));
                }
                if (reqBuilder.getDeepenSince() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                if (reqBuilder.hasDeepenNotRefs()) {
                    throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
                }
                reqBuilder.setDepth(parsedDepth);
                continue;
            }
            if (line22.startsWith("deepen-not ")) {
                reqBuilder.addDeepenNotRef(line22.substring(11));
                if (reqBuilder.getDepth() == 0) continue;
                throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
            }
            if (line22.equals("deepen-relative")) {
                reqBuilder.addClientCapability("deepen-relative");
                continue;
            }
            if (line22.startsWith("deepen-since ")) {
                int ts = Integer.parseInt(line22.substring(13));
                if (ts <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidTimestamp, line22));
                }
                if (reqBuilder.getDepth() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                reqBuilder.setDeepenSince(ts);
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line22.startsWith("filter ")) {
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterSpec(FilterSpec.fromFilterLine(line22.substring("filter".length() + 1)));
                continue;
            }
            if (this.transferConfig.isAllowSidebandAll() && line22.equals("sideband-all")) {
                reqBuilder.setSidebandAll(true);
                continue;
            }
            if (line22.startsWith("packfile-uris ")) {
                String[] stringArray = line22.substring(14).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    reqBuilder.addPackfileUriProtocol(s);
                    ++n2;
                }
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line22));
        }
        return reqBuilder.build();
    }

    LsRefsV2Request parseLsRefsRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        LsRefsV2Request.Builder builder = LsRefsV2Request.builder();
        ArrayList<String> prefixes = new ArrayList<String>();
        String line2 = ProtocolV2Parser.consumeCapabilities(pckIn, serverOption -> {
            LsRefsV2Request.Builder builder2 = builder.addServerOption((String)serverOption);
        }, agent -> {
            LsRefsV2Request.Builder builder2 = builder.setAgent((String)agent);
        });
        if (PacketLineIn.isEnd(line2)) {
            return builder.build();
        }
        if (!PacketLineIn.isDelimiter(line2)) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line2));
        }
        for (String line22 : pckIn.readStrings()) {
            if (line22.equals("peel")) {
                builder.setPeel(true);
                continue;
            }
            if (line22.equals("symrefs")) {
                builder.setSymrefs(true);
                continue;
            }
            if (line22.startsWith("ref-prefix ")) {
                prefixes.add(line22.substring("ref-prefix ".length()));
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line22));
        }
        return builder.setRefPrefixes(prefixes).build();
    }

    ObjectInfoRequest parseObjectInfoRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        ObjectInfoRequest.Builder builder = ObjectInfoRequest.builder();
        ArrayList<ObjectId> objectIDs = new ArrayList<ObjectId>();
        String line2 = pckIn.readString();
        if (PacketLineIn.isEnd(line2)) {
            return builder.build();
        }
        if (!line2.equals("size")) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line2));
        }
        for (String line22 : pckIn.readStrings()) {
            if (!line22.startsWith("oid ")) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line22));
            }
            String oidStr = line22.substring("oid ".length());
            try {
                objectIDs.add(ObjectId.fromString(oidStr));
            }
            catch (InvalidObjectIdException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidObject, oidStr), e);
            }
        }
        return builder.setObjectIDs(objectIDs).build();
    }
}

