/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLineIn {
    private static final Logger log = LoggerFactory.getLogger(PacketLineIn.class);
    @Deprecated
    public static final String END = new String();
    @Deprecated
    public static final String DELIM = new String();
    private final byte[] lineBuffer = new byte[1000];
    private final InputStream in;
    private long limit;

    public PacketLineIn(InputStream in) {
        this(in, 0L);
    }

    public PacketLineIn(InputStream in, long limit) {
        this.in = in;
        this.limit = limit;
    }

    static AckNackResult parseACKv2(String line2, MutableObjectId returnedId) throws IOException {
        if ("NAK".equals(line2)) {
            return AckNackResult.NAK;
        }
        if (line2.startsWith("ACK ") && line2.length() == 44) {
            returnedId.fromString(line2.substring(4, 44));
            return AckNackResult.ACK_COMMON;
        }
        if ("ready".equals(line2)) {
            return AckNackResult.ACK_READY;
        }
        if (line2.startsWith("ERR ")) {
            throw new PackProtocolException(line2.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, line2));
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line2;
        block17: {
            String arg;
            line2 = this.readString();
            if (line2.length() == 0) {
                throw new PackProtocolException(JGitText.get().expectedACKNAKFoundEOF);
            }
            if ("NAK".equals(line2)) {
                return AckNackResult.NAK;
            }
            if (!line2.startsWith("ACK ")) break block17;
            returnedId.fromString(line2.substring(4, 44));
            if (line2.length() == 44) {
                return AckNackResult.ACK;
            }
            switch (arg = line2.substring(44)) {
                case " continue": {
                    return AckNackResult.ACK_CONTINUE;
                }
                case " common": {
                    return AckNackResult.ACK_COMMON;
                }
                case " ready": {
                    return AckNackResult.ACK_READY;
                }
            }
        }
        if (line2.startsWith("ERR ")) {
            throw new PackProtocolException(line2.substring(4));
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedACKNAKGot, line2));
    }

    public String readString() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            log.debug("git< 0000");
            return END;
        }
        if (len == 1) {
            log.debug("git< 0001");
            return DELIM;
        }
        if ((len -= 4) == 0) {
            log.debug("git< ");
            return "";
        }
        byte[] raw = len <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        if (raw[len - 1] == 10) {
            --len;
        }
        String s = RawParseUtils.decode(StandardCharsets.UTF_8, raw, 0, len);
        log.debug("git< " + s);
        return s;
    }

    public PacketLineInIterator readStrings() throws IOException {
        return new PacketLineInIterator(this);
    }

    public String readStringRaw() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            log.debug("git< 0000");
            return END;
        }
        byte[] raw = (len -= 4) <= this.lineBuffer.length ? this.lineBuffer : new byte[len];
        IO.readFully(this.in, raw, 0, len);
        String s = RawParseUtils.decode(StandardCharsets.UTF_8, raw, 0, len);
        log.debug("git< " + s);
        return s;
    }

    public static boolean isDelimiter(String s) {
        return s == DELIM;
    }

    static String delimiter() {
        return DELIM;
    }

    static String end() {
        return END;
    }

    public static boolean isEnd(String s) {
        return s == END;
    }

    void discardUntilEnd() throws IOException {
        int n;
        while ((n = this.readLength()) != 0) {
            IO.skipFully(this.in, n - 4);
        }
    }

    int readLength() throws IOException {
        int len;
        IO.readFully(this.in, this.lineBuffer, 0, 4);
        try {
            len = RawParseUtils.parseHexInt16(this.lineBuffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw this.invalidHeader(err);
        }
        if (len == 0) {
            return 0;
        }
        if (len == 1) {
            return 1;
        }
        if (len < 4) {
            throw this.invalidHeader();
        }
        if (this.limit != 0L) {
            int n = len - 4;
            if (this.limit < (long)n) {
                this.limit = -1L;
                try {
                    IO.skipFully(this.in, n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new InputOverLimitIOException();
            }
            this.limit = (long)n < this.limit ? this.limit - (long)n : -1L;
        }
        return len;
    }

    private IOException invalidHeader() {
        return new IOException(MessageFormat.format(JGitText.get().invalidPacketLineHeader, "" + (char)this.lineBuffer[0] + (char)this.lineBuffer[1] + (char)this.lineBuffer[2] + (char)this.lineBuffer[3]));
    }

    private IOException invalidHeader(Throwable cause) {
        IOException ioe = this.invalidHeader();
        ioe.initCause(cause);
        return ioe;
    }

    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE,
        ACK_COMMON,
        ACK_READY;

    }

    public static class InputOverLimitIOException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class PacketLineInIterator
    implements Iterable<String> {
        private PacketLineIn in;
        private String current;

        PacketLineInIterator(PacketLineIn in) throws IOException {
            this.in = in;
            this.current = in.readString();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return !PacketLineIn.isEnd(current);
                }

                @Override
                public String next() {
                    String next = current;
                    try {
                        current = in.readString();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return next;
                }
            };
        }
    }
}

