/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.events;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.RepositoryListener;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;

public class ListenerList {
    private final Map<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>> lists = new ConcurrentHashMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>>();

    public ListenerHandle addWorkingTreeModifiedListener(WorkingTreeModifiedListener listener2) {
        return this.addListener(WorkingTreeModifiedListener.class, listener2);
    }

    public ListenerHandle addIndexChangedListener(IndexChangedListener listener2) {
        return this.addListener(IndexChangedListener.class, listener2);
    }

    public ListenerHandle addRefsChangedListener(RefsChangedListener listener2) {
        return this.addListener(RefsChangedListener.class, listener2);
    }

    public ListenerHandle addConfigChangedListener(ConfigChangedListener listener2) {
        return this.addListener(ConfigChangedListener.class, listener2);
    }

    public <T extends RepositoryListener> ListenerHandle addListener(Class<T> type, T listener2) {
        ListenerHandle handle = new ListenerHandle(this, type, listener2);
        this.add(handle);
        return handle;
    }

    public void dispatch(RepositoryEvent event) {
        List list = this.lists.get(event.getListenerType());
        if (list != null) {
            for (ListenerHandle handle : list) {
                event.dispatch(handle.listener);
            }
        }
    }

    private void add(ListenerHandle handle) {
        CopyOnWriteArrayList<ListenerHandle> newList;
        CopyOnWriteArrayList<ListenerHandle> list = this.lists.get(handle.type);
        if (list == null && (list = (List)this.lists.putIfAbsent(handle.type, newList = new CopyOnWriteArrayList<ListenerHandle>())) == null) {
            list = newList;
        }
        list.add(handle);
    }

    void remove(ListenerHandle handle) {
        List list = this.lists.get(handle.type);
        if (list != null) {
            list.remove(handle);
        }
    }
}

