/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.appliers.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.gradle.plugin.appliers.reports.ReportsVariantApplier;
import kotlinx.kover.gradle.plugin.appliers.reports.ReportsVariantApplierKt;
import kotlinx.kover.gradle.plugin.commons.CompilationKit;
import kotlinx.kover.gradle.plugin.commons.ConfigurationsKt;
import kotlinx.kover.gradle.plugin.commons.KoverMarkerAttr;
import kotlinx.kover.gradle.plugin.commons.NamingKt;
import kotlinx.kover.gradle.plugin.commons.PathsKt;
import kotlinx.kover.gradle.plugin.commons.ProjectPathAttr;
import kotlinx.kover.gradle.plugin.commons.ReportFilters;
import kotlinx.kover.gradle.plugin.commons.ReportsVariantType;
import kotlinx.kover.gradle.plugin.commons.VariantNameAttr;
import kotlinx.kover.gradle.plugin.dsl.AggregationType;
import kotlinx.kover.gradle.plugin.dsl.GroupingEntityType;
import kotlinx.kover.gradle.plugin.dsl.MetricType;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverReportFiltersImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverReportsConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverVerificationRulesConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverVerifyReportConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverVerifyRuleImpl;
import kotlinx.kover.gradle.plugin.tasks.reports.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tasks.reports.KoverBinaryTask;
import kotlinx.kover.gradle.plugin.tasks.reports.KoverFormatCoverageTask;
import kotlinx.kover.gradle.plugin.tasks.reports.KoverHtmlTask;
import kotlinx.kover.gradle.plugin.tasks.reports.KoverVerifyTask;
import kotlinx.kover.gradle.plugin.tasks.reports.KoverXmlTask;
import kotlinx.kover.gradle.plugin.tasks.services.KoverArtifactGenerationTask;
import kotlinx.kover.gradle.plugin.tasks.services.KoverPrintLogTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0004J&\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,J\b\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\u0005H\u0002J\b\u0010/\u001a\u00020\u0005H\u0002J\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u0000J\b\u00102\u001a\u00020\u0005H\u0002J\b\u00103\u001a\u00020\u0005H\u0002J/\u00104\u001a\b\u0012\u0004\u0012\u0002H50\u0010\"\n\b\u0000\u00105\u0018\u0001*\u000206*\u0002072\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005H\u0082\bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lkotlinx/kover/gradle/plugin/appliers/reports/ReportsVariantApplier;", "", "project", "Lorg/gradle/api/Project;", "variantName", "", "type", "Lkotlinx/kover/gradle/plugin/commons/ReportsVariantType;", "koverDependencies", "Lorg/gradle/api/artifacts/Configuration;", "reportClasspath", "toolProvider", "Lorg/gradle/api/provider/Provider;", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "(Lorg/gradle/api/Project;Ljava/lang/String;Lkotlinx/kover/gradle/plugin/commons/ReportsVariantType;Lorg/gradle/api/artifacts/Configuration;Lorg/gradle/api/artifacts/Configuration;Lorg/gradle/api/provider/Provider;)V", "artifactGenTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lkotlinx/kover/gradle/plugin/tasks/services/KoverArtifactGenerationTask;", "binTask", "Lkotlinx/kover/gradle/plugin/tasks/reports/KoverBinaryTask;", "config", "Lorg/gradle/api/NamedDomainObjectProvider;", "getConfig", "()Lorg/gradle/api/NamedDomainObjectProvider;", "dependencies", "getDependencies", "htmlTask", "Lkotlinx/kover/gradle/plugin/tasks/reports/KoverHtmlTask;", "logTask", "Lkotlinx/kover/gradle/plugin/tasks/reports/KoverFormatCoverageTask;", "verifyTask", "Lkotlinx/kover/gradle/plugin/tasks/reports/KoverVerifyTask;", "xmlTask", "Lkotlinx/kover/gradle/plugin/tasks/reports/KoverXmlTask;", "applyCommonCompilationKit", "", "kit", "Lkotlinx/kover/gradle/plugin/commons/CompilationKit;", "applyConfig", "reportConfig", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverReportsConfigImpl;", "commonFilters", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverReportFiltersImpl;", "commonVerify", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverVerificationRulesConfigImpl;", "htmlTaskDescription", "icTaskDescription", "logTaskDescription", "mergeWith", "otherVariant", "verifyTaskDescription", "xmlTaskDescription", "createReportTask", "T", "Lkotlinx/kover/gradle/plugin/tasks/reports/AbstractKoverReportTask;", "Lorg/gradle/api/tasks/TaskContainer;", "name", "taskDescription", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nReportsVariantApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportsVariantApplier.kt\nkotlinx/kover/gradle/plugin/appliers/reports/ReportsVariantApplier\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,308:1\n237#1:310\n238#1:312\n250#1:313\n237#1:314\n238#1:316\n250#1:317\n237#1:318\n238#1:320\n250#1:321\n237#1:322\n238#1:324\n250#1:325\n237#1:326\n238#1:328\n250#1:329\n245#2:309\n245#2:311\n245#2:315\n245#2:319\n245#2:323\n245#2:327\n245#2:330\n245#2:331\n*S KotlinDebug\n*F\n+ 1 ReportsVariantApplier.kt\nkotlinx/kover/gradle/plugin/appliers/reports/ReportsVariantApplier\n*L\n92#1:310\n92#1:312\n92#1:313\n96#1:314\n96#1:316\n96#1:317\n100#1:318\n100#1:320\n100#1:321\n104#1:322\n104#1:324\n104#1:325\n108#1:326\n108#1:328\n108#1:329\n62#1:309\n92#1:311\n96#1:315\n100#1:319\n104#1:323\n108#1:327\n112#1:330\n237#1:331\n*E\n"})
public abstract class ReportsVariantApplier {
    @NotNull
    private final Project project;
    @NotNull
    private final String variantName;
    @NotNull
    private final ReportsVariantType type;
    @NotNull
    private final Configuration koverDependencies;
    @NotNull
    private final Configuration reportClasspath;
    @NotNull
    private final Provider<CoverageTool> toolProvider;
    @NotNull
    private final TaskProvider<KoverHtmlTask> htmlTask;
    @NotNull
    private final TaskProvider<KoverXmlTask> xmlTask;
    @NotNull
    private final TaskProvider<KoverBinaryTask> binTask;
    @NotNull
    private final TaskProvider<KoverVerifyTask> verifyTask;
    @NotNull
    private final TaskProvider<KoverFormatCoverageTask> logTask;
    @NotNull
    private final TaskProvider<KoverArtifactGenerationTask> artifactGenTask;
    @NotNull
    private final NamedDomainObjectProvider<Configuration> config;
    @NotNull
    private final NamedDomainObjectProvider<Configuration> dependencies;

    /*
     * WARNING - void declaration
     */
    public ReportsVariantApplier(@NotNull Project project, @NotNull String variantName, @NotNull ReportsVariantType type, @NotNull Configuration koverDependencies2, @NotNull Configuration reportClasspath, @NotNull Provider<CoverageTool> toolProvider) {
        void $this$register$iv;
        ReportsVariantApplier this_$iv;
        String taskDescription$iv;
        String name$iv;
        TaskContainer $this$createReportTask$iv;
        void $this$register$iv2;
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(variantName, "variantName");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(koverDependencies2, "koverDependencies");
        Intrinsics.checkNotNullParameter(reportClasspath, "reportClasspath");
        Intrinsics.checkNotNullParameter(toolProvider, "toolProvider");
        this.project = project;
        this.variantName = variantName;
        this.type = type;
        this.koverDependencies = koverDependencies2;
        this.reportClasspath = reportClasspath;
        this.toolProvider = toolProvider;
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer, "project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        Object name$iv2 = NamingKt.artifactGenerationTaskName(this.variantName);
        boolean $i$f$register22 = false;
        TaskProvider taskProvider = $this$register$iv2.register((String)name$iv2, KoverArtifactGenerationTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider, "register(name, T::class.java)");
        this.artifactGenTask = taskProvider;
        Provider provider = this.project.getLayout().getBuildDirectory().file(PathsKt.artifactFilePath(this.variantName));
        Intrinsics.checkNotNullExpressionValue(provider, "project.layout.buildDire\u2026actFilePath(variantName))");
        Provider artifactProperty = provider;
        this.artifactGenTask.configure(new Action((Provider<RegularFile>)artifactProperty){
            final /* synthetic */ Provider<RegularFile> $artifactProperty;
            {
                this.$artifactProperty = $artifactProperty;
            }

            public final void execute(@NotNull KoverArtifactGenerationTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, "$this$configure");
                $this$configure.getArtifactFile().set(this.$artifactProperty);
            }
        });
        NamedDomainObjectProvider namedDomainObjectProvider = this.project.getConfigurations().register(NamingKt.artifactConfigurationName(this.variantName), new Action((Provider<RegularFile>)artifactProperty, this){
            final /* synthetic */ Provider<RegularFile> $artifactProperty;
            final /* synthetic */ ReportsVariantApplier this$0;
            {
                this.$artifactProperty = $artifactProperty;
                this.this$0 = $receiver;
            }

            public final void execute(final @NotNull Configuration $this$register) {
                Intrinsics.checkNotNullParameter($this$register, "$this$register");
                $this$register.setVisible(false);
                $this$register.getOutgoing().artifact(this.$artifactProperty, new Action(){

                    public final void execute(@NotNull ConfigurablePublishArtifact $this$artifact) {
                        Intrinsics.checkNotNullParameter($this$artifact, "$this$artifact");
                        Configuration configuration = $this$register;
                        Intrinsics.checkNotNullExpressionValue(configuration, "execute");
                        ConfigurationsKt.asProducer(configuration);
                        $this$register.attributes(new Action(){

                            public final void execute(@NotNull AttributeContainer $this$attributes) {
                                ObjectFactory $this$named$iv;
                                Intrinsics.checkNotNullParameter($this$attributes, "$this$attributes");
                                Attribute<VariantNameAttr> attribute = KoverMarkerAttr.Companion.getATTRIBUTE();
                                ObjectFactory objectFactory = this$0.project.getObjects();
                                Intrinsics.checkNotNullExpressionValue(objectFactory, "project.objects");
                                ObjectFactory objectFactory2 = objectFactory;
                                String name$iv = "Kover";
                                boolean $i$f$named = false;
                                Named named = $this$named$iv.named(VariantNameAttr.class, name$iv);
                                Intrinsics.checkNotNullExpressionValue(named, "named(T::class.java, name)");
                                $this$attributes.attribute(attribute, (Object)named);
                                Attribute<VariantNameAttr> attribute2 = VariantNameAttr.Companion.getATTRIBUTE();
                                ObjectFactory objectFactory3 = this$0.project.getObjects();
                                Intrinsics.checkNotNullExpressionValue(objectFactory3, "project.objects");
                                $this$named$iv = objectFactory3;
                                name$iv = this$0.variantName;
                                $i$f$named = false;
                                Named named2 = $this$named$iv.named(VariantNameAttr.class, name$iv);
                                Intrinsics.checkNotNullExpressionValue(named2, "named(T::class.java, name)");
                                $this$attributes.attribute(attribute2, (Object)named2);
                                Attribute<ProjectPathAttr> attribute3 = ProjectPathAttr.Companion.getATTRIBUTE();
                                ObjectFactory objectFactory4 = this$0.project.getObjects();
                                Intrinsics.checkNotNullExpressionValue(objectFactory4, "project.objects");
                                $this$named$iv = objectFactory4;
                                String string = this$0.project.getPath();
                                Intrinsics.checkNotNullExpressionValue(string, "project.path");
                                name$iv = string;
                                $i$f$named = false;
                                Named named3 = $this$named$iv.named(ProjectPathAttr.class, name$iv);
                                Intrinsics.checkNotNullExpressionValue(named3, "named(T::class.java, name)");
                                $this$attributes.attribute(attribute3, (Object)named3);
                            }
                        });
                        Object[] objectArray = new Object[]{this$0.artifactGenTask};
                        $this$artifact.builtBy(objectArray);
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue(namedDomainObjectProvider, "project.configurations.r\u2026)\n            }\n        }");
        this.config = namedDomainObjectProvider;
        NamedDomainObjectProvider namedDomainObjectProvider2 = this.project.getConfigurations().register(NamingKt.externalArtifactConfigurationName(this.variantName), new Action(){

            public final void execute(@NotNull Configuration $this$register) {
                Intrinsics.checkNotNullParameter($this$register, "$this$register");
                ConfigurationsKt.asConsumer($this$register);
                $this$register.setTransitive(false);
                Configuration[] configurationArray = new Configuration[]{koverDependencies};
                $this$register.extendsFrom(configurationArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue(namedDomainObjectProvider2, "project.configurations.r\u2026erDependencies)\n        }");
        this.dependencies = namedDomainObjectProvider2;
        name$iv2 = this;
        TaskContainer taskContainer3 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer3, "project.tasks");
        TaskContainer $i$f$register22 = taskContainer3;
        String string = NamingKt.htmlReportTaskName(this.variantName);
        String string2 = this.htmlTaskDescription();
        boolean $i$f$createReportTask = false;
        TaskContainer $this$register$iv$iv = $this$createReportTask$iv;
        boolean $i$f$register = false;
        TaskProvider taskProvider2 = $this$register$iv$iv.register(name$iv, KoverHtmlTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider2, "register(name, T::class.java)");
        TaskProvider task$iv = taskProvider2;
        task$iv.configure(new Action(taskDescription$iv, this_$iv){
            final /* synthetic */ String $taskDescription;
            final /* synthetic */ ReportsVariantApplier this$0;
            {
                this.$taskDescription = $taskDescription;
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull T $this$configure) {
                Intrinsics.checkNotNullParameter($this$configure, "$this$configure");
                $this$configure.setGroup("verification");
                $this$configure.setDescription(this.$taskDescription);
                ((AbstractKoverReportTask)((Object)$this$configure)).getTool().convention(ReportsVariantApplier.access$getToolProvider$p(this.this$0));
                Object[] objectArray = new Object[]{ReportsVariantApplier.access$getReportClasspath$p(this.this$0)};
                ((AbstractKoverReportTask)((Object)$this$configure)).getReportClasspath().from(objectArray);
                objectArray = new Object[]{ReportsVariantApplier.access$getArtifactGenTask$p(this.this$0)};
                $this$configure.dependsOn(objectArray);
                objectArray = new Object[]{this.this$0.getDependencies()};
                $this$configure.dependsOn(objectArray);
                ((AbstractKoverReportTask)((Object)$this$configure)).getLocalArtifact().set(ReportsVariantApplier.access$getArtifactGenTask$p(this.this$0).flatMap((Transformer)createReportTask.1.INSTANCE));
                objectArray = new Object[]{this.this$0.getDependencies()};
                ((AbstractKoverReportTask)((Object)$this$configure)).getExternalArtifacts().from(objectArray);
            }
        });
        this.htmlTask = task$iv;
        this_$iv = this;
        TaskContainer taskContainer4 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer4, "project.tasks");
        $this$createReportTask$iv = taskContainer4;
        name$iv = NamingKt.xmlReportTaskName(this.variantName);
        taskDescription$iv = this.xmlTaskDescription();
        $i$f$createReportTask = false;
        $this$register$iv$iv = $this$createReportTask$iv;
        $i$f$register = false;
        TaskProvider taskProvider3 = $this$register$iv$iv.register(name$iv, KoverXmlTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider3, "register(name, T::class.java)");
        task$iv = taskProvider3;
        task$iv.configure(new /* invalid duplicate definition of identical inner class */);
        this.xmlTask = task$iv;
        this_$iv = this;
        TaskContainer taskContainer5 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer5, "project.tasks");
        $this$createReportTask$iv = taskContainer5;
        name$iv = NamingKt.binaryReportTaskName(this.variantName);
        taskDescription$iv = this.icTaskDescription();
        $i$f$createReportTask = false;
        $this$register$iv$iv = $this$createReportTask$iv;
        $i$f$register = false;
        TaskProvider taskProvider4 = $this$register$iv$iv.register(name$iv, KoverBinaryTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider4, "register(name, T::class.java)");
        task$iv = taskProvider4;
        task$iv.configure(new /* invalid duplicate definition of identical inner class */);
        this.binTask = task$iv;
        this_$iv = this;
        TaskContainer taskContainer6 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer6, "project.tasks");
        $this$createReportTask$iv = taskContainer6;
        name$iv = NamingKt.verifyTaskName(this.variantName);
        taskDescription$iv = this.verifyTaskDescription();
        $i$f$createReportTask = false;
        $this$register$iv$iv = $this$createReportTask$iv;
        $i$f$register = false;
        TaskProvider taskProvider5 = $this$register$iv$iv.register(name$iv, KoverVerifyTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider5, "register(name, T::class.java)");
        task$iv = taskProvider5;
        task$iv.configure(new /* invalid duplicate definition of identical inner class */);
        this.verifyTask = task$iv;
        this_$iv = this;
        TaskContainer taskContainer7 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer7, "project.tasks");
        $this$createReportTask$iv = taskContainer7;
        name$iv = NamingKt.logTaskName(this.variantName);
        taskDescription$iv = this.logTaskDescription();
        $i$f$createReportTask = false;
        $this$register$iv$iv = $this$createReportTask$iv;
        $i$f$register = false;
        TaskProvider taskProvider6 = $this$register$iv$iv.register(name$iv, KoverFormatCoverageTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider6, "register(name, T::class.java)");
        task$iv = taskProvider6;
        task$iv.configure(new /* invalid duplicate definition of identical inner class */);
        this.logTask = task$iv;
        TaskContainer taskContainer8 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue(taskContainer8, "project.tasks");
        $this$createReportTask$iv = taskContainer8;
        name$iv = NamingKt.printLogTaskName(this.variantName);
        boolean $i$f$register3 = false;
        TaskProvider taskProvider7 = $this$register$iv.register(name$iv, KoverPrintLogTask.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider7, "register(name, T::class.java)");
        TaskProvider printCoverageTask = taskProvider7;
        printCoverageTask.configure(new Action(){

            public final void execute(final @NotNull KoverPrintLogTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, "$this$configure");
                $this$configure.getFileWithMessage().convention(logTask.flatMap((Transformer)1.INSTANCE));
                $this$configure.onlyIf(new Spec(){

                    public final boolean isSatisfiedBy(Task it) {
                        return ((File)$this$configure.getFileWithMessage().getAsFile().get()).exists();
                    }
                });
            }
        });
        this.logTask.configure(new Action((TaskProvider<KoverPrintLogTask>)printCoverageTask){
            final /* synthetic */ TaskProvider<KoverPrintLogTask> $printCoverageTask;
            {
                this.$printCoverageTask = $printCoverageTask;
            }

            public final void execute(@NotNull KoverFormatCoverageTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, "$this$configure");
                Object[] objectArray = new Object[]{this.$printCoverageTask};
                $this$configure.finalizedBy(objectArray);
            }
        });
    }

    @NotNull
    protected final NamedDomainObjectProvider<Configuration> getConfig() {
        return this.config;
    }

    @NotNull
    protected final NamedDomainObjectProvider<Configuration> getDependencies() {
        return this.dependencies;
    }

    public final void applyConfig(@NotNull KoverReportsConfigImpl reportConfig, @Nullable KoverReportFiltersImpl commonFilters, @Nullable KoverVerificationRulesConfigImpl commonVerify) {
        Intrinsics.checkNotNullParameter(reportConfig, "reportConfig");
        reportConfig.getBinary$kover_gradle_plugin().getOnCheck().convention((Object)false);
        reportConfig.getBinary$kover_gradle_plugin().getFile().convention(this.project.getLayout().getBuildDirectory().file(PathsKt.binaryReportPath(this.variantName)));
        reportConfig.getXml$kover_gradle_plugin().getTitle().convention((Object)("Kover Gradle Plugin XML report for " + this.project.getPath()));
        List runOnCheck = new ArrayList();
        this.htmlTask.configure(new Action(reportConfig, commonFilters){
            final /* synthetic */ KoverReportsConfigImpl $reportConfig;
            final /* synthetic */ KoverReportFiltersImpl $commonFilters;
            {
                this.$reportConfig = $reportConfig;
                this.$commonFilters = $commonFilters;
            }

            public final void execute(@NotNull KoverHtmlTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                $this$configure.onlyIf(new Spec($this$configure){
                    final /* synthetic */ KoverHtmlTask $this_configure;
                    {
                        this.$this_configure = $this_configure;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        return this.$this_configure.printPath();
                    }
                });
                $this$configure.getReportDir().convention($this$configure.getProject().getLayout().dir((Provider)this.$reportConfig.getHtml$kover_gradle_plugin().getReportDirProperty$kover_gradle_plugin()));
                Property<String> property = $this$configure.getTitle();
                String string = this.$reportConfig.getHtml$kover_gradle_plugin().getTitle();
                if (string == null) {
                    String string2 = $this$configure.getProject().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "project.name");
                }
                property.convention((Object)string);
                $this$configure.getCharset().convention((Object)this.$reportConfig.getHtml$kover_gradle_plugin().getCharset());
                Property<ReportFilters> property2 = $this$configure.getFilters();
                KoverReportFiltersImpl koverReportFiltersImpl = this.$reportConfig.getHtml$kover_gradle_plugin().getFilters$kover_gradle_plugin();
                if (koverReportFiltersImpl == null && (koverReportFiltersImpl = this.$reportConfig.getFilters$kover_gradle_plugin()) == null) {
                    koverReportFiltersImpl = this.$commonFilters;
                }
                property2.set((Object)ReportsVariantApplierKt.access$convert(koverReportFiltersImpl));
            }
        });
        if (reportConfig.getHtml$kover_gradle_plugin().getOnCheck()) {
            ((Collection)runOnCheck).add(this.htmlTask);
        }
        this.xmlTask.configure(new Action(reportConfig, commonFilters){
            final /* synthetic */ KoverReportsConfigImpl $reportConfig;
            final /* synthetic */ KoverReportFiltersImpl $commonFilters;
            {
                this.$reportConfig = $reportConfig;
                this.$commonFilters = $commonFilters;
            }

            public final void execute(@NotNull KoverXmlTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                $this$configure.getReportFile$kover_gradle_plugin().convention($this$configure.getProject().getLayout().file((Provider)this.$reportConfig.getXml$kover_gradle_plugin().getReportFileProperty$kover_gradle_plugin()));
                $this$configure.getTitle().convention((Provider)this.$reportConfig.getXml$kover_gradle_plugin().getTitle());
                Property<ReportFilters> property = $this$configure.getFilters();
                KoverReportFiltersImpl koverReportFiltersImpl = this.$reportConfig.getXml$kover_gradle_plugin().getFilters$kover_gradle_plugin();
                if (koverReportFiltersImpl == null && (koverReportFiltersImpl = this.$reportConfig.getFilters$kover_gradle_plugin()) == null) {
                    koverReportFiltersImpl = this.$commonFilters;
                }
                property.set((Object)ReportsVariantApplierKt.access$convert(koverReportFiltersImpl));
            }
        });
        if (reportConfig.getXml$kover_gradle_plugin().getOnCheck()) {
            ((Collection)runOnCheck).add(this.xmlTask);
        }
        this.binTask.configure(new Action(reportConfig, commonFilters){
            final /* synthetic */ KoverReportsConfigImpl $reportConfig;
            final /* synthetic */ KoverReportFiltersImpl $commonFilters;
            {
                this.$reportConfig = $reportConfig;
                this.$commonFilters = $commonFilters;
            }

            public final void execute(@NotNull KoverBinaryTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                $this$configure.getFile$kover_gradle_plugin().convention((Provider)this.$reportConfig.getBinary$kover_gradle_plugin().getFile());
                Property<ReportFilters> property = $this$configure.getFilters();
                KoverReportFiltersImpl koverReportFiltersImpl = this.$reportConfig.getBinary$kover_gradle_plugin().getFilters$kover_gradle_plugin();
                if (koverReportFiltersImpl == null && (koverReportFiltersImpl = this.$reportConfig.getFilters$kover_gradle_plugin()) == null) {
                    koverReportFiltersImpl = this.$commonFilters;
                }
                property.set((Object)ReportsVariantApplierKt.access$convert(koverReportFiltersImpl));
            }
        });
        Collection collection = runOnCheck;
        Provider provider = reportConfig.getBinary$kover_gradle_plugin().getOnCheck().map(new Transformer(this){
            final /* synthetic */ ReportsVariantApplier this$0;
            {
                this.this$0 = $receiver;
            }

            public final List<TaskProvider<KoverBinaryTask>> transform(boolean run) {
                return run ? CollectionsKt.listOf(ReportsVariantApplier.access$getBinTask$p(this.this$0)) : CollectionsKt.emptyList();
            }
        });
        Intrinsics.checkNotNullExpressionValue(provider, "fun applyConfig(\n       \u2026ndsOn(runOnCheck) }\n    }");
        collection.add(provider);
        this.verifyTask.configure(new Action(reportConfig, commonVerify, this, commonFilters){
            final /* synthetic */ KoverReportsConfigImpl $reportConfig;
            final /* synthetic */ KoverVerificationRulesConfigImpl $commonVerify;
            final /* synthetic */ ReportsVariantApplier this$0;
            final /* synthetic */ KoverReportFiltersImpl $commonFilters;
            {
                this.$reportConfig = $reportConfig;
                this.$commonVerify = $commonVerify;
                this.this$0 = $receiver;
                this.$commonFilters = $commonFilters;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull KoverVerifyTask $this$configure) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                Object object = this.$reportConfig.getVerify$kover_gradle_plugin();
                if (object == null || (object = ((KoverVerificationRulesConfigImpl)object).getRules$kover_gradle_plugin()) == null) {
                    KoverVerificationRulesConfigImpl koverVerificationRulesConfigImpl = this.$commonVerify;
                    object = koverVerificationRulesConfigImpl != null ? koverVerificationRulesConfigImpl.getRules$kover_gradle_plugin() : CollectionsKt.emptyList();
                }
                List<KoverVerifyRuleImpl> resultRules = object;
                Iterable $this$map$iv = resultRules;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KoverVerifyRuleImpl koverVerifyRuleImpl = (KoverVerifyRuleImpl)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ReportsVariantApplierKt.access$convert((KoverVerifyRuleImpl)it));
                }
                List converted = (List)destination$iv$iv;
                $this$configure.getResultFile().convention($this$configure.getProject().getLayout().getBuildDirectory().file(PathsKt.verificationErrorsPath(ReportsVariantApplier.access$getVariantName$p(this.this$0))));
                Property<ReportFilters> property = $this$configure.getFilters();
                Object object2 = this.$reportConfig.getVerify$kover_gradle_plugin();
                if ((object2 == null || (object2 = ((KoverVerifyReportConfigImpl)object2).getFilters$kover_gradle_plugin()) == null) && (object2 = this.$reportConfig.getFilters$kover_gradle_plugin()) == null) {
                    object2 = this.$commonFilters;
                }
                property.set((Object)ReportsVariantApplierKt.access$convert((KoverReportFiltersImpl)object2));
                $this$configure.getRules().addAll((Iterable)converted);
                Object[] objectArray = new Object[]{ReportsVariantApplier.access$getHtmlTask$p(this.this$0)};
                $this$configure.shouldRunAfter(objectArray);
                objectArray = new Object[]{ReportsVariantApplier.access$getXmlTask$p(this.this$0)};
                $this$configure.shouldRunAfter(objectArray);
                objectArray = new Object[]{ReportsVariantApplier.access$getBinTask$p(this.this$0)};
                $this$configure.shouldRunAfter(objectArray);
            }
        });
        KoverVerifyReportConfigImpl koverVerifyReportConfigImpl = reportConfig.getVerify$kover_gradle_plugin();
        boolean bl = koverVerifyReportConfigImpl != null ? koverVerifyReportConfigImpl.getOnCheck() : false;
        if (bl || reportConfig.getVerify$kover_gradle_plugin() == null && Intrinsics.areEqual(this.variantName, "")) {
            ((Collection)runOnCheck).add(this.verifyTask);
        }
        this.logTask.configure(new Action(reportConfig, this, commonFilters){
            final /* synthetic */ KoverReportsConfigImpl $reportConfig;
            final /* synthetic */ ReportsVariantApplier this$0;
            final /* synthetic */ KoverReportFiltersImpl $commonFilters;
            {
                this.$reportConfig = $reportConfig;
                this.this$0 = $receiver;
                this.$commonFilters = $commonFilters;
            }

            public final void execute(@NotNull KoverFormatCoverageTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                $this$configure.getHeader().convention((Object)this.$reportConfig.getLog$kover_gradle_plugin().getHeader());
                Property<String> property = $this$configure.getLineFormat();
                String string = this.$reportConfig.getLog$kover_gradle_plugin().getFormat();
                if (string == null) {
                    string = "<entity> line coverage: <value>%";
                }
                property.convention((Object)string);
                Property<GroupingEntityType> property2 = $this$configure.getGroupBy();
                GroupingEntityType groupingEntityType = this.$reportConfig.getLog$kover_gradle_plugin().getGroupBy();
                if (groupingEntityType == null) {
                    groupingEntityType = GroupingEntityType.APPLICATION;
                }
                property2.convention((Object)((Object)groupingEntityType));
                Property<MetricType> property3 = $this$configure.getCoverageUnits();
                MetricType metricType = this.$reportConfig.getLog$kover_gradle_plugin().getCoverageUnits();
                if (metricType == null) {
                    metricType = MetricType.LINE;
                }
                property3.convention((Object)((Object)metricType));
                Property<AggregationType> property4 = $this$configure.getAggregationForGroup();
                AggregationType aggregationType = this.$reportConfig.getLog$kover_gradle_plugin().getAggregationForGroup();
                if (aggregationType == null) {
                    aggregationType = AggregationType.COVERED_PERCENTAGE;
                }
                property4.convention((Object)((Object)aggregationType));
                $this$configure.getOutputFile().convention($this$configure.getProject().getLayout().getBuildDirectory().file(PathsKt.coverageLogPath(ReportsVariantApplier.access$getVariantName$p(this.this$0))));
                Property<ReportFilters> property5 = $this$configure.getFilters();
                KoverReportFiltersImpl koverReportFiltersImpl = this.$reportConfig.getLog$kover_gradle_plugin().getFilters$kover_gradle_plugin();
                if (koverReportFiltersImpl == null && (koverReportFiltersImpl = this.$reportConfig.getFilters$kover_gradle_plugin()) == null) {
                    koverReportFiltersImpl = this.$commonFilters;
                }
                property5.set((Object)ReportsVariantApplierKt.access$convert(koverReportFiltersImpl));
            }
        });
        if (reportConfig.getLog$kover_gradle_plugin().getOnCheck()) {
            ((Collection)runOnCheck).add(this.logTask);
        }
        this.project.getTasks().matching((Spec)applyConfig.7.INSTANCE).configureEach(new Action(runOnCheck){
            final /* synthetic */ List<Object> $runOnCheck;
            {
                this.$runOnCheck = $runOnCheck;
            }

            public final void execute(@NotNull Task $this$configureEach) {
                Intrinsics.checkNotNullParameter($this$configureEach, "$this$configureEach");
                Object[] objectArray = new Object[]{this.$runOnCheck};
                $this$configureEach.dependsOn(objectArray);
            }
        });
    }

    public static /* synthetic */ void applyConfig$default(ReportsVariantApplier reportsVariantApplier, KoverReportsConfigImpl koverReportsConfigImpl, KoverReportFiltersImpl koverReportFiltersImpl, KoverVerificationRulesConfigImpl koverVerificationRulesConfigImpl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyConfig");
        }
        if ((n & 2) != 0) {
            koverReportFiltersImpl = null;
        }
        if ((n & 4) != 0) {
            koverVerificationRulesConfigImpl = null;
        }
        reportsVariantApplier.applyConfig(koverReportsConfigImpl, koverReportFiltersImpl, koverVerificationRulesConfigImpl);
    }

    public final void mergeWith(@NotNull ReportsVariantApplier otherVariant) {
        Intrinsics.checkNotNullParameter(otherVariant, "otherVariant");
        this.artifactGenTask.configure(new Action(otherVariant){
            final /* synthetic */ ReportsVariantApplier $otherVariant;
            {
                this.$otherVariant = $otherVariant;
            }

            public final void execute(@NotNull KoverArtifactGenerationTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                Object[] objectArray = new Object[]{ReportsVariantApplier.access$getArtifactGenTask$p(this.$otherVariant).map((Transformer)mergeWith.1.INSTANCE), this.$otherVariant.getDependencies()};
                $this$configure.getAdditionalArtifacts().from(objectArray);
                objectArray = new Object[]{ReportsVariantApplier.access$getArtifactGenTask$p(this.$otherVariant), this.$otherVariant.getDependencies()};
                $this$configure.dependsOn(objectArray);
            }
        });
    }

    protected final void applyCommonCompilationKit(@NotNull CompilationKit kit) {
        Intrinsics.checkNotNullParameter(kit, "kit");
        TaskCollection<Test> tests2 = kit.getTests();
        Provider provider = kit.getCompilations().map((Transformer)applyCommonCompilationKit.compilations.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(provider, "kit.compilations.map { it.values }");
        Provider compilations2 = provider;
        Provider provider2 = compilations2.map((Transformer)applyCommonCompilationKit.compileTasks.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(provider2, "compilations.map { unit \u2026Map { it.compileTasks } }");
        Provider compileTasks2 = provider2;
        Provider provider3 = compilations2.map((Transformer)applyCommonCompilationKit.outputs.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(provider3, "compilations.map { unit \u2026.flatMap { it.outputs } }");
        Provider outputs2 = provider3;
        Provider provider4 = compilations2.map((Transformer)applyCommonCompilationKit.sources.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(provider4, "compilations.map { unit \u2026.flatMap { it.sources } }");
        Provider sources2 = provider4;
        Provider provider5 = this.project.getLayout().getBuildDirectory().dir(PathsKt.binReportsRootPath()).map(new Transformer(tests2, this){
            final /* synthetic */ TaskCollection<Test> $tests;
            final /* synthetic */ ReportsVariantApplier this$0;
            {
                this.$tests = $tests;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final List<RegularFile> transform(@NotNull Directory dir) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(dir, "dir");
                Iterable iterable = (Iterable)this.$tests;
                ReportsVariantApplier reportsVariantApplier = this.this$0;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Test test = (Test)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "it.name");
                    collection.add(dir.file(NamingKt.binReportName(string, ((CoverageTool)ReportsVariantApplier.access$getToolProvider$p(reportsVariantApplier).get()).getVariant().getVendor())));
                }
                return (List)destination$iv$iv;
            }
        });
        Intrinsics.checkNotNullExpressionValue(provider5, "protected fun applyCommo\u2026ortFiles)\n        }\n    }");
        Provider binReportFiles2 = provider5;
        this.artifactGenTask.configure(new Action(tests2, (Provider<List<Task>>)compileTasks2, (Provider<List<File>>)sources2, (Provider<List<File>>)outputs2, (Provider<List<RegularFile>>)binReportFiles2){
            final /* synthetic */ TaskCollection<Test> $tests;
            final /* synthetic */ Provider<List<Task>> $compileTasks;
            final /* synthetic */ Provider<List<File>> $sources;
            final /* synthetic */ Provider<List<File>> $outputs;
            final /* synthetic */ Provider<List<RegularFile>> $binReportFiles;
            {
                this.$tests = $tests;
                this.$compileTasks = $compileTasks;
                this.$sources = $sources;
                this.$outputs = $outputs;
                this.$binReportFiles = $binReportFiles;
            }

            public final void execute(@NotNull KoverArtifactGenerationTask $this$configure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), "$this$configure");
                Object[] objectArray = new Object[]{this.$tests};
                $this$configure.dependsOn(objectArray);
                objectArray = new Object[]{this.$compileTasks};
                $this$configure.dependsOn(objectArray);
                objectArray = new Object[]{this.$sources};
                $this$configure.getSources().from(objectArray);
                objectArray = new Object[]{this.$outputs};
                $this$configure.getOutputDirs().from(objectArray);
                objectArray = new Object[]{this.$binReportFiles};
                $this$configure.getReports().from(objectArray);
            }
        });
    }

    private final /* synthetic */ <T extends AbstractKoverReportTask> TaskProvider<T> createReportTask(TaskContainer $this$createReportTask, String name, String taskDescription) {
        boolean $i$f$createReportTask = false;
        TaskContainer $this$register$iv = $this$createReportTask;
        boolean $i$f$register = false;
        Intrinsics.reifiedOperationMarker(4, "T");
        TaskProvider taskProvider = $this$register$iv.register(name, Task.class);
        Intrinsics.checkNotNullExpressionValue(taskProvider, "register(name, T::class.java)");
        TaskProvider task = taskProvider;
        task.configure(new /* invalid duplicate definition of identical inner class */);
        return task;
    }

    private final String xmlTaskDescription() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = "Task to generate XML coverage report for JVM project or Kotlin/MPP JVM targets. Android measurements for specific build variant can be merged";
                break;
            }
            case 2: {
                string = "Task to generate XML coverage report for '" + this.variantName + "' Android build variant";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String icTaskDescription() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = "Task to generate binary coverage report in IntelliJ format for JVM project or Kotlin/MPP JVM targets. Android measurements for specific build variant can be merged";
                break;
            }
            case 2: {
                string = "Task to generate binary coverage report in IntelliJ format for '" + this.variantName + "' Android build variant";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String htmlTaskDescription() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = "Task to generate HTML coverage report for JVM project or Kotlin/MPP JVM targets. Android measurements for specific build variant can be merged";
                break;
            }
            case 2: {
                string = "Task to generate HTML coverage report for '" + this.variantName + "' Android build variant";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String verifyTaskDescription() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = "Task to validate coverage bounding rules for JVM project or Kotlin/MPP JVM targets. Android measurements for specific build variant can be merged";
                break;
            }
            case 2: {
                string = "Task to validate coverage bounding rules for '" + this.variantName + "' Android build variant";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String logTaskDescription() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = "Task to print coverage to log for JVM project or Kotlin/MPP JVM targets. Android measurements for specific build variant can be merged";
                break;
            }
            case 2: {
                string = "Task to print coverage to log for '" + this.variantName + "' Android build variant";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final /* synthetic */ TaskProvider access$getBinTask$p(ReportsVariantApplier $this) {
        return $this.binTask;
    }

    public static final /* synthetic */ TaskProvider access$getHtmlTask$p(ReportsVariantApplier $this) {
        return $this.htmlTask;
    }

    public static final /* synthetic */ TaskProvider access$getXmlTask$p(ReportsVariantApplier $this) {
        return $this.xmlTask;
    }

    public static final /* synthetic */ Provider access$getToolProvider$p(ReportsVariantApplier $this) {
        return $this.toolProvider;
    }

    public static final /* synthetic */ Configuration access$getReportClasspath$p(ReportsVariantApplier $this) {
        return $this.reportClasspath;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportsVariantType.values().length];
            try {
                nArray[ReportsVariantType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportsVariantType.ANDROID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

