/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report;

import io.github.surpsg.deltacoverage.config.CoverageRulesConfig;
import io.github.surpsg.deltacoverage.exception.CoverageViolatedException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006\f"}, d2={"Lio/github/surpsg/deltacoverage/report/CoverageViolationsPropagator;", "", "()V", "propagate", "", "coverageRulesConfig", "Lio/github/surpsg/deltacoverage/config/CoverageRulesConfig;", "violations", "", "", "throwIfCoverageViolated", "Companion", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nCoverageViolationsPropagator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageViolationsPropagator.kt\nio/github/surpsg/deltacoverage/report/CoverageViolationsPropagator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1855#2,2:36\n*S KotlinDebug\n*F\n+ 1 CoverageViolationsPropagator.kt\nio/github/surpsg/deltacoverage/report/CoverageViolationsPropagator\n*L\n18#1:36,2\n*E\n"})
public final class CoverageViolationsPropagator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    public final void propagate(@NotNull CoverageRulesConfig coverageRulesConfig2, @NotNull List<String> violations) {
        Intrinsics.checkNotNullParameter(coverageRulesConfig2, "coverageRulesConfig");
        Intrinsics.checkNotNullParameter(violations, "violations");
        log.info("Fail on violations: {}. Found violations: {}.", (Object)coverageRulesConfig2.getFailOnViolation(), (Object)violations.size());
        if (coverageRulesConfig2.getFailOnViolation()) {
            this.throwIfCoverageViolated(violations);
        } else {
            Iterable $this$forEach$iv = violations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String violation = (String)element$iv;
                boolean bl = false;
                log.warn(violation);
            }
        }
    }

    private final void throwIfCoverageViolated(List<String> violations) {
        if (!((Collection)violations).isEmpty()) {
            String errorDetails = CollectionsKt.joinToString$default(violations, ";\n", null, null, 0, null, null, 62, null);
            throw new CoverageViolatedException(errorDetails);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(CoverageViolationsPropagator.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/surpsg/deltacoverage/report/CoverageViolationsPropagator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "delta-coverage-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

