/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.gradle;

import io.github.surpsg.deltacoverage.CoverageEngine;
import io.github.surpsg.deltacoverage.config.CoverageRulesConfig;
import io.github.surpsg.deltacoverage.config.DeltaCoverageConfig;
import io.github.surpsg.deltacoverage.config.DiffSourceConfig;
import io.github.surpsg.deltacoverage.config.ReportConfig;
import io.github.surpsg.deltacoverage.config.ReportsConfig;
import io.github.surpsg.deltacoverage.config.ViolationRule;
import io.github.surpsg.deltacoverage.gradle.CoverageEntity;
import io.github.surpsg.deltacoverage.gradle.DeltaCoverageConfiguration;
import io.github.surpsg.deltacoverage.gradle.DeltaCoverageTask;
import io.github.surpsg.deltacoverage.gradle.DiffSourceConfiguration;
import io.github.surpsg.deltacoverage.gradle.ViolationRule;
import io.github.surpsg.deltacoverage.gradle.ViolationRules;
import io.github.surpsg.deltacoverage.report.DeltaReportFacadeFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0007J\b\u0010(\u001a\u00020\u0010H\u0007J\b\u0010)\u001a\u00020\u0010H\u0002J\f\u0010*\u001a\u00020+*\u00020\u001aH\u0002R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006-"}, d2={"Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "classesFiles", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/file/FileCollection;", "getClassesFiles", "()Lorg/gradle/api/provider/Property;", "coverageBinaryFiles", "getCoverageBinaryFiles", "deltaCoverageConfigProperty", "Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "getDeltaCoverageConfigProperty", "projectDirProperty", "Ljava/io/File;", "getProjectDirProperty", "()Ljava/io/File;", "rootProjectDirProperty", "getRootProjectDirProperty", "sourcesFiles", "getSourcesFiles", "buildCoreViolationRule", "Lio/github/surpsg/deltacoverage/config/ViolationRule;", "entity", "Lio/github/surpsg/deltacoverage/gradle/CoverageEntity;", "rule", "Lio/github/surpsg/deltacoverage/gradle/ViolationRule;", "buildCoverageRulesConfig", "Lio/github/surpsg/deltacoverage/config/CoverageRulesConfig;", "diffCovConfig", "buildDeltaCoverageConfig", "Lio/github/surpsg/deltacoverage/config/DeltaCoverageConfig;", "buildDiffSourceConfig", "Lio/github/surpsg/deltacoverage/config/DiffSourceConfig;", "diffSource", "Lio/github/surpsg/deltacoverage/gradle/DiffSourceConfiguration;", "executeAction", "", "getOutputDir", "getReportOutputDir", "mapToCoreCoverageEntity", "Lio/github/surpsg/deltacoverage/config/CoverageEntity;", "Companion", "delta-coverage-gradle"})
public class DeltaCoverageTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Property<FileCollection> coverageBinaryFiles;
    @NotNull
    private final Property<FileCollection> sourcesFiles;
    @NotNull
    private final Property<FileCollection> classesFiles;
    @Nested
    @NotNull
    private final Property<DeltaCoverageConfiguration> deltaCoverageConfigProperty;
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String BASE_COVERAGE_REPORTS_DIR = "coverage-reports";

    @Inject
    public DeltaCoverageTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter(objectFactory, "objectFactory");
        this.setGroup("verification");
        this.setDescription("Builds coverage report only for modified code");
        this.getOutputs().upToDateWhen(arg_0 -> DeltaCoverageTask._init_$lambda$0(1.INSTANCE, arg_0));
        Property property = objectFactory.property(FileCollection.class);
        Intrinsics.checkNotNullExpressionValue(property, "property(...)");
        this.coverageBinaryFiles = property;
        Property property2 = objectFactory.property(FileCollection.class);
        Intrinsics.checkNotNullExpressionValue(property2, "property(...)");
        this.sourcesFiles = property2;
        Property property3 = objectFactory.property(FileCollection.class);
        Intrinsics.checkNotNullExpressionValue(property3, "property(...)");
        this.classesFiles = property3;
        Property property4 = objectFactory.property(DeltaCoverageConfiguration.class);
        Intrinsics.checkNotNullExpressionValue(property4, "property(...)");
        this.deltaCoverageConfigProperty = property4;
    }

    @InputFiles
    @NotNull
    public final Property<FileCollection> getCoverageBinaryFiles() {
        return this.coverageBinaryFiles;
    }

    @InputFiles
    @NotNull
    public final Property<FileCollection> getSourcesFiles() {
        return this.sourcesFiles;
    }

    @InputFiles
    @NotNull
    public final Property<FileCollection> getClassesFiles() {
        return this.classesFiles;
    }

    @NotNull
    public final Property<DeltaCoverageConfiguration> getDeltaCoverageConfigProperty() {
        return this.deltaCoverageConfigProperty;
    }

    private final File getProjectDirProperty() {
        File file = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue(file, "getProjectDir(...)");
        return file;
    }

    private final File getRootProjectDirProperty() {
        File file = this.getProject().getRootProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue(file, "getProjectDir(...)");
        return file;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File reportOutputDir = this.getReportOutputDir();
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[]{reportOutputDir.getAbsolutePath(), reportOutputDir.exists(), reportOutputDir.isDirectory(), reportOutputDir.canRead(), reportOutputDir.canWrite()};
            log.debug("Delta Coverage output dir: {}, exists={}, isDir={}, canRead={}, canWrite={}", objectArray);
        }
        return reportOutputDir;
    }

    @TaskAction
    public final void executeAction() {
        File file;
        log.info("Delta-Coverage plugin configuration: " + this.deltaCoverageConfigProperty.get());
        File $this$executeAction_u24lambda_u241 = file = this.getOutputDir();
        boolean bl = false;
        boolean isCreated = $this$executeAction_u24lambda_u241.mkdirs();
        log.debug("Creating of report dir '" + $this$executeAction_u24lambda_u241.getAbsolutePath() + "' is successful: " + isCreated);
        File reportDir = file;
        DeltaCoverageConfig deltaCoverageConfig = this.buildDeltaCoverageConfig();
        if (log.isDebugEnabled()) {
            log.debug("Run Delta-Coverage with config: {}", (Object)deltaCoverageConfig);
        }
        File file2 = this.getRootProjectDirProperty();
        Object object = ((DeltaCoverageConfiguration)this.deltaCoverageConfigProperty.get()).getCoverage().getEngine().get();
        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
        DeltaReportFacadeFactory.INSTANCE.buildFacade(file2, (CoverageEngine)((Object)object), deltaCoverageConfig).saveDiffTo(reportDir, executeAction.1.INSTANCE).generateReport();
    }

    private final File getReportOutputDir() {
        Object object = ((DeltaCoverageConfiguration)this.deltaCoverageConfigProperty.get()).getReportConfiguration().getBaseReportDir().get();
        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
        String baseReportDirPath = (String)object;
        File file = new File(baseReportDirPath);
        return FilesKt.resolve(file.isAbsolute() ? file : FilesKt.resolve(this.getProjectDirProperty(), baseReportDirPath), BASE_COVERAGE_REPORTS_DIR);
    }

    private final DeltaCoverageConfig buildDeltaCoverageConfig() {
        Object object = this.deltaCoverageConfigProperty.get();
        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
        DeltaCoverageConfiguration deltaCovConfig = (DeltaCoverageConfiguration)object;
        return DeltaCoverageConfig.Companion.invoke((Function1<? super DeltaCoverageConfig.Builder, Unit>)new Function1<DeltaCoverageConfig.Builder, Unit>(this, deltaCovConfig){
            final /* synthetic */ DeltaCoverageTask this$0;
            final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
            {
                this.this$0 = $receiver;
                this.$deltaCovConfig = $deltaCovConfig;
                super(1);
            }

            public final void invoke(@NotNull DeltaCoverageConfig.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                String string = DeltaCoverageTask.access$getProjectDirProperty(this.this$0).getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                $this$invoke.setReportName(string);
                $this$invoke.setDiffSourceConfig(DeltaCoverageTask.access$buildDiffSourceConfig(this.this$0, this.$deltaCovConfig.getDiffSource()));
                Collection collection = $this$invoke.getBinaryCoverageFiles();
                Set set = ((FileCollection)this.this$0.getCoverageBinaryFiles().get()).getFiles();
                Intrinsics.checkNotNullExpressionValue(set, "getFiles(...)");
                CollectionsKt.addAll(collection, set);
                collection = $this$invoke.getSourceFiles();
                Set set2 = ((FileCollection)this.this$0.getSourcesFiles().get()).getFiles();
                Intrinsics.checkNotNullExpressionValue(set2, "getFiles(...)");
                CollectionsKt.addAll(collection, set2);
                collection = $this$invoke.getClassFiles();
                Set set3 = ((FileCollection)this.this$0.getClassesFiles().get()).getFiles();
                Intrinsics.checkNotNullExpressionValue(set3, "getFiles(...)");
                CollectionsKt.addAll(collection, set3);
                $this$invoke.setReportsConfig(ReportsConfig.Companion.invoke((Function1<? super ReportsConfig.Builder, Unit>)new Function1<ReportsConfig.Builder, Unit>(this.this$0, this.$deltaCovConfig){
                    final /* synthetic */ DeltaCoverageTask this$0;
                    final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
                    {
                        this.this$0 = $receiver;
                        this.$deltaCovConfig = $deltaCovConfig;
                        super(1);
                    }

                    public final void invoke(@NotNull ReportsConfig.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        String string = DeltaCoverageTask.access$getReportOutputDir(this.this$0).getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                        $this$invoke.setBaseReportDir(string);
                        $this$invoke.setHtml(ReportConfig.Companion.invoke((Function1<? super ReportConfig.Builder, Unit>)new Function1<ReportConfig.Builder, Unit>(this.$deltaCovConfig){
                            final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
                            {
                                this.$deltaCovConfig = $deltaCovConfig;
                                super(1);
                            }

                            public final void invoke(@NotNull ReportConfig.Builder $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                $this$invoke.setOutputFileName("html");
                                Object object = this.$deltaCovConfig.getReportConfiguration().getHtml().get();
                                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                                $this$invoke.setEnabled((Boolean)object);
                            }
                        }));
                        $this$invoke.setCsv(ReportConfig.Companion.invoke((Function1<? super ReportConfig.Builder, Unit>)new Function1<ReportConfig.Builder, Unit>(this.$deltaCovConfig){
                            final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
                            {
                                this.$deltaCovConfig = $deltaCovConfig;
                                super(1);
                            }

                            public final void invoke(@NotNull ReportConfig.Builder $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                $this$invoke.setOutputFileName("report.csv");
                                Object object = this.$deltaCovConfig.getReportConfiguration().getCsv().get();
                                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                                $this$invoke.setEnabled((Boolean)object);
                            }
                        }));
                        $this$invoke.setXml(ReportConfig.Companion.invoke((Function1<? super ReportConfig.Builder, Unit>)new Function1<ReportConfig.Builder, Unit>(this.$deltaCovConfig){
                            final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
                            {
                                this.$deltaCovConfig = $deltaCovConfig;
                                super(1);
                            }

                            public final void invoke(@NotNull ReportConfig.Builder $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                $this$invoke.setOutputFileName("report.xml");
                                Object object = this.$deltaCovConfig.getReportConfiguration().getXml().get();
                                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                                $this$invoke.setEnabled((Boolean)object);
                            }
                        }));
                        $this$invoke.setConsole(ReportConfig.Companion.invoke((Function1<? super ReportConfig.Builder, Unit>)new Function1<ReportConfig.Builder, Unit>(this.$deltaCovConfig){
                            final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
                            {
                                this.$deltaCovConfig = $deltaCovConfig;
                                super(1);
                            }

                            public final void invoke(@NotNull ReportConfig.Builder $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                $this$invoke.setOutputFileName("console.txt");
                                Object object = this.$deltaCovConfig.getReportConfiguration().getConsole().get();
                                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                                $this$invoke.setEnabled((Boolean)object);
                            }
                        }));
                        $this$invoke.setMarkdown(ReportConfig.Companion.invoke((Function1<? super ReportConfig.Builder, Unit>)new Function1<ReportConfig.Builder, Unit>(this.$deltaCovConfig){
                            final /* synthetic */ DeltaCoverageConfiguration $deltaCovConfig;
                            {
                                this.$deltaCovConfig = $deltaCovConfig;
                                super(1);
                            }

                            public final void invoke(@NotNull ReportConfig.Builder $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                $this$invoke.setOutputFileName("report.md");
                                Object object = this.$deltaCovConfig.getReportConfiguration().getMarkdown().get();
                                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                                $this$invoke.setEnabled((Boolean)object);
                            }
                        }));
                        Object object = this.$deltaCovConfig.getReportConfiguration().getFullCoverageReport().get();
                        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                        $this$invoke.setFullCoverageReport((Boolean)object);
                    }
                }));
                $this$invoke.setCoverageRulesConfig(DeltaCoverageTask.access$buildCoverageRulesConfig(this.this$0, this.$deltaCovConfig));
            }
        });
    }

    private final DiffSourceConfig buildDiffSourceConfig(DiffSourceConfiguration diffSource) {
        return DiffSourceConfig.Companion.invoke((Function1<? super DiffSourceConfig.Builder, Unit>)new Function1<DiffSourceConfig.Builder, Unit>(diffSource){
            final /* synthetic */ DiffSourceConfiguration $diffSource;
            {
                this.$diffSource = $diffSource;
                super(1);
            }

            public final void invoke(@NotNull DiffSourceConfig.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object object = this.$diffSource.getGit().getUseNativeGit().get();
                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                if (((Boolean)object).booleanValue()) {
                    String string = ((RegularFile)this.$diffSource.getGit().getNativeGitDiffFile$delta_coverage_gradle().get()).getAsFile().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                    $this$invoke.setFile(string);
                } else {
                    Object object2 = this.$diffSource.getFile().get();
                    Intrinsics.checkNotNullExpressionValue(object2, "get(...)");
                    $this$invoke.setFile((String)object2);
                    Object object3 = this.$diffSource.getUrl().get();
                    Intrinsics.checkNotNullExpressionValue(object3, "get(...)");
                    $this$invoke.setUrl((String)object3);
                    Object object4 = this.$diffSource.getGit().getDiffBase().get();
                    Intrinsics.checkNotNullExpressionValue(object4, "get(...)");
                    $this$invoke.setDiffBase((String)object4);
                }
            }
        });
    }

    private final CoverageRulesConfig buildCoverageRulesConfig(DeltaCoverageConfiguration diffCovConfig) {
        return CoverageRulesConfig.Companion.invoke((Function1<? super CoverageRulesConfig.Builder, Unit>)new Function1<CoverageRulesConfig.Builder, Unit>(diffCovConfig, this){
            final /* synthetic */ DeltaCoverageConfiguration $diffCovConfig;
            final /* synthetic */ DeltaCoverageTask this$0;
            {
                this.$diffCovConfig = $diffCovConfig;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CoverageRulesConfig.Builder $this$invoke) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                ViolationRules rules = this.$diffCovConfig.getViolationRules();
                Collection collection = $this$invoke.getViolationRules();
                Object object = rules.getRules().get();
                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                Object object2 = (Map)object;
                DeltaCoverageTask deltaCoverageTask2 = this.this$0;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator2.next();
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    CoverageEntity entity = (CoverageEntity)((Object)entry.getKey());
                    ViolationRule rule = (ViolationRule)entry.getValue();
                    Intrinsics.checkNotNull((Object)((Object)entity));
                    Intrinsics.checkNotNull(rule);
                    collection2.add(DeltaCoverageTask.access$buildCoreViolationRule(deltaCoverageTask2, entity, rule));
                }
                object2 = (List)destination$iv$iv;
                CollectionsKt.addAll(collection, object2);
                Object object3 = rules.getFailOnViolation().get();
                Intrinsics.checkNotNullExpressionValue(object3, "get(...)");
                $this$invoke.setFailOnViolation((Boolean)object3);
            }
        });
    }

    private final io.github.surpsg.deltacoverage.config.ViolationRule buildCoreViolationRule(CoverageEntity entity, ViolationRule rule) {
        return io.github.surpsg.deltacoverage.config.ViolationRule.Companion.invoke((Function1<? super ViolationRule.Builder, Unit>)new Function1<ViolationRule.Builder, Unit>(this, entity, rule){
            final /* synthetic */ DeltaCoverageTask this$0;
            final /* synthetic */ CoverageEntity $entity;
            final /* synthetic */ ViolationRule $rule;
            {
                this.this$0 = $receiver;
                this.$entity = $entity;
                this.$rule = $rule;
                super(1);
            }

            public final void invoke(@NotNull ViolationRule.Builder $this$invoke) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                    $this$invoke.setCoverageEntity(DeltaCoverageTask.access$mapToCoreCoverageEntity(this.this$0, this.$entity));
                    Object object = this.$rule.getMinCoverageRatio().get();
                    Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                    $this$invoke.setMinCoverageRatio(((Number)object).doubleValue());
                    Integer n = (Integer)this.$rule.getEntityCountThreshold().getOrNull();
                    if (n == null) break block0;
                    Integer threshold = n;
                    boolean bl = false;
                    $this$invoke.setEntityCountThreshold(threshold);
                }
            }
        });
    }

    private final io.github.surpsg.deltacoverage.config.CoverageEntity mapToCoreCoverageEntity(CoverageEntity $this$mapToCoreCoverageEntity) {
        io.github.surpsg.deltacoverage.config.CoverageEntity coverageEntity;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mapToCoreCoverageEntity.ordinal()]) {
            case 1: {
                coverageEntity = io.github.surpsg.deltacoverage.config.CoverageEntity.INSTRUCTION;
                break;
            }
            case 2: {
                coverageEntity = io.github.surpsg.deltacoverage.config.CoverageEntity.BRANCH;
                break;
            }
            case 3: {
                coverageEntity = io.github.surpsg.deltacoverage.config.CoverageEntity.LINE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coverageEntity;
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ File access$getProjectDirProperty(DeltaCoverageTask $this) {
        return $this.getProjectDirProperty();
    }

    public static final /* synthetic */ DiffSourceConfig access$buildDiffSourceConfig(DeltaCoverageTask $this, DiffSourceConfiguration diffSource) {
        return $this.buildDiffSourceConfig(diffSource);
    }

    public static final /* synthetic */ File access$getReportOutputDir(DeltaCoverageTask $this) {
        return $this.getReportOutputDir();
    }

    public static final /* synthetic */ CoverageRulesConfig access$buildCoverageRulesConfig(DeltaCoverageTask $this, DeltaCoverageConfiguration diffCovConfig) {
        return $this.buildCoverageRulesConfig(diffCovConfig);
    }

    public static final /* synthetic */ io.github.surpsg.deltacoverage.config.ViolationRule access$buildCoreViolationRule(DeltaCoverageTask $this, CoverageEntity entity, ViolationRule rule) {
        return $this.buildCoreViolationRule(entity, rule);
    }

    public static final /* synthetic */ io.github.surpsg.deltacoverage.config.CoverageEntity access$mapToCoreCoverageEntity(DeltaCoverageTask $this, CoverageEntity $receiver) {
        return $this.mapToCoreCoverageEntity($receiver);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DeltaCoverageTask.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageTask$Companion;", "", "()V", "BASE_COVERAGE_REPORTS_DIR", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "delta-coverage-gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CoverageEntity.values().length];
            try {
                nArray[CoverageEntity.INSTRUCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageEntity.BRANCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageEntity.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

