/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.DirectorySourceCodeProvider;
import com.intellij.rt.coverage.report.ReportLoadStrategy;
import com.intellij.rt.coverage.report.XMLCoverageReport;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.SourceCodeProvider;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.idea.IDEACoverageData;
import jetbrains.coverage.report.impl.html.HTMLReportBuilderImpl;

public class Reporter {
    private final ReportLoadStrategy myLoad;

    public Reporter(ReportLoadStrategy loadStrategy) {
        this.myLoad = loadStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createXMLReport(File xmlFile) throws IOException {
        XMLCoverageReport report = new XMLCoverageReport();
        FileOutputStream out = null;
        try {
            xmlFile.getParentFile().mkdirs();
            out = new FileOutputStream(xmlFile);
            report.write(out, this.myLoad.getProjectData());
        }
        catch (Throwable throwable) {
            CoverageIOUtil.close(out);
            throw throwable;
        }
        CoverageIOUtil.close(out);
    }

    public void createHTMLReport(File htmlDir, String title, String charset) throws IOException {
        htmlDir.mkdirs();
        HTMLReportBuilder builder = ReportBuilderFactory.createHTMLReportBuilderForKover();
        builder.setReportDir(htmlDir);
        if (builder instanceof HTMLReportBuilderImpl) {
            if (title != null) {
                ((HTMLReportBuilderImpl)builder).setReportTitle(title);
            }
            if (charset != null) {
                ((HTMLReportBuilderImpl)builder).setCharset(charset);
            }
        }
        DirectorySourceCodeProvider sourceCodeProvider = new DirectorySourceCodeProvider(this.myLoad.getProjectData(), this.myLoad.getSources());
        builder.generateReport(new IDEACoverageData(this.myLoad.getProjectData(), (SourceCodeProvider)sourceCodeProvider));
    }

    public ProjectData getProjectData() {
        return this.myLoad.getProjectData();
    }
}

