/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrument;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrument.ClassLengthAnalyser;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public class OfflineCoverageTransformer
extends CoverageTransformer {
    public OfflineCoverageTransformer(ProjectData data, boolean shouldSaveSource) {
        super(data, shouldSaveSource);
    }

    @Override
    protected CoverageDataAccess.Init createInit(String className, ClassReader cr, boolean needCache) {
        int length = OfflineCoverageTransformer.getRequiredArrayLength(cr);
        String arrayType = this.calculateHits ? "[I" : "[Z";
        String methodName = this.calculateHits ? "getOrCreateHits" : "getOrCreateHitsMask";
        return new CoverageDataAccess.Init("__$hits$__", arrayType, "com/intellij/rt/coverage/offline/RawProjectInit", methodName, "(Ljava/lang/String;I)" + arrayType, new Object[]{className, length});
    }

    @Override
    protected CoverageDataAccess.Init createCondyInit(String className, ClassReader cr) {
        int length = OfflineCoverageTransformer.getRequiredArrayLength(cr);
        String arrayType = this.calculateHits ? "[I" : "[Z";
        String methodName = this.calculateHits ? "getOrCreateHits" : "getOrCreateHitsMask";
        return new CoverageDataAccess.Init("__$hits$__", arrayType, "com/intellij/rt/coverage/offline/CondyUtils", methodName, "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;I)" + arrayType, new Object[]{className, length});
    }

    private static int getRequiredArrayLength(ClassReader cr) {
        return OfflineCoverageTransformer.analyseClassLength(cr).getHits();
    }

    private static ClassLengthAnalyser analyseClassLength(ClassReader cr) {
        ClassLengthAnalyser analyser = new ClassLengthAnalyser();
        cr.accept(analyser, 4);
        return analyser;
    }
}

