/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrument;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrument.DirectoryVisitor;
import com.intellij.rt.coverage.instrument.IOUtil;
import com.intellij.rt.coverage.instrument.OfflineCoverageTransformer;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Instrumentator {
    private final List<File> myRoots;
    private final List<File> myOutputRoots;
    private final Filters myFilters;

    public Instrumentator(List<File> roots, List<File> outputRoots, Filters filters) {
        this.myRoots = roots;
        this.myOutputRoots = outputRoots;
        this.myFilters = filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instrument(boolean countHits) {
        for (int i = 0; i < this.myRoots.size(); ++i) {
            File root = this.myRoots.get(i);
            File outputRoot = this.myOutputRoots.get(i);
            boolean calculateHitsCount = OptionsUtil.CALCULATE_HITS_COUNT;
            try {
                OptionsUtil.CALCULATE_HITS_COUNT = countHits;
                new InstrumentationVisitor(root, outputRoot).visitFiles();
                continue;
            }
            finally {
                OptionsUtil.CALCULATE_HITS_COUNT = calculateHitsCount;
            }
        }
    }

    private class InstrumentationVisitor
    extends DirectoryVisitor {
        private final File myOutput;
        private final CoverageTransformer myTransformer;

        private InstrumentationVisitor(File root, File output) {
            super(root);
            this.myOutput = output;
            ProjectData projectData = new ProjectData();
            projectData.setAnnotationsToIgnore(((Instrumentator)Instrumentator.this).myFilters.excludeAnnotations);
            this.myTransformer = new OfflineCoverageTransformer(projectData, false);
        }

        @Override
        protected void visitFile(String packageName, File file) {
            try {
                File directory;
                byte[] bytes = IOUtil.readBytes(file);
                if (file.getName().endsWith(".class")) {
                    String classSimpleName = ClassNameUtil.removeClassSuffix(file.getName());
                    String className = packageName.isEmpty() ? classSimpleName : ClassNameUtil.convertToInternalName(packageName) + "/" + classSimpleName;
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    byte[] transformed = this.myTransformer.transform(loader, className, null, null, bytes);
                    if (transformed != null) {
                        bytes = transformed;
                    }
                }
                if (!(directory = new File(this.myOutput, packageName.replace(".", File.separator))).exists() && !directory.mkdirs()) {
                    throw new RuntimeException("Failed to create directory at " + directory.getAbsolutePath());
                }
                File newFile = new File(directory, file.getName());
                IOUtil.writeBytes(newFile, bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

