/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrument;

import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class ClassLengthAnalyser
extends ClassVisitor {
    private int myHits = 0;

    public ClassLengthAnalyser() {
        super(589824);
    }

    public int getHits() {
        return this.myHits;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodVisitor(589824, mv){

            @Override
            public void visitJumpInsn(int opcode, Label label) {
                super.visitJumpInsn(opcode, label);
                ClassLengthAnalyser.this.myHits = ClassLengthAnalyser.this.myHits + 2;
            }

            @Override
            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                super.visitTableSwitchInsn(min, max, dflt, labels);
                ClassLengthAnalyser.this.myHits = ClassLengthAnalyser.this.myHits + (1 + labels.length);
            }

            @Override
            public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
                super.visitLookupSwitchInsn(dflt, keys2, labels);
                ClassLengthAnalyser.this.myHits = ClassLengthAnalyser.this.myHits + (1 + labels.length);
            }

            @Override
            public void visitLineNumber(int line2, Label start) {
                super.visitLineNumber(line2, start);
                ClassLengthAnalyser.this.myHits++;
            }
        };
    }
}

