/*
 * Decompiled with CFR 0.152.
 */
package io.github.summercattle.commons.webflux.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.github.summercattle.commons.webflux.codec.FastJsonCodecSupport;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FastJsonEncoder
extends FastJsonCodecSupport
implements Encoder<Object> {
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class clazz = elementType.toClass();
        return this.supportsMimeType(mimeType) && (Object.class == clazz || !String.class.isAssignableFrom(elementType.resolve(clazz)) && (JSONObject.class == elementType.resolve(clazz) || JSONArray.class == elementType.resolve(clazz)));
    }

    public Flux<DataBuffer> encode(Publisher<? extends Object> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (inputStream instanceof Mono) {
            return Mono.from(inputStream).map(value -> this.encodeValue(value, bufferFactory)).flux();
        }
        return null;
    }

    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.encodeValue(value, bufferFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory) {
        DataBuffer buffer = bufferFactory.allocateBuffer();
        boolean release = true;
        try {
            byte[] bytes = JSON.toJSONBytes((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect});
            buffer.write(bytes);
            release = false;
            DataBuffer dataBuffer = buffer;
            return dataBuffer;
        }
        finally {
            if (release) {
                DataBufferUtils.release((DataBuffer)buffer);
            }
        }
    }

    public List<MimeType> getEncodableMimeTypes() {
        return this.getMimeTypes();
    }
}

