/*
 * Decompiled with CFR 0.152.
 */
package io.github.summercattle.commons.webflux.codec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.github.summercattle.commons.utils.exception.ExceptionWrapUtils;
import io.github.summercattle.commons.webflux.codec.FastJsonCodecSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FastJsonDecoder
extends FastJsonCodecSupport
implements Decoder<Object> {
    public boolean canDecode(ResolvableType elementType, MimeType mimeType) {
        return !CharSequence.class.isAssignableFrom(elementType.toClass()) && this.supportsMimeType(mimeType);
    }

    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Flux.from(inputStream).map(buffer -> this.decode((DataBuffer)buffer, elementType));
    }

    public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return DataBufferUtils.join(inputStream).map(dataBuffer -> this.decode((DataBuffer)dataBuffer, elementType));
    }

    private Object decode(DataBuffer buffer, ResolvableType elementType) {
        try {
            InputStream is = buffer.asInputStream();
            Class clazz = elementType.toClass();
            Object object = JSON.parseObject((InputStream)is, (Type)clazz, (Feature[])new Feature[0]);
            return object;
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrapRuntime((Throwable)e);
        }
        finally {
            DataBufferUtils.release((DataBuffer)buffer);
        }
    }

    public List<MimeType> getDecodableMimeTypes() {
        return this.getMimeTypes();
    }
}

