/*
 * Decompiled with CFR 0.152.
 */
package io.github.sukgu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shadow {
    WebDriver driver;
    WebDriverException exception;
    WebDriverWait wait;
    CommandExecutor executer;
    SessionId sessionId;
    ChromeDriver chromeDriver;
    FirefoxDriver firfoxDriver;
    InternetExplorerDriver ieDriver;
    RemoteWebDriver remoteWebDriver;

    public Shadow(WebDriver driver) {
        if (driver instanceof ChromeDriver) {
            this.sessionId = ((ChromeDriver)driver).getSessionId();
            this.chromeDriver = (ChromeDriver)driver;
        } else if (driver instanceof FirefoxDriver) {
            this.sessionId = ((FirefoxDriver)driver).getSessionId();
            this.firfoxDriver = (FirefoxDriver)driver;
        } else if (driver instanceof InternetExplorerDriver) {
            this.sessionId = ((InternetExplorerDriver)driver).getSessionId();
            this.ieDriver = (InternetExplorerDriver)driver;
        } else if (driver instanceof RemoteWebDriver) {
            this.sessionId = ((RemoteWebDriver)driver).getSessionId();
            this.remoteWebDriver = (RemoteWebDriver)driver;
        }
        this.driver = driver;
    }

    private Object injectShadowExecuter(String javascript) {
        if (this.chromeDriver != null) {
            ChromeDriver js = this.chromeDriver;
            this.waitForPageLoaded();
            return js.executeScript(javascript, new Object[0]);
        }
        if (this.firfoxDriver != null) {
            this.waitForPageLoaded();
            return this.firfoxDriver.executeScript(javascript, new Object[0]);
        }
        if (this.ieDriver != null) {
            this.waitForPageLoaded();
            return this.ieDriver.executeScript(javascript, new Object[0]);
        }
        if (this.remoteWebDriver != null) {
            RemoteWebDriver js = this.remoteWebDriver;
            this.waitForPageLoaded();
            return js.executeScript(javascript, new Object[0]);
        }
        return null;
    }

    private Object injectShadowExecuter(String javascript, WebElement element) {
        if (this.chromeDriver != null) {
            ChromeDriver js = this.chromeDriver;
            this.waitForPageLoaded();
            return js.executeScript(javascript, new Object[]{element});
        }
        if (this.firfoxDriver != null) {
            this.waitForPageLoaded();
            return this.firfoxDriver.executeScript(javascript, new Object[]{element});
        }
        if (this.ieDriver != null) {
            this.waitForPageLoaded();
            return this.ieDriver.executeScript(javascript, new Object[]{element});
        }
        if (this.remoteWebDriver != null) {
            RemoteWebDriver js = this.remoteWebDriver;
            this.waitForPageLoaded();
            return js.executeScript(javascript, new Object[]{element});
        }
        return null;
    }

    private Object executerGetObject(String script) {
        String javascript = this.convertJStoText().toString();
        javascript = javascript + script;
        return this.injectShadowExecuter(javascript);
    }

    private Object executerGetObject(String script, WebElement element) {
        String javascript = this.convertJStoText().toString();
        javascript = javascript + script;
        return this.injectShadowExecuter(javascript, element);
    }

    private StringBuilder convertJStoText() {
        InputStream in = this.getClass().getResourceAsStream("/querySelector.js");
        BufferedReader reader = null;
        StringBuilder text = new StringBuilder();
        reader = new BufferedReader(new InputStreamReader(in));
        if (reader != null) {
            try {
                while (reader.ready()) {
                    text.append(reader.readLine());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    private void fixLocator(SearchContext context, String cssLocator, WebElement element) {
        if (element instanceof RemoteWebElement) {
            try {
                Class[] parameterTypes = new Class[]{SearchContext.class, String.class, String.class};
                Method m = element.getClass().getDeclaredMethod("setFoundBy", parameterTypes);
                m.setAccessible(true);
                Object[] parameters = new Object[]{context, "cssSelector", cssLocator};
                m.invoke((Object)element, parameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void waitForPageLoaded() {
        ExpectedCondition<Boolean> expectation = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            }
        };
        try {
            Thread.sleep(1000L);
            WebDriverWait wait = new WebDriverWait(this.driver, 30L);
            wait.until((Function)expectation);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public WebElement findElement(String cssSelector) {
        WebElement element = null;
        element = (WebElement)this.executerGetObject("return getObject(\"" + cssSelector + "\");");
        this.fixLocator((SearchContext)this.driver, cssSelector, element);
        return element;
    }

    public WebElement findElement(WebElement parent, String cssSelector) {
        WebElement element = null;
        element = (WebElement)this.executerGetObject("return getObject(\"" + cssSelector + "\", arguments[0]);", parent);
        this.fixLocator((SearchContext)this.driver, cssSelector, element);
        return element;
    }

    public List<WebElement> findElements(String cssSelector) {
        List element = null;
        Object object = this.executerGetObject("return getAllObject(\"" + cssSelector + "\");");
        if (object != null && object instanceof List) {
            element = (List)object;
        }
        for (WebElement webElement : element) {
            this.fixLocator((SearchContext)this.driver, cssSelector, webElement);
        }
        return element;
    }

    public List<WebElement> findElements(WebElement parent, String cssSelector) {
        List element = null;
        Object object = this.executerGetObject("return getAllObject(\"" + cssSelector + "\", arguments[0]);", parent);
        if (object != null && object instanceof List) {
            element = (List)object;
        }
        for (WebElement webElement : element) {
            this.fixLocator((SearchContext)this.driver, cssSelector, webElement);
        }
        return element;
    }

    public WebElement getShadowElement(WebElement parent, String selector) {
        WebElement element = null;
        element = (WebElement)this.executerGetObject("return getShadowElement(arguments[0],\"" + selector + "\");", parent);
        this.fixLocator((SearchContext)this.driver, selector, element);
        return element;
    }

    public List<WebElement> getAllShadowElement(WebElement parent, String selector) {
        List elements = null;
        Object object = this.executerGetObject("return getAllShadowElement(arguments[0],\"" + selector + "\");", parent);
        if (object != null && object instanceof List) {
            elements = (List)object;
        }
        for (WebElement element : elements) {
            this.fixLocator((SearchContext)this.driver, selector, element);
        }
        return elements;
    }

    public WebElement getParentElement(WebElement element) {
        return (WebElement)this.executerGetObject("return getParentElement(arguments[0]);", element);
    }

    public List<WebElement> getChildElements(WebElement parent) {
        List elements = null;
        Object object = this.executerGetObject("return getChildElements(arguments[0]);", parent);
        if (object != null && object instanceof List) {
            elements = (List)object;
        }
        return elements;
    }

    public List<WebElement> getSiblingElements(WebElement element) {
        List elements = null;
        Object object = this.executerGetObject("return getSiblingElements(arguments[0]);", element);
        if (object != null && object instanceof List) {
            elements = (List)object;
        }
        return elements;
    }

    public WebElement getSiblingElement(WebElement element, String selector) {
        return (WebElement)this.executerGetObject("return getSiblingElement(arguments[0],\"" + selector + "\");", element);
    }

    public WebElement getNextSiblingElement(WebElement element) {
        return (WebElement)this.executerGetObject("return getNextSiblingElement(arguments[0]);", element);
    }

    public WebElement getPreviousSiblingElement(WebElement element) {
        return (WebElement)this.executerGetObject("return getPreviousSiblingElement(arguments[0]);", element);
    }

    public boolean isVisible(WebElement element) {
        return (Boolean)this.executerGetObject("return isVisible(arguments[0]);", element);
    }

    public boolean isChecked(WebElement element) {
        return (Boolean)this.executerGetObject("return isChecked(arguments[0]);", element);
    }

    public boolean isDisabled(WebElement element) {
        return (Boolean)this.executerGetObject("return isDisabled(arguments[0]);", element);
    }

    public String getAttribute(WebElement element, String attribute) {
        return (String)this.executerGetObject("return getAttribute(arguments[0],\"" + attribute + "\");", element);
    }

    public void selectCheckbox(WebElement parentElement, String label) {
        this.executerGetObject("return selectCheckbox(\"" + label + "\",arguments[0]);", parentElement);
    }

    public void selectCheckbox(String label) {
        this.executerGetObject("return selectCheckbox(\"" + label + "\");");
    }

    public void selectRadio(WebElement parentElement, String label) {
        this.executerGetObject("return selectRadio(\"" + label + "\",arguments[0]);", parentElement);
    }

    public void selectRadio(String label) {
        this.executerGetObject("return selectRadio(\"" + label + "\");");
    }

    public void selectDropdown(WebElement parentElement, String label) {
        this.executerGetObject("return selectDropdown(\"" + label + "\",arguments[0]);", parentElement);
    }

    public void selectDropdown(String label) {
        this.executerGetObject("return selectDropdown(\"" + label + "\");");
    }

    public void scrollTo(WebElement element) {
        this.executerGetObject("return scrollTo(arguments[0]);", element);
    }
}

