/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.jmh;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.github.jamm.MemoryMeter;
import org.github.jamm.jmh.Cls1;
import org.github.jamm.jmh.Cls2;
import org.github.jamm.jmh.Cls3;
import org.github.jamm.jmh.ClsX;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Threads(value=3)
@Fork(value=1, jvmArgsPrepend={"-javaagent:target/jamm-0.4.0-SNAPSHOT.jar", "-Xms16g", "-Xmx16g", "-XX:+UseG1GC", "-XX:+AlwaysPreTouch"})
@Warmup(iterations=1, time=5)
@Measurement(iterations=3, time=1)
@BenchmarkMode(value={Mode.AverageTime})
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class Microbench {
    @Param(value={"ALWAYS_SPEC", "ALWAYS_UNSAFE", "ALWAYS_INSTRUMENTATION"})
    private String guess;
    private MemoryMeter meter;
    private String valString;
    private ByteBuffer heapByteBuffer;
    private Cls1 cls1;
    private Cls1 cls2;
    private Cls1 cls3;
    private byte[] bytes;
    private long[] longs;
    private Object[] objects;
    private ClsX deeplyNested;
    @Param(value={"100"})
    private int nested;
    @Param(value={"4"})
    private int refs;

    @Setup
    public void setup() {
        int i;
        MemoryMeter.Guess guess = MemoryMeter.Guess.valueOf(this.guess);
        this.meter = MemoryMeter.builder().withGuessing(guess).build();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 300; ++i) {
            sb.append('a');
        }
        this.valString = sb.toString();
        this.heapByteBuffer = ByteBuffer.allocate(300);
        this.cls1 = new Cls1();
        this.cls2 = new Cls2();
        this.cls3 = new Cls3();
        this.bytes = new byte[200];
        this.longs = new long[200];
        this.objects = new Object[50];
        for (i = 0; i < this.objects.length; ++i) {
            this.objects[i] = new Object();
        }
        ClsX last = null;
        for (int i2 = 0; i2 < this.nested; ++i2) {
            ClsX o = new ClsX();
            if (last == null) {
                this.deeplyNested = o;
            } else {
                last.objs.add(o);
            }
            last = o;
            for (int j = 0; j < this.refs; ++j) {
                o.objs.add(new ClsX());
            }
        }
    }

    @Benchmark
    public void deeplyNested(Blackhole bh) {
        bh.consume(this.meter.measureDeep(this.deeplyNested));
    }

    @Benchmark
    public void justString(Blackhole bh) {
        bh.consume(this.meter.measureDeep(this.valString));
    }

    @Benchmark
    public void justByteBuffer(Blackhole bh) {
        bh.consume(this.meter.measureDeep(this.heapByteBuffer));
    }

    @Benchmark
    public void justByteArray(Blackhole bh) {
        bh.consume(this.meter.measure(this.bytes));
    }

    @Benchmark
    public void arrayByteArray(Blackhole bh) {
        bh.consume(this.meter.sizeOfArray(this.bytes));
    }

    @Benchmark
    public void cls1(Blackhole bh) {
        bh.consume(this.meter.measureDeep(this.cls1));
    }

    @Benchmark
    public void cls2(Blackhole bh) {
        bh.consume(this.meter.measureDeep(this.cls2));
    }

    @Benchmark
    public void cls3(Blackhole bh) {
        bh.consume(this.meter.measureDeep(this.cls3));
    }
}

