/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.decorator;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockClient;
import io.github.spring.tools.redis.RedisLockReleaseStatus;
import io.github.spring.tools.redis.RedisLockStatus;
import io.github.spring.tools.redis.capable.ILockWritable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbsLockDecorator
implements IRedisLock,
ILockWritable {
    protected IRedisLock delegate;
    public static final int ORDER_DEFAULT = 1000;

    @Override
    public void setStatus(RedisLockStatus status) {
        if (this.delegate instanceof AbsLockDecorator) {
            ((AbsLockDecorator)this.delegate).setStatus(status);
        } else if (this.delegate instanceof ILockWritable) {
            ((ILockWritable)((Object)this.delegate)).setStatus(status);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u7c7b\u578b\u4e0d\u652f\u6301 setStatus \u65b9\u6cd5");
        }
    }

    public AbsLockDecorator(IRedisLock delegate) {
        this.delegate = delegate;
    }

    @Override
    public RedisLockStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public String getKey() {
        return this.delegate.getKey();
    }

    @Override
    public void setKey(String key) {
        ((ILockWritable)((Object)this.delegate)).setKey(key);
    }

    @Override
    public int getLockSeconds() {
        return this.delegate.getLockSeconds();
    }

    @Override
    public boolean needUnlock() {
        return ((ILockWritable)((Object)this.delegate)).needUnlock();
    }

    @Override
    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    @Override
    public boolean interrupted() {
        return this.delegate.interrupted();
    }

    public final <T extends AbsLockDecorator> T getDecoratorByClass(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (clazz.isAssignableFrom(this.delegate.getClass())) {
            return (T)((AbsLockDecorator)this.delegate);
        }
        if (!(this.delegate instanceof AbsLockDecorator)) {
            return null;
        }
        return ((AbsLockDecorator)this.delegate).getDecoratorByClass(clazz);
    }

    protected abstract Logger getLogger();

    protected void debugMessage(String message) {
        this.getLogger().debug(String.format("%s:RedisLockDecorator --> %s \u9501 %s", this.getClass().getSimpleName(), this.getKey(), message));
    }

    protected void infoMessage(String message) {
        this.getLogger().info(String.format("%s:RedisLockDecorator --> %s \u9501 %s", this.getClass().getSimpleName(), this.getKey(), message));
    }

    protected void errorMessage(String message) {
        this.getLogger().error(String.format("%s:RedisLockDecorator --> %s \u9501 %s", this.getClass().getSimpleName(), this.getKey(), message));
    }

    @Override
    public void setLockSeconds(int lockSeconds) {
        ((ILockWritable)((Object)this.delegate)).setLockSeconds(lockSeconds);
    }

    @Override
    public void unlocked(boolean release) {
        ((ILockWritable)((Object)this.delegate)).unlocked(release);
    }

    @Override
    public RedisLockReleaseStatus getReleaseStatus() {
        return this.delegate.getReleaseStatus();
    }

    @Override
    public void setReleaseStatus(RedisLockReleaseStatus releaseStatus) {
        ((ILockWritable)((Object)this.delegate)).setReleaseStatus(releaseStatus);
    }

    @Override
    public void setSleepMinMills(int sleepMinMills) {
        ((ILockWritable)((Object)this.delegate)).setSleepMinMills(sleepMinMills);
    }

    @Override
    public int getSleepMinMills() {
        return this.delegate.getSleepMinMills();
    }

    @Override
    public void setSleepMaxMills(int sleepMaxMills) {
        ((ILockWritable)((Object)this.delegate)).setSleepMaxMills(sleepMaxMills);
    }

    @Override
    public int getSleepMaxMills() {
        return this.delegate.getSleepMaxMills();
    }

    @Override
    public void setSpinTimes(int spinTimes) {
        ((ILockWritable)((Object)this.delegate)).setSpinTimes(spinTimes);
    }

    @Override
    public int getSpinTimes() {
        return this.delegate.getSpinTimes();
    }

    @Override
    public boolean tryLock() {
        return this.delegate.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.delegate.tryLock(time, unit);
    }

    @Override
    public RedisLockClient getLockClient() {
        return ((ILockWritable)((Object)this.delegate)).getLockClient();
    }

    @Override
    public void unlock() {
        this.delegate.unlock();
        this.debugMessage("\u91ca\u653e\u9501\u6210\u529f");
    }
}

