/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.capable;

import io.github.spring.tools.redis.IDoCallback;
import io.github.spring.tools.redis.RedisLockReleaseStatus;
import io.github.spring.tools.redis.RedisLockStatus;
import io.github.spring.tools.redis.capable.ILockTemplate;
import io.github.spring.tools.redis.exception.TimeoutLockException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public interface ILock
extends Lock,
AutoCloseable,
ILockTemplate {
    public RedisLockStatus getStatus();

    public RedisLockReleaseStatus getReleaseStatus();

    public int getSleepMinMills();

    public int getSleepMaxMills();

    public int getSpinTimes();

    public String getKey();

    public int getLockSeconds();

    default public boolean isFinished() {
        return this.getReleaseStatus() != RedisLockReleaseStatus.NEW;
    }

    default public boolean isLocked() {
        return this.getStatus() == RedisLockStatus.LOCKED && this.getReleaseStatus() == RedisLockReleaseStatus.NEW;
    }

    default public boolean isRollback() {
        return this.getStatus() == RedisLockStatus.LOCKED && this.getReleaseStatus() == RedisLockReleaseStatus.FAIL;
    }

    public boolean interrupted();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T> T execute(IDoCallback<T> callback, IDoCallback<T> faultCallback, IDoCallback<T> rollback, int time, TimeUnit unit) throws TimeoutLockException, Throwable {
        T result;
        Objects.requireNonNull(unit);
        try {
            if (time <= 0 ? this.tryLock() : this.tryLock(time, unit)) {
                result = callback.callback();
            } else {
                if (faultCallback == null) {
                    throw new TimeoutLockException(this.getKey());
                }
                result = faultCallback.callback();
            }
        }
        finally {
            this.unlock();
            if (this.isRollback() && rollback != null) {
                result = rollback.callback();
            }
        }
        return result;
    }

    @Override
    default public void close() throws Exception {
        this.unlock();
    }

    @Override
    default public Condition newCondition() {
        throw new UnsupportedOperationException("newCondition \u4e0d\u652f\u6301");
    }

    @Override
    default public void lock() {
        throw new UnsupportedOperationException("lock  \u65b9\u6cd5\u4e0d\u652f\u6301");
    }

    @Override
    default public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("lockInterruptibly  \u65b9\u6cd5\u4e0d\u652f\u6301");
    }
}

