/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.annotation.configuration;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

public class RedisLockConfigurationImportSelector
implements ImportSelector {
    private static final Logger log = LoggerFactory.getLogger(RedisLockConfigurationImportSelector.class);
    private static final Object LOCK_OBJECT = new Object();
    private static final AtomicBoolean IS_INIT = new AtomicBoolean(false);
    private static final Map<String[], String> CONFIGURATION_CLASSES = new LinkedHashMap<String[], String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (IS_INIT.get()) {
                log.error("SharedLock \u91cd\u590d\u52a0\u8f7d\uff0c\u672c\u6b21\u5ffd\u7565");
                return new String[0];
            }
            for (Map.Entry<String[], String> classes : CONFIGURATION_CLASSES.entrySet()) {
                try {
                    for (String clazz : classes.getKey()) {
                        Class.forName(clazz, false, this.getClass().getClassLoader());
                    }
                    log.debug("\u5171\u4eab\u9501 {} \u5ba2\u6237\u7aef\u52a0\u8f7d\u6210\u529f", (Object)classes.getValue());
                    IS_INIT.set(true);
                    return new String[]{classes.getValue()};
                }
                catch (Throwable ex) {
                    log.debug("\u5171\u4eab\u9501 {} \u5ba2\u6237\u7aef\u88c5\u8f7d\u5931\u8d25\uff0c\u6ca1\u6709\u5f15\u7528\u76f8\u5173\u4f9d\u8d56\u5305", (Object)classes.getValue());
                }
            }
            return new String[0];
        }
    }

    static {
        CONFIGURATION_CLASSES.put(new String[]{"org.springframework.data.redis.core.RedisTemplate"}, "io.github.spring.tools.redis.annotation.configuration.RedisLockConfiguration");
    }
}

