/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis;

import io.github.spring.tools.redis.RedislockUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;

public class RedisLockClient {
    private static final Logger log = LoggerFactory.getLogger(RedisLockClient.class);
    private static final String RELEASE_LUA;
    private static final String TIME_LUA = "return redis.call('TIME')";
    protected final RedisTemplate<String, String> redisTemplate;

    public RedisLockClient(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, boolean isPersist) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        if (isPersist) {
            this.redisTemplate.persist((Object)key);
        }
    }

    public boolean setNx(String key, String value, int lockSeconds) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            try {
                if (connection.set(RedislockUtils.stringToBytes(key), RedislockUtils.stringToBytes(value), Expiration.seconds((long)lockSeconds), RedisStringCommands.SetOption.SET_IF_ABSENT).booleanValue()) {
                    log.debug("spring data redis -> {} \u83b7\u53d6\u9501{}\u6570\u636e\u6210\u529f", (Object)key, (Object)value);
                    return true;
                }
            }
            catch (Exception e) {
                log.error("spring data redis -> {} \u9501\u83b7\u53d6\u8d85\u65f6", (Object)key, (Object)e);
            }
            return false;
        });
    }

    public boolean releaseByLua(String key, String value) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            try {
                if (((Boolean)connection.eval(RedislockUtils.stringToBytes(RELEASE_LUA), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{RedislockUtils.stringToBytes(key), RedislockUtils.stringToBytes(value)})).booleanValue()) {
                    log.debug("spring data redis -> {} \u91ca\u653e\u9501\u6210\u529f", (Object)key);
                    return true;
                }
            }
            catch (Exception e) {
                log.error("spring data redis -> {} \u91ca\u653e\u9501\u8d85\u65f6", (Object)key, (Object)e);
            }
            return false;
        });
    }

    public <T> List<T> execScriptList(String script) {
        return (List)this.redisTemplate.execute(connection -> (List)connection.eval(RedislockUtils.stringToBytes(script), ReturnType.MULTI, 0, (byte[][])new byte[0][]));
    }

    public long queryRedisNow() {
        List times = this.execScriptList(TIME_LUA);
        StringBuilder strs = new StringBuilder();
        Objects.requireNonNull(times);
        Assert.isTrue((times.size() == 2 ? 1 : 0) != 0, (String)"\u4ece redis \u83b7\u53d6 \u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4\u5931\u8d25");
        Assert.isTrue((((byte[])times.get(1)).length > 3 ? 1 : 0) != 0, (String)"\u4ece redis \u83b7\u53d6 \u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4\u5931\u8d25");
        strs.append(new String((byte[])times.get(0)));
        strs.append(new String((byte[])times.get(1)).substring(0, 3));
        System.out.println("now is " + new String((byte[])times.get(0)) + new String((byte[])times.get(1)));
        return Long.valueOf(strs.toString());
    }

    public boolean delete(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("if redis.call(\"get\",KEYS[1]) == ARGV[1] ");
        sb.append("then ");
        sb.append("    return redis.call(\"del\",KEYS[1]) ");
        sb.append("else ");
        sb.append("    return 0 ");
        sb.append("end ");
        RELEASE_LUA = sb.toString();
    }
}

