/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis;

import io.github.spring.tools.redis.DefaultRedisLock;
import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockEnvironment;
import io.github.spring.tools.redis.RedislockUtils;
import io.github.spring.tools.redis.decorator.AbsLockDecorator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisLockBuilder {
    private String key;
    private int lockSeconds = -1;
    private int sleepMinMills = -1;
    private int sleepMaxMills = -1;
    private int spinTimes = -1;
    private String keyPrefix;
    private RuntimeException throwableException;
    private Set<Class<? extends AbsLockDecorator>> decorators = new HashSet<Class<? extends AbsLockDecorator>>(8);
    public static final int DEFAULT_EMPTY = -1;

    public RedisLockBuilder key(String key) {
        Objects.requireNonNull(key);
        this.key = key;
        return this;
    }

    public RedisLockBuilder lockSeconds(int lockSeconds) {
        this.lockSeconds = lockSeconds;
        return this;
    }

    public RedisLockBuilder throwableException(RuntimeException throwableException) {
        this.throwableException = throwableException;
        return this;
    }

    public RedisLockBuilder sleepMinMills(int sleepMinMills) {
        this.sleepMinMills = sleepMinMills;
        return this;
    }

    public RedisLockBuilder sleepMaxMills(int sleepMaxMills) {
        this.sleepMaxMills = sleepMaxMills;
        return this;
    }

    public RedisLockBuilder spinTimes(int spinTimes) {
        this.spinTimes = spinTimes;
        return this;
    }

    public RedisLockBuilder keyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public RedisLockBuilder addDecorators(Class<? extends AbsLockDecorator> ... classes) {
        if (classes != null) {
            this.decorators.addAll(Arrays.asList(classes));
        }
        return this;
    }

    public RedisLockBuilder addDecorators(List<Class<? extends AbsLockDecorator>> classes) {
        if (classes != null) {
            this.decorators.addAll(classes);
        }
        return this;
    }

    public IRedisLock build() {
        DefaultRedisLock lock = new DefaultRedisLock(RedisLockEnvironment.getInstance().getRedisTemplate(), this.key, this.getDefaultValue(this.lockSeconds, 10), this.getDefaultValue(this.sleepMinMills, 200), this.getDefaultValue(this.sleepMaxMills, 500), this.getDefaultValue(this.spinTimes, 3), this.throwableException);
        return RedislockUtils.mergeEnv(lock, this.decorators, this.keyPrefix);
    }

    private int getDefaultValue(int value, int defaultValue) {
        return value == -1 ? defaultValue : value;
    }

    boolean isDefault(int value) {
        return value == -1;
    }

    public RedisLockEnvironment buildEnv(RedisTemplate redisTemplate) {
        new RedisLockEnvironment((RedisTemplate<String, String>)redisTemplate, this);
        return RedisLockEnvironment.getInstance();
    }

    public static RedisLockBuilder builder(String key) {
        return new RedisLockBuilder().key(key);
    }

    public String getKey() {
        return this.key;
    }

    public int getLockSeconds() {
        return this.lockSeconds;
    }

    public int getSleepMinMills() {
        return this.sleepMinMills;
    }

    public int getSleepMaxMills() {
        return this.sleepMaxMills;
    }

    public int getSpinTimes() {
        return this.spinTimes;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public RuntimeException getThrowableException() {
        return this.throwableException;
    }

    public Set<Class<? extends AbsLockDecorator>> getDecorators() {
        return this.decorators;
    }
}

