/*
 * Decompiled with CFR 0.152.
 */
package io.github.sporklibrary.reflection;

import io.github.sporklibrary.exceptions.BindException;
import io.github.sporklibrary.exceptions.NotInstantiatableException;
import io.github.sporklibrary.reflection.AnnotatedMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class AnnotatedMethods {
    private AnnotatedMethods() {
        throw new NotInstantiatableException(this.getClass());
    }

    public static Object invoke(AnnotatedMethod<?> annotatedMethod, Object object, Object ... args) {
        Method method = annotatedMethod.getMethod();
        boolean accessible = method.isAccessible();
        try {
            if (accessible) {
                Object object2 = method.invoke(object, args);
                return object2;
            }
            method.setAccessible(true);
            Object result = method.invoke(object, args);
            method.setAccessible(false);
            Object object3 = result;
            return object3;
        }
        catch (IllegalAccessException e) {
            throw new BindException(annotatedMethod.getAnnotation().getClass(), object.getClass(), method, "method not accessible", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new BindException(annotatedMethod.getAnnotation().getClass(), object.getClass(), method, "method calling failed because of an invocation issue", (Exception)e);
        }
        finally {
            if (!accessible && method.isAccessible()) {
                method.setAccessible(false);
            }
        }
    }
}

