/*
 * Decompiled with CFR 0.152.
 */
package io.github.sporklibrary.reflection;

import io.github.sporklibrary.exceptions.BindException;
import io.github.sporklibrary.exceptions.NotInstantiatableException;
import io.github.sporklibrary.reflection.AnnotatedField;
import java.lang.reflect.Field;

public final class AnnotatedFields {
    private AnnotatedFields() {
        throw new NotInstantiatableException(this.getClass());
    }

    public static void set(AnnotatedField<?> annotatedField, Object object, Object value) {
        Field field = annotatedField.getField();
        boolean accessible = field.isAccessible();
        try {
            if (accessible) {
                field.set(object, value);
            } else {
                field.setAccessible(true);
                field.set(object, value);
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            throw new BindException(annotatedField.getAnnotation().getClass(), object.getClass(), field, "field not accessible", (Exception)e);
        }
        finally {
            if (!accessible && field.isAccessible()) {
                field.setAccessible(false);
            }
        }
    }
}

