/*
 * Decompiled with CFR 0.152.
 */
package io.github.sporklibrary.binders;

import io.github.sporklibrary.binders.FieldBinder;
import io.github.sporklibrary.binders.MethodBinder;
import io.github.sporklibrary.binders.TypeBinder;
import io.github.sporklibrary.reflection.AnnotatedField;
import io.github.sporklibrary.reflection.AnnotatedFieldRetriever;
import io.github.sporklibrary.reflection.AnnotatedMethod;
import io.github.sporklibrary.reflection.AnnotatedMethodRetriever;
import io.github.sporklibrary.reflection.AnnotatedType;
import io.github.sporklibrary.reflection.AnnotatedTypeRetriever;
import java.lang.annotation.Annotation;
import java.util.Set;

public class CompoundBinder<AnnotationType extends Annotation> {
    private final FieldBinder<AnnotationType> mFieldBinder;
    private final MethodBinder<AnnotationType> mMethodBinder;
    private final TypeBinder<AnnotationType> mTypeBinder;
    private final AnnotatedFieldRetriever<AnnotationType> mAnnotatedFieldRetriever;
    private final AnnotatedMethodRetriever<AnnotationType> mAnnotatedMethodRetriever;
    private final AnnotatedTypeRetriever<AnnotationType> mAnnotatedTypeRetriever;

    public CompoundBinder(FieldBinder<AnnotationType> fieldBinder) {
        this(fieldBinder, null, null);
    }

    public CompoundBinder(MethodBinder<AnnotationType> methodBinder) {
        this(null, methodBinder, null);
    }

    public CompoundBinder(TypeBinder<AnnotationType> typeBinder) {
        this(null, null, typeBinder);
    }

    public CompoundBinder(FieldBinder<AnnotationType> fieldBinder, MethodBinder<AnnotationType> methodBinder, TypeBinder<AnnotationType> typeBinder) {
        if (fieldBinder != null) {
            this.mFieldBinder = fieldBinder;
            this.mAnnotatedFieldRetriever = new AnnotatedFieldRetriever(fieldBinder.getAnnotationClass());
        } else {
            this.mFieldBinder = null;
            this.mAnnotatedFieldRetriever = null;
        }
        if (methodBinder != null) {
            this.mMethodBinder = methodBinder;
            this.mAnnotatedMethodRetriever = new AnnotatedMethodRetriever(methodBinder.getAnnotationClass());
        } else {
            this.mMethodBinder = null;
            this.mAnnotatedMethodRetriever = null;
        }
        if (typeBinder != null) {
            this.mTypeBinder = typeBinder;
            this.mAnnotatedTypeRetriever = new AnnotatedTypeRetriever(typeBinder.getAnnotationClass());
        } else {
            this.mTypeBinder = null;
            this.mAnnotatedTypeRetriever = null;
        }
    }

    public void bind(Object object) {
        if (this.mFieldBinder != null && this.mAnnotatedFieldRetriever != null) {
            this.bindFields(object);
        }
        if (this.mMethodBinder != null && this.mAnnotatedMethodRetriever != null) {
            this.bindMethods(object);
        }
        if (this.mTypeBinder != null && this.mAnnotatedTypeRetriever != null) {
            this.bindType(object);
        }
    }

    private void bindFields(Object object) {
        for (Class<?> object_class = object.getClass(); object_class != null && object_class != Object.class; object_class = object_class.getSuperclass()) {
            this.bindFields(object, object_class);
        }
    }

    private void bindFields(Object object, Class<?> objectClass) {
        Set<AnnotatedField<AnnotationType>> annotated_field_set = this.mAnnotatedFieldRetriever.getAnnotatedFields(objectClass);
        for (AnnotatedField<AnnotationType> annotated_field : annotated_field_set) {
            this.mFieldBinder.bind(object, annotated_field);
        }
    }

    private void bindMethods(Object object) {
        for (Class<?> object_class = object.getClass(); object_class != null && object_class != Object.class; object_class = object_class.getSuperclass()) {
            this.bindMethods(object, object_class);
        }
    }

    private void bindMethods(Object object, Class<?> objectClass) {
        Set<AnnotatedMethod<AnnotationType>> annotated_method_set = this.mAnnotatedMethodRetriever.getAnnotatedMethods(objectClass);
        for (AnnotatedMethod<AnnotationType> annotated_method : annotated_method_set) {
            this.mMethodBinder.bind(object, annotated_method);
        }
    }

    private void bindType(Object object) {
        for (Class<?> object_class = object.getClass(); object_class != null && object_class != Object.class; object_class = object_class.getSuperclass()) {
            this.bindType(object, object_class);
        }
    }

    private void bindType(Object object, Class<?> objectClass) {
        AnnotatedType<AnnotationType> annotated_class = this.mAnnotatedTypeRetriever.getAnnotatedClass(objectClass);
        if (annotated_class != null) {
            this.mTypeBinder.bind(object, annotated_class);
        }
    }
}

