/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.data.JDBCConnection;
import io.github.spark_redshift_community.spark.redshift.data.JDBCResults;
import io.github.spark_redshift_community.spark.redshift.data.JDBCWrapper$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.pushdown.BooleanVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ByteVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.ConstantString;
import io.github.spark_redshift_community.spark.redshift.pushdown.DoubleVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.FloatVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.Identifier;
import io.github.spark_redshift_community.spark.redshift.pushdown.IntVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.LongVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.ShortVariable;
import io.github.spark_redshift_community.spark.redshift.pushdown.StatementElement;
import io.github.spark_redshift_community.spark.redshift.pushdown.StringVariable;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t%h!\u0002\u00180\u0001EZ\u0004\"B(\u0001\t\u0003\u0001\u0006b\u0002*\u0001\u0005\u0004%\tb\u0015\u0005\u00079\u0002\u0001\u000b\u0011\u0002+\t\u0011u\u0003\u0001R1A\u0005\fyC\u0001B\u001b\u0001\t\u0006\u0004%Ya\u001b\u0005\tg\u0002A)\u0019!C\u0005i\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u00111\u0002\u0001\u0005B\u0005U\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\t9\u000e\u0001C!\u00033Dq!a8\u0001\t\u0003\n\t\u000fC\u0005\u0003\u0002\u0001\t\n\u0011\"\u0001\u0003\u0004!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\n\u0005\u000b\u0002\u0011\u0013!C\u0005\u0005\u0007AqAa\u0012\u0001\t\u0003\u0012I\u0005C\u0004\u0003P\u0001!\tE!\u0015\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!I!\u0011\u000f\u0001\u0012\u0002\u0013%!1\u000f\u0005\b\u0005o\u0002A\u0011\u0002B=\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007CqAa#\u0001\t\u0013\u0011ii\u0002\u0005\u0003\u0014>B\t!\rBK\r\u001dqs\u0006#\u00012\u0005/CaaT\u0010\u0005\u0002\t\u001d\u0006\"\u0003BU?\t\u0007I\u0011\u0001BV\u0011!\u00119l\bQ\u0001\n\t5\u0006\"\u0003B]?\t\u0007I\u0011\u0001BV\u0011!\u0011Yl\bQ\u0001\n\t5\u0006\"\u0003B_?\t\u0007I\u0011\u0001BV\u0011!\u0011yl\bQ\u0001\n\t5\u0006\"\u0003Ba?\t\u0007I\u0011\u0001BV\u0011!\u0011\u0019m\bQ\u0001\n\t5\u0006\"\u0003Bc?\t\u0007I\u0011\u0001BV\u0011!\u00119m\bQ\u0001\n\t5\u0006\"\u0003Be?\t\u0007I\u0011\u0001Bf\u0011!\u0011in\bQ\u0001\n\t5\u0007\"\u0003Bp?\u0005\u0005I\u0011\u0002Bq\u0005-QEIQ\"Xe\u0006\u0004\b/\u001a:\u000b\u0005A\n\u0014\u0001\u00023bi\u0006T!AM\u001a\u0002\u0011I,Gm\u001d5jMRT!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011\u0001(O\u0001\u0007O&$\b.\u001e2\u000b\u0003i\n!![8\u0014\u0007\u0001a\u0004\t\u0005\u0002>}5\tq&\u0003\u0002@_\ty!+\u001a3tQ&4Go\u0016:baB,'\u000f\u0005\u0002B\u0019:\u0011!)\u0013\b\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002\u0011\u0006)1oY1mC&\u0011!jS\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0015BA'O\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQ5*\u0001\u0004=S:LGO\u0010\u000b\u0002#B\u0011Q\bA\u0001\u0004Y><W#\u0001+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016!B:mMRR'\"A-\u0002\u0007=\u0014x-\u0003\u0002\\-\n1Aj\\4hKJ\fA\u0001\\8hA\u0005\u00192-\u00197m\u001dVl'-\u001a:HK:,'/\u0019;peV\tq\fE\u0002BA\nL!!\u0019(\u0003\u0011%#XM]1u_J\u0004\"a\u00193\u000e\u0003-K!!Z&\u0003\u0007%sG\u000f\u000b\u0002\u0005OB\u00111\r[\u0005\u0003S.\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0005\u0015\u001cW#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=\\\u0015AC2p]\u000e,(O]3oi&\u0011\u0011O\u001c\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD#!B4\u0002\u001f\r\fgnY3mY\u0006$\u0018n\u001c8NCB,\u0012!\u001e\t\u0005mrt(-D\u0001x\u0015\ty\u0007P\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!!`<\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r!0A\u0002tc2LA!a\u0002\u0002\u0002\t\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;)\u0005\u00199\u0017\u0001F3yK\u000e,H/Z%oi\u0016\u0014(/\u001e9uS\nd\u00170\u0006\u0003\u0002\u0010\u0005UACBA\t\u0003O\tY\u0003\u0005\u0003\u0002\u0014\u0005UA\u0002\u0001\u0003\b\u0003/9!\u0019AA\r\u0005\u0005!\u0016\u0003BA\u000e\u0003C\u00012aYA\u000f\u0013\r\tyb\u0013\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u00171E\u0005\u0004\u0003KY%aA!os\"1\u0011\u0011F\u0004A\u0002y\f\u0011b\u001d;bi\u0016lWM\u001c;\t\u000f\u00055r\u00011\u0001\u00020\u0005\u0011q\u000e\u001d\t\u0007G\u0006Eb0!\u0005\n\u0007\u0005M2JA\u0005Gk:\u001cG/[8oc\u0005qq-\u001a;Ee&4XM]\"mCN\u001cHCBA\u001d\u0003\u0013\ni\u0005\u0005\u0003\u0002<\u0005\rc\u0002BA\u001f\u0003\u007f\u0001\"aQ&\n\u0007\u0005\u00053*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\n9E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003Z\u0005bBA&\u0011\u0001\u0007\u0011\u0011H\u0001\u0010U\u0012\u00147mU;caJ|Go\\2pY\"9\u0011q\n\u0005A\u0002\u0005E\u0013aF;tKJ\u0004&o\u001c<jI\u0016$GI]5wKJ\u001cE.Y:t!\u0015\u0019\u00171KA\u001d\u0013\r\t)f\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0019\u001d,GoQ8o]\u0016\u001cGo\u001c:\u0015\t\u0005m\u0013\u0011\r\t\u0004{\u0005u\u0013bAA0_\t\u0011\"+\u001a3tQ&4GoQ8o]\u0016\u001cG/[8o\u0011\u001d\t\u0019'\u0003a\u0001\u0003K\na\u0001]1sC6\u001c\b\u0003BA4\u0003\u0003sA!!\u001b\u0002~9!\u00111NA>\u001d\u0011\ti'!\u001f\u000f\t\u0005=\u0014q\u000f\b\u0005\u0003c\n)HD\u0002D\u0003gJ\u0011AO\u0005\u0003qeJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\r\ty(M\u0001\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\u0002BAB\u0003\u000b\u0013\u0001#T3sO\u0016$\u0007+\u0019:b[\u0016$XM]:\u000b\u0007\u0005}\u0014'\u0001\u000ehKR\u001cuN\u001c8fGR|'oV5uQF+XM]=He>,\b\u000f\u0006\u0004\u0002\\\u0005-\u0015Q\u0012\u0005\b\u0003GR\u0001\u0019AA3\u0011\u001d\tyI\u0003a\u0001\u0003s\t!\"];fef<%o\\;q\u00035\u0019X\r^!vi>\u001cu.\\7jiR1\u0011QSAN\u0003?\u00032aYAL\u0013\r\tIj\u0013\u0002\u0005+:LG\u000fC\u0004\u0002\u001e.\u0001\r!a\u0017\u0002\t\r|gN\u001c\u0005\b\u0003C[\u0001\u0019AAR\u0003)\tW\u000f^8D_6l\u0017\u000e\u001e\t\u0004G\u0006\u0015\u0016bAAT\u0017\n9!i\\8mK\u0006t\u0017AB2p[6LG\u000f\u0006\u0003\u0002\u0016\u00065\u0006bBAO\u0019\u0001\u0007\u00111L\u0001\te>dGNY1dWR!\u0011QSAZ\u0011\u001d\ti*\u0004a\u0001\u00037\"b!a)\u00028\u0006e\u0006bBAO\u001d\u0001\u0007\u00111\f\u0005\b\u0003\u0007q\u0001\u0019AA\u001d\u0003e)\u00070Z2vi\u0016\fV/\u001a:z\u0013:$XM\u001d:vaRL'\r\\=\u0015\r\u0005}\u0016QYAd!\ri\u0014\u0011Y\u0005\u0004\u0003\u0007|#a\u0004*fIND\u0017N\u001a;SKN,H\u000e^:\t\u000f\u0005uu\u00021\u0001\u0002\\!9\u00111A\bA\u0002\u0005e\u0012AG3yK\u000e,H/Z+qI\u0006$X-\u00138uKJ\u0014X\u000f\u001d;jE2LHCBAg\u0003'\f)\u000eE\u0002d\u0003\u001fL1!!5L\u0005\u0011auN\\4\t\u000f\u0005u\u0005\u00031\u0001\u0002\\!9\u00111\u0001\tA\u0002\u0005e\u0012!D3yK\u000e,H/Z+qI\u0006$X\r\u0006\u0004\u0002N\u0006m\u0017Q\u001c\u0005\b\u0003;\u000b\u0002\u0019AA.\u0011\u001d\t\u0019!\u0005a\u0001\u0003s\tAB]3t_24X\rV1cY\u0016$\u0002\"a9\u0002x\u0006e\u0018Q \t\u0005\u0003K\f\u00190\u0004\u0002\u0002h*!\u0011\u0011^Av\u0003\u0015!\u0018\u0010]3t\u0015\u0011\t\u0019!!<\u000b\u0007Q\nyOC\u0002\u0002rb\u000ba!\u00199bG\",\u0017\u0002BA{\u0003O\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tiJ\u0005a\u0001\u00037Bq!a?\u0013\u0001\u0004\tI$A\u0003uC\ndW\rC\u0005\u0002dI\u0001\n\u00111\u0001\u0002\u0000B)1-a\u0015\u0002f\u00051\"/Z:pYZ,G+\u00192mK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0006)\"\u0011q B\u0004W\t\u0011I\u0001\u0005\u0003\u0003\f\tUQB\u0001B\u0007\u0015\u0011\u0011yA!\u0005\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\n\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]!Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0006:fg>dg/\u001a+bE2,gI]8n\u001b\u0016$\u0018\r\u0006\u0004\u0002d\nu!q\u0005\u0005\b\u0005?!\u0002\u0019\u0001B\u0011\u0003\u0011\u00118/\u001c3\u0011\u0007}\u0014\u0019#\u0003\u0003\u0003&\u0005\u0005!!\u0005*fgVdGoU3u\u001b\u0016$\u0018\rR1uC\"9\u00111\r\u000bA\u0002\u0005\u0015\u0014aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u0019\t5\"1\u0007B\u001c\u0005w\u0011yDa\u0011\u0011\t\u0005\u0015(qF\u0005\u0005\u0005c\t9O\u0001\u0005ECR\fG+\u001f9f\u0011\u0019\u0011)$\u0006a\u0001E\u000691/\u001d7UsB,\u0007B\u0002B\u001d+\u0001\u0007!-A\u0005qe\u0016\u001c\u0017n]5p]\"1!QH\u000bA\u0002\t\fQa]2bY\u0016DqA!\u0011\u0016\u0001\u0004\t\u0019+\u0001\u0004tS\u001etW\r\u001a\u0005\n\u0003G*\u0002\u0013!a\u0001\u0003\u007f\f\u0011dZ3u\u0007\u0006$\u0018\r\\=tiRK\b/\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0019\t\u0019Ka\u0013\u0003N!9\u0011QT\fA\u0002\u0005m\u0003bBA~/\u0001\u0007\u0011\u0011H\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0006\u0005\u0002d\nM#Q\u000bB2\u0011\u001d\ti\n\u0007a\u0001\u00037Bq!!\u000b\u0019\u0001\u0004\u00119\u0006\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\r\u0011i&M\u0001\taV\u001c\b\u000eZ8x]&!!\u0011\rB.\u0005Q\u0011V\rZ:iS\u001a$8+\u0015'Ti\u0006$X-\\3oi\"9\u00111\r\rA\u0002\u0005\u0015\u0014A\u0007;bE2,W*\u001a;b\t\u0006$\u0018M\u0012:p[N#\u0018\r^3nK:$H\u0003\u0003B\u0011\u0005S\u0012YG!\u001c\t\u000f\u0005u\u0015\u00041\u0001\u0002\\!9\u0011\u0011F\rA\u0002\t]\u0003\"\u0003B83A\u0005\t\u0019AAR\u0003M\u0011\u0017N\u001c3WCJL\u0017M\u00197f\u000b:\f'\r\\3e\u0003\u0011\"\u0018M\u00197f\u001b\u0016$\u0018\rR1uC\u001a\u0013x.\\*uCR,W.\u001a8uI\u0011,g-Y;mi\u0012\u001aTC\u0001B;U\u0011\t\u0019Ka\u0002\u0002!A\u0014X\r]1sKN#\u0018\r^3nK:$Hc\u0002@\u0003|\tu$q\u0010\u0005\b\u0003;[\u0002\u0019AA.\u0011\u001d\tIc\u0007a\u0001\u0005/BqAa\u001c\u001c\u0001\u0004\t\u0019+\u0001\u000eqe\u0016\u0004\u0018M]3XSRDw.\u001e;CS:$g+\u0019:jC\ndW\rF\u0003\u007f\u0005\u000b\u00139\tC\u0004\u0002\u001er\u0001\r!a\u0017\t\u000f\t%E\u00041\u0001\u0003X\u0005a1/\u001d7Ti\u0006$X-\\3oi\u00069\u0002O]3qCJ,w+\u001b;i\u0005&tGMV1sS\u0006\u0014G.\u001a\u000b\u0006}\n=%\u0011\u0013\u0005\b\u0003;k\u0002\u0019AA.\u0011\u001d\u0011I)\ba\u0001\u0005/\n1B\u0013#C\u0007^\u0013\u0018\r\u001d9feB\u0011QhH\n\u0006?\te%q\u0014\t\u0004G\nm\u0015b\u0001BO\u0017\n1\u0011I\\=SK\u001a\u0004BA!)\u0003&6\u0011!1\u0015\u0006\u0003uiL1!\u0014BR)\t\u0011)*\u0001\rS\u000b\u0012\u001b\u0006*\u0013$U?*#%iQ05?JzFIU%W\u000bJ+\"A!,\u0011\t\t=&QW\u0007\u0003\u0005cS1Aa-{\u0003\u0011a\u0017M\\4\n\t\u0005\u0015#\u0011W\u0001\u001a%\u0016#5\u000bS%G)~SEIQ\"`i}\u0013t\f\u0012*J-\u0016\u0013\u0006%\u0001\rS\u000b\u0012\u001b\u0006*\u0013$U?*#%iQ05?FzFIU%W\u000bJ\u000b\u0011DU#E'\"Ke\tV0K\t\n\u001bu\fN02?\u0012\u0013\u0016JV#SA\u00051\"+\u0012#T\u0011&3Ek\u0018&E\u0005\u000e{Fg\u0018#S\u0013Z+%+A\fS\u000b\u0012\u001b\u0006*\u0013$U?*#%iQ05?\u0012\u0013\u0016JV#SA\u0005\t\u0002kT*U\u000fJ+5+\u0015'`\tJKe+\u0012*\u0002%A{5\u000bV$S\u000bN\u000bFj\u0018#S\u0013Z+%\u000bI\u0001\u001f'\u0016\u001b%+\u0012+`\u001b\u0006s\u0015iR#S?J+Ei\u0015%J\rR{FIU%W\u000bJ\u000bqdU#D%\u0016#v,T!O\u0003\u001e+%k\u0018*F\tNC\u0015J\u0012+`\tJKe+\u0012*!\u0003q\u0011V\tR*I\u0013\u001a#vLR%S'R{\u0006+\u0011*U3~#%+\u0013,F%N+\"A!4\u0011\r\t='\u0011\u001cBW\u001b\t\u0011\tN\u0003\u0003\u0003T\nU\u0017!C5n[V$\u0018M\u00197f\u0015\r\u00119nS\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bn\u0005#\u00141aU3r\u0003u\u0011V\tR*I\u0013\u001a#vLR%S'R{\u0006+\u0011*U3~#%+\u0013,F%N\u0003\u0013\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001Br!\u0011\u0011yK!:\n\t\t\u001d(\u0011\u0017\u0002\u0007\u001f\nTWm\u0019;")
public class JDBCWrapper
extends RedshiftWrapper {
    private transient Iterator<Object> callNumberGenerator;
    private transient ExecutionContext ec;
    private transient ConcurrentHashMap<PreparedStatement, Object> cancellationMap;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile transient byte bitmap$trans$0;

    public static Seq<String> REDSHIFT_FIRST_PARTY_DRIVERS() {
        return JDBCWrapper$.MODULE$.REDSHIFT_FIRST_PARTY_DRIVERS();
    }

    public static String SECRET_MANAGER_REDSHIFT_DRIVER() {
        return JDBCWrapper$.MODULE$.SECRET_MANAGER_REDSHIFT_DRIVER();
    }

    public static String POSTGRESQL_DRIVER() {
        return JDBCWrapper$.MODULE$.POSTGRESQL_DRIVER();
    }

    public static String REDSHIFT_JDBC_4_DRIVER() {
        return JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_DRIVER();
    }

    public static String REDSHIFT_JDBC_4_1_DRIVER() {
        return JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_1_DRIVER();
    }

    public static String REDSHIFT_JDBC_4_2_DRIVER() {
        return JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_2_DRIVER();
    }

    public Logger log() {
        return this.log;
    }

    private Iterator<Object> callNumberGenerator$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.callNumberGenerator = package$.MODULE$.Iterator().from(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.callNumberGenerator;
    }

    private Iterator<Object> callNumberGenerator() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.callNumberGenerator$lzycompute();
        }
        return this.callNumberGenerator;
    }

    private ExecutionContext ec$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ThreadFactory threadFactory = new ThreadFactory(null){
                    private final AtomicInteger count;

                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setName("spark-redshift-JDBCWrapper-" + this.count.incrementAndGet());
                        thread.setDaemon(true);
                        return thread;
                    }
                    {
                        this.count = new AtomicInteger();
                    }
                };
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.ec;
    }

    private ExecutionContext ec() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.ec$lzycompute();
        }
        return this.ec;
    }

    private ConcurrentHashMap<PreparedStatement, Object> cancellationMap$lzycompute() {
        JDBCWrapper jDBCWrapper = this;
        synchronized (jDBCWrapper) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.cancellationMap = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cancellationMap;
    }

    private ConcurrentHashMap<PreparedStatement, Object> cancellationMap() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.cancellationMap$lzycompute();
        }
        return this.cancellationMap;
    }

    private <T> T executeInterruptibly(PreparedStatement statement, Function1<PreparedStatement, T> op) {
        Object object;
        int callNumber = BoxesRunTime.unboxToInt((Object)this.callNumberGenerator().next());
        try {
            try {
                this.log().info("Begin JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
                this.cancellationMap().put(statement, BoxesRunTime.boxToInteger((int)callNumber));
                Future future = Future$.MODULE$.apply((Function0 & Serializable)() -> op.apply((Object)statement), this.ec());
                try {
                    object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof SQLException) {
                        SQLException sQLException = (SQLException)throwable3;
                        throw new SQLException("Exception thrown in awaitResult: ", sQLException);
                    }
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        throw new Exception("Exception thrown in awaitResult: ", throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                try {
                    statement.cancel();
                    throw e;
                }
                catch (SQLException s) {
                    this.log().error("Exception occurred while cancelling query: {}", (Object)s.getMessage());
                    throw e;
                }
            }
        }
        finally {
            this.cancellationMap().remove(statement);
            this.log().info("End JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
        }
        return (T)object;
    }

    private String getDriverClass(String jdbcSubprotocol, Option<String> userProvidedDriverClass) {
        return (String)userProvidedDriverClass.getOrElse((Function0 & Serializable)() -> {
            String string = jdbcSubprotocol;
            switch (string == null ? 0 : string.hashCode()) {
                case -2105481388: {
                    if (!"postgresql".equals(string)) break;
                    return JDBCWrapper$.MODULE$.POSTGRESQL_DRIVER();
                }
                case -767203695: {
                    String string2;
                    if (!"redshift".equals(string)) break;
                    try {
                        string2 = Utils$.MODULE$.classForName(JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_2_DRIVER()).getName();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            string2 = Utils$.MODULE$.classForName(JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_1_DRIVER()).getName();
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            try {
                                string2 = Utils$.MODULE$.classForName(JDBCWrapper$.MODULE$.REDSHIFT_JDBC_4_DRIVER()).getName();
                            }
                            catch (ClassNotFoundException e) {
                                throw new ClassNotFoundException("Could not load an Amazon Redshift JDBC driver; see the README for instructions on downloading and configuring the official Amazon driver.", e);
                            }
                        }
                    }
                    return string2;
                }
                case 492051356: {
                    if (!"jdbc-secretsmanager".equals(string)) break;
                    return JDBCWrapper$.MODULE$.SECRET_MANAGER_REDSHIFT_DRIVER();
                }
            }
            throw new IllegalArgumentException("Unsupported JDBC protocol: '" + string + "'");
        });
    }

    @Override
    public RedshiftConnection getConnector(Parameters.MergedParameters params) {
        String updatedURL = params.secretId().isDefined() ? ((String)params.jdbcUrl().get()).replaceFirst("jdbc", "jdbc-secretsmanager") : (String)params.jdbcUrl().get();
        Properties driverProperties = new Properties();
        Utils$.MODULE$.copyProperty("user", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperty("password", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperty("secret.id", "user", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperties("^jdbc\\..+", "^jdbc\\.", "", params.parameters(), driverProperties);
        Utils$.MODULE$.copyProperties("^secret\\..+", "^secret\\.", "drivers\\.", (Map<String, String>)((Map)params.parameters().$minus((Object)"secret.id")), System.getProperties());
        Object object = !updatedURL.toLowerCase().contains("applicationname=") && !driverProperties.containsKey("applicationname") ? driverProperties.setProperty("applicationname", Utils$.MODULE$.getApplicationName(params)) : BoxedUnit.UNIT;
        String subprotocol = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(updatedURL), "jdbc:").split(":")[0];
        String driverClass = this.getDriverClass(subprotocol, params.jdbcDriver());
        DriverRegistry$.MODULE$.register(driverClass);
        Class<?> driverWrapperClass = org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("1.4") ? Utils$.MODULE$.classForName("org.apache.spark.sql.jdbc.package$DriverWrapper") : Utils$.MODULE$.classForName("org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper");
        Utils$.MODULE$.checkJDBCSecurity(driverClass, updatedURL, driverProperties);
        Driver driver = (Driver)((IterableOnceOps)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new Serializable(this, driverWrapperClass, driverClass){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCWrapper $outer;
            private final Class driverWrapperClass$1;
            private final String driverClass$1;

            public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(A1.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$data$JDBCWrapper$$getWrapped$1(A1, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)A1;
                    }
                }
                String string = A1.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Driver x1) {
                Driver driver = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(driver.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$data$JDBCWrapper$$getWrapped$1(driver, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                String string = driver.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                return !(string != null ? !string.equals(string3) : string3 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverWrapperClass$1 = driverWrapperClass$1;
                this.driverClass$1 = driverClass$1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Did not find registered driver with class " + driverClass);
        });
        Connection conn = driver.connect(updatedURL, driverProperties);
        return new JDBCConnection(conn);
    }

    @Override
    public RedshiftConnection getConnectorWithQueryGroup(Parameters.MergedParameters params, String queryGroup) {
        RedshiftConnection redshiftConnection;
        RedshiftConnection conn = this.getConnector(params);
        try {
            this.executeInterruptibly(conn, "set query_group to '" + queryGroup + "'");
            redshiftConnection = conn;
        }
        catch (Throwable e) {
            this.log().debug("Unable to set query group: " + e.getMessage());
            conn.close();
            redshiftConnection = this.getConnector(params);
        }
        return redshiftConnection;
    }

    @Override
    public void setAutoCommit(RedshiftConnection conn, boolean autoCommit) {
        conn.setAutoCommit(autoCommit);
    }

    @Override
    public void commit(RedshiftConnection conn) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        jdbcConnection.conn().commit();
    }

    @Override
    public void rollback(RedshiftConnection conn) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        jdbcConnection.conn().rollback();
    }

    @Override
    public boolean executeInterruptibly(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute())));
    }

    @Override
    public RedshiftResults executeQueryInterruptibly(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        ResultSet resultSet = (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable)x$2 -> x$2.executeQuery());
        return new JDBCResults(resultSet);
    }

    @Override
    public long executeUpdateInterruptibly(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        return BoxesRunTime.unboxToLong(this.executeInterruptibly(statement, (Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.executeLargeUpdate())));
    }

    @Override
    public long executeUpdate(RedshiftConnection conn, String sql) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        PreparedStatement statement = jdbcConnection.conn().prepareStatement(sql);
        return BoxesRunTime.unboxToLong(this.executeInterruptibly(statement, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.executeUpdate())));
    }

    @Override
    public StructType resolveTable(RedshiftConnection conn, String table, Option<Parameters.MergedParameters> params) {
        StructType structType;
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        try (PreparedStatement ps = jdbcConnection.conn().prepareStatement("SELECT * FROM " + table + " LIMIT 1");){
            this.log().info("Getting schema from Redshift for table: {}", (Object)table);
            ResultSetMetaData rsmd = (ResultSetMetaData)this.executeInterruptibly(ps, (Function1 & Serializable)x$5 -> x$5.getMetaData());
            int ncols = rsmd.getColumnCount();
            StructField[] fields = new StructField[ncols];
            for (int i = 0; i < ncols; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                String rsType = rsmd.getColumnTypeName(i + 1);
                int dataType = rsmd.getColumnType(i + 1);
                int fieldSize = rsmd.getPrecision(i + 1);
                int fieldScale = rsmd.getScale(i + 1);
                boolean isSigned = rsmd.isSigned(i + 1);
                boolean nullable = params.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.overrideNullable())) ? true : rsmd.isNullable(i + 1) != 0;
                DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned, params);
                Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
                fields[i] = new StructField(columnName, columnType, nullable, meta);
            }
            structType = new StructType(fields);
        }
        return structType;
    }

    @Override
    public Option<Parameters.MergedParameters> resolveTable$default$3() {
        return None$.MODULE$;
    }

    private StructType resolveTableFromMeta(ResultSetMetaData rsmd, Parameters.MergedParameters params) {
        int ncols = rsmd.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 0; i < ncols; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            String rsType = rsmd.getColumnTypeName(i + 1);
            int dataType = rsmd.getColumnType(i + 1);
            int fieldSize = rsmd.getPrecision(i + 1);
            int fieldScale = rsmd.getScale(i + 1);
            boolean isSigned = rsmd.isSigned(i + 1);
            boolean nullable = rsmd.isNullable(i + 1) != 0;
            DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned, (Option<Parameters.MergedParameters>)new Some((Object)params));
            Metadata meta = new MetadataBuilder().putString("redshift_type", rsType).build();
            fields[i] = new StructField((String)(columnName.matches("[_A-Z]([_0-9A-Z])*") ? columnName : "\"" + columnName + "\""), columnType, nullable, meta);
        }
        return new StructType(fields);
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed, Option<Parameters.MergedParameters> params) {
        int n = sqlType;
        StringType$ answer = switch (n) {
            case 0 -> null;
            case 1 -> StringType$.MODULE$;
            case -15 -> StringType$.MODULE$;
            case -9 -> StringType$.MODULE$;
            case 12 -> StringType$.MODULE$;
            case -1 -> StringType$.MODULE$;
            case 91 -> DateType$.MODULE$;
            case 92 -> TimestampType$.MODULE$;
            case 93 -> TimestampType$.MODULE$;
            case 2014 -> TimestampType$.MODULE$;
            case -7 -> BooleanType$.MODULE$;
            case 16 -> BooleanType$.MODULE$;
            case -5 -> {
                if (signed) {
                    yield LongType$.MODULE$;
                }
                yield new DecimalType(20, 0);
            }
            case 3 -> {
                if (precision != 0 || scale != 0) {
                    yield new DecimalType(precision, scale);
                }
                yield new DecimalType(38, 18);
            }
            case 8 -> DoubleType$.MODULE$;
            case 6 -> FloatType$.MODULE$;
            case 4 -> {
                if (signed) {
                    yield IntegerType$.MODULE$;
                }
                yield LongType$.MODULE$;
            }
            case 2 -> {
                if (precision != 0 || scale != 0) {
                    yield new DecimalType(precision, scale);
                }
                yield new DecimalType(38, 18);
            }
            case 7 -> {
                if (params.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.legacyJdbcRealTypeMapping()))) {
                    yield DoubleType$.MODULE$;
                }
                yield FloatType$.MODULE$;
            }
            case 5 -> {
                if (params.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.legacyMappingShortToInt()))) {
                    yield IntegerType$.MODULE$;
                }
                yield ShortType$.MODULE$;
            }
            case -6 -> ByteType$.MODULE$;
            default -> null;
        };
        if (answer == null) {
            throw new SQLException("Unsupported type " + sqlType);
        }
        return answer;
    }

    private Option<Parameters.MergedParameters> getCatalystType$default$5() {
        return None$.MODULE$;
    }

    @Override
    public boolean tableExists(RedshiftConnection conn, String table) {
        JDBCConnection jdbcConnection = (JDBCConnection)conn;
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            PreparedStatement stmt = jdbcConnection.conn().prepareStatement("SELECT 1 FROM " + table + " LIMIT 1");
            this.log().info("Checking if table exists: {}", (Object)table);
            return ((ResultSetMetaData)this.executeInterruptibly(stmt, (Function1 & Serializable)x$9 -> x$9.getMetaData())).getColumnCount();
        }).isSuccess();
    }

    @Override
    public StructType tableSchema(RedshiftConnection conn, RedshiftSQLStatement statement, Parameters.MergedParameters params) {
        return this.resolveTableFromMeta(this.tableMetaDataFromStatement(conn, statement, this.tableMetaDataFromStatement$default$3()), params);
    }

    private ResultSetMetaData tableMetaDataFromStatement(RedshiftConnection conn, RedshiftSQLStatement statement, boolean bindVariableEnabled) {
        RedshiftSQLStatement sqlStatement = new ConstantString("select * from").$plus(statement).$plus("where 1 = 0");
        return this.prepareStatement(conn, sqlStatement, bindVariableEnabled).getMetaData();
    }

    private boolean tableMetaDataFromStatement$default$3() {
        return true;
    }

    private PreparedStatement prepareStatement(RedshiftConnection conn, RedshiftSQLStatement statement, boolean bindVariableEnabled) {
        if (bindVariableEnabled) {
            return this.prepareWithBindVariable(conn, statement);
        }
        return this.prepareWithoutBindVariable(conn, statement);
    }

    private PreparedStatement prepareWithoutBindVariable(RedshiftConnection conn, RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        String query = ((StringBuilder)sql.foldLeft((Object)new StringBuilder(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                StringBuilder buffer = (StringBuilder)tuple2._1();
                StatementElement statement = (StatementElement)tuple2._2();
                buffer.append(statement instanceof ConstantString ? statement : statement.sql());
                return buffer.append(" ");
            }
            throw new MatchError((Object)tuple2);
        })).toString();
        String logPrefix = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.MASTER_LOG_PREFIX() + ":\n                       | execute query without bind variable:\n                       |"))), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$prepareWithoutBindVariable$2(BoxesRunTime.unboxToChar((Object)x$10))));
        return ((JDBCConnection)conn).conn().prepareStatement(query);
    }

    private PreparedStatement prepareWithBindVariable(RedshiftConnection conn, RedshiftSQLStatement sqlStatement) {
        List sql = sqlStatement.list().reverse();
        StatementElement[] varArray = new StatementElement[sqlStatement.numOfVar()];
        IntRef indexOfVar = IntRef.create((int)0);
        StringBuilder buffer = new StringBuilder();
        sql.foreach((Function1 & Serializable)element -> {
            block0: {
                buffer.append(element);
                if (element instanceof ConstantString) break block0;
                varArray$1[indexOfVar$1.elem] = element;
                ++indexOfVar$1.elem;
            }
            return buffer.append(" ");
        });
        String query = buffer.toString();
        String logPrefix = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.MASTER_LOG_PREFIX() + ":\n                       | execute query with bind variable:\n                       |"))), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCWrapper.$anonfun$prepareWithBindVariable$2(BoxesRunTime.unboxToChar((Object)x$11))));
        PreparedStatement statement = ((JDBCConnection)conn).conn().prepareStatement(query);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])varArray))), (Function1 & Serializable)x0$1 -> {
            JDBCWrapper.$anonfun$prepareWithBindVariable$3(statement, x0$1);
            return BoxedUnit.UNIT;
        });
        return statement;
    }

    public static final /* synthetic */ void $anonfun$new$2(JDBCWrapper $this, PreparedStatement statement, int callNumber) {
        try {
            $this.log().info("Cancelling pending JDBC call {}", (Object)BoxesRunTime.boxToInteger((int)callNumber));
            statement.cancel();
        }
        catch (Throwable e) {
            $this.log().error("Exception occurred while cancelling statement: {}", (Object)e.getMessage());
        }
    }

    public static final Driver io$github$spark_redshift_community$spark$redshift$data$JDBCWrapper$$getWrapped$1(Driver d, Class driverWrapperClass$1) {
        Predef$.MODULE$.require(driverWrapperClass$1.isAssignableFrom(d.getClass()));
        return (Driver)driverWrapperClass$1.getDeclaredMethod("wrapped", new Class[0]).invoke((Object)d, new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithoutBindVariable$2(char x$10) {
        return x$10 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$prepareWithBindVariable$2(char x$11) {
        return x$11 >= ' ';
    }

    public static final /* synthetic */ void $anonfun$prepareWithBindVariable$3(PreparedStatement statement$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StatementElement element = (StatementElement)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StatementElement statementElement = element;
            if (statementElement instanceof StringVariable) {
                StringVariable stringVariable = (StringVariable)statementElement;
                if (stringVariable.variable().isDefined()) {
                    statement$2.setString(index + 1, (String)stringVariable.variable().get());
                } else {
                    statement$2.setNull(index + 1, 12);
                }
            } else if (statementElement instanceof Identifier) {
                Identifier identifier = (Identifier)statementElement;
                statement$2.setString(index + 1, (String)identifier.variable().get());
            } else if (statementElement instanceof IntVariable) {
                IntVariable intVariable = (IntVariable)statementElement;
                if (intVariable.variable().isDefined()) {
                    statement$2.setInt(index + 1, BoxesRunTime.unboxToInt((Object)intVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, 4);
                }
            } else if (statementElement instanceof LongVariable) {
                LongVariable longVariable = (LongVariable)statementElement;
                if (longVariable.variable().isDefined()) {
                    statement$2.setLong(index + 1, BoxesRunTime.unboxToLong((Object)longVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, -5);
                }
            } else if (statementElement instanceof ShortVariable) {
                ShortVariable shortVariable = (ShortVariable)statementElement;
                if (shortVariable.variable().isDefined()) {
                    statement$2.setShort(index + 1, BoxesRunTime.unboxToShort((Object)shortVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, 5);
                }
            } else if (statementElement instanceof FloatVariable) {
                FloatVariable floatVariable = (FloatVariable)statementElement;
                if (floatVariable.variable().isDefined()) {
                    statement$2.setFloat(index + 1, BoxesRunTime.unboxToFloat((Object)floatVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, 6);
                }
            } else if (statementElement instanceof DoubleVariable) {
                DoubleVariable doubleVariable = (DoubleVariable)statementElement;
                if (doubleVariable.variable().isDefined()) {
                    statement$2.setDouble(index + 1, BoxesRunTime.unboxToDouble((Object)doubleVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, 8);
                }
            } else if (statementElement instanceof BooleanVariable) {
                BooleanVariable booleanVariable = (BooleanVariable)statementElement;
                if (booleanVariable.variable().isDefined()) {
                    statement$2.setBoolean(index + 1, BoxesRunTime.unboxToBoolean((Object)booleanVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, 16);
                }
            } else if (statementElement instanceof ByteVariable) {
                ByteVariable byteVariable = (ByteVariable)statementElement;
                if (byteVariable.variable().isDefined()) {
                    statement$2.setByte(index + 1, BoxesRunTime.unboxToByte((Object)byteVariable.variable().get()));
                } else {
                    statement$2.setNull(index + 1, -6);
                }
            } else {
                throw new IllegalArgumentException("Unexpected Element Type: " + element.getClass().getName());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCWrapper() {
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> this.cancellationMap().forEach((statement, callNumber) -> JDBCWrapper.$anonfun$new$2(this, statement, BoxesRunTime.unboxToInt((Object)callNumber))));
    }
}

