/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift.data;

import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.data.DataAPIConnection;
import io.github.spark_redshift_community.spark.redshift.data.DataApiCommand$;
import io.github.spark_redshift_community.spark.redshift.data.DataApiResults;
import io.github.spark_redshift_community.spark.redshift.data.DataApiRuntimeException;
import io.github.spark_redshift_community.spark.redshift.data.QueryParameter;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;
import software.amazon.awssdk.services.redshiftdata.model.SqlParameter;
import software.amazon.awssdk.services.redshiftdata.model.StatusString;
import software.amazon.awssdk.services.redshiftdata.model.SubStatementData;
import software.amazon.awssdk.services.redshiftdata.model.ValidationException;

@ScalaSignature(bytes="\u0006\u0005\t-c\u0001B\u00181\u0001uB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\")!\r\u0001C\u0001G\"9Q\u000e\u0001b\u0001\n\u0013q\u0007BB<\u0001A\u0003%q\u000eC\u0004y\u0001\u0001\u0007I\u0011B=\t\u0013\u0005E\u0001\u00011A\u0005\n\u0005M\u0001bBA\u0010\u0001\u0001\u0006KA\u001f\u0005\n\u0003C\u0001\u0001\u0019!C\u0005\u0003GA\u0011\"a\u000f\u0001\u0001\u0004%I!!\u0010\t\u0011\u0005\u0005\u0003\u0001)Q\u0005\u0003KAq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003o\u0002A\u0011BA\u0012\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!a \u0001\t\u0013\t\t\tC\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"I\u0011q\u0012\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u00111\u0015\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003K\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u0011q\u0015\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u00111\u0016\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u0011q\u0016\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002\u0014\"I\u00111\u0017\u0001C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u0002\u0014\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAd\u0001\u0011%\u0011Q\u0012\u0005\b\u0003\u0013\u0004A\u0011BA;\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!6\u0001\t\u0013\t9\u000eC\u0004\u0002Z\u0002!I!!\u001e\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"I\u00111 \u0001\u0012\u0002\u0013%\u0011Q \u0005\b\u0005/\u0001A\u0011\u0002B\r\u000f%\u0011\t\u0004MA\u0001\u0012\u0003\u0011\u0019D\u0002\u00050a\u0005\u0005\t\u0012\u0001B\u001b\u0011\u0019\u0011G\u0006\"\u0001\u00038!I!\u0011\b\u0017\u0012\u0002\u0013\u0005!1\b\u0002\u000f\t\u0006$\u0018-\u00119j\u0007>lW.\u00198e\u0015\t\t$'\u0001\u0003eCR\f'BA\u001a5\u0003!\u0011X\rZ:iS\u001a$(BA\u001b7\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0004(\u0001\rta\u0006\u00148n\u0018:fIND\u0017N\u001a;`G>lW.\u001e8jifT!!\u000f\u001e\u0002\r\u001dLG\u000f[;c\u0015\u0005Y\u0014AA5p\u0007\u0001\u0019\"\u0001\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r\u0005s\u0017PU3g\u0003)\u0019wN\u001c8fGRLwN\u001c\t\u0003\r\u001ek\u0011\u0001M\u0005\u0003\u0011B\u0012\u0011\u0003R1uC\u0006\u0003\u0016jQ8o]\u0016\u001cG/[8o\u0003\u0019\u0001\u0018M]1ngB\u0019qhS'\n\u00051\u0003%AB(qi&|g\u000eE\u0002O#Nk\u0011a\u0014\u0006\u0003!\u0002\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u0011vJA\u0002TKF\u0004$\u0001V-\u0011\u0007\u0019+v+\u0003\u0002Wa\tq\u0011+^3ssB\u000b'/Y7fi\u0016\u0014\bC\u0001-Z\u0019\u0001!\u0011B\u0017\u0002\u0002\u0002\u0003\u0005)\u0011A.\u0003\u0007}#\u0013'\u0005\u0002]?B\u0011q(X\u0005\u0003=\u0002\u0013qAT8uQ&tw\r\u0005\u0002@A&\u0011\u0011\r\u0011\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\bF\u0002eK\u001a\u0004\"A\u0012\u0001\t\u000b\u0011\u001b\u0001\u0019A#\t\u000f%\u001b\u0001\u0013!a\u0001OB\u0019qh\u00135\u0011\u00079\u000b\u0016\u000e\r\u0002kYB\u0019a)V6\u0011\u0005acG!\u0003.g\u0003\u0003\u0005\tQ!\u0001\\\u0003\rawnZ\u000b\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0006g24GG\u001b\u0006\u0002i\u0006\u0019qN]4\n\u0005Y\f(A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013AB2mS\u0016tG/F\u0001{!\rY\u0018QB\u0007\u0002y*\u0011QP`\u0001\re\u0016$7\u000f[5gi\u0012\fG/\u0019\u0006\u0004\u007f\u0006\u0005\u0011\u0001C:feZL7-Z:\u000b\t\u0005\r\u0011QA\u0001\u0007C^\u001c8\u000fZ6\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0007C6\f'p\u001c8\u000b\u0005\u0005-\u0011\u0001C:pMR<\u0018M]3\n\u0007\u0005=AP\u0001\nSK\u0012\u001c\b.\u001b4u\t\u0006$\u0018m\u00117jK:$\u0018AC2mS\u0016tGo\u0018\u0013fcR!\u0011QCA\u000e!\ry\u0014qC\u0005\u0004\u00033\u0001%\u0001B+oSRD\u0001\"!\b\b\u0003\u0003\u0005\rA_\u0001\u0004q\u0012\n\u0014aB2mS\u0016tG\u000fI\u0001\ne\u0016\fX/Z:u\u0013\u0012,\"!!\n\u0011\t\u0005\u001d\u0012Q\u0007\b\u0005\u0003S\t\t\u0004E\u0002\u0002,\u0001k!!!\f\u000b\u0007\u0005=B(\u0001\u0004=e>|GOP\u0005\u0004\u0003g\u0001\u0015A\u0002)sK\u0012,g-\u0003\u0003\u00028\u0005e\"AB*ue&twMC\u0002\u00024\u0001\u000bQB]3rk\u0016\u001cH/\u00133`I\u0015\fH\u0003BA\u000b\u0003\u007fA\u0011\"!\b\u000b\u0003\u0003\u0005\r!!\n\u0002\u0015I,\u0017/^3ti&#\u0007%A\u0004fq\u0016\u001cW\u000f^3\u0015\t\u0005\u001d\u0013Q\n\t\u0004\u007f\u0005%\u0013bAA&\u0001\n9!i\\8mK\u0006t\u0007bBA(\u0019\u0001\u0007\u0011QE\u0001\u0004gFd\u0017!D3yK\u000e,H/Z+qI\u0006$X\r\u0006\u0003\u0002V\u0005m\u0003cA \u0002X%\u0019\u0011\u0011\f!\u0003\t1{gn\u001a\u0005\b\u0003\u001fj\u0001\u0019AA\u0013\u0003e)\u00070Z2vi\u0016\fV/\u001a:z\u0013:$XM\u001d:vaRL'\r\\=\u0015\t\u0005\u0005\u0014q\r\t\u0004\r\u0006\r\u0014bAA3a\ty!+\u001a3tQ&4GOU3tk2$8\u000fC\u0004\u0002P9\u0001\r!!\n\u0002\u0019\u0015DXmY;uK\n\u000bGo\u00195\u0015\t\u0005\u001d\u0013Q\u000e\u0005\b\u0003_z\u0001\u0019AA9\u0003\u0011\u0019\u0018\u000f\\:\u0011\t9\u000b\u0016QE\u0001\u0007G\u0006t7-\u001a7\u0015\u0005\u0005\u001d\u0013aD1qa2L7-\u0019;j_:t\u0015-\\3\u0002'\rDWmY6Fq\u0016\u001cW\u000f^3B]\u0012<\u0016-\u001b;\u0015\t\u0005U\u0011Q\u0010\u0005\b\u0003_\u0012\u0002\u0019AA9\u0003Q\u0019\u0018N\\4mK\u0016CXmY;uK\u0006sGmV1jiR!\u0011QCAB\u0011\u001d\tye\u0005a\u0001\u0003K\t1CY1uG\",\u00050Z2vi\u0016\fe\u000eZ,bSR$B!!\u0006\u0002\n\"9\u0011q\u000e\u000bA\u0002\u0005E\u0014aF5oSRL\u0017\r\\5{K\u0012\u000bG/Y!qS\u000ec\u0017.\u001a8u)\t\t)\"\u0001\u000fE\u0003R\u000bu,\u0011)J?J+EKU-`\t\u0016c\u0015)W0N\u0013:{6*R-\u0016\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001e\u0006!!.\u0019<b\u0013\u0011\t9$a&\u0002;\u0011\u000bE+Q0B!&{&+\u0012+S3~#U\tT!Z?6KejX&F3\u0002\nA\u0004R!U\u0003~\u000b\u0005+S0S\u000bR\u0013\u0016l\u0018#F\u0019\u0006Kv,T!Y?.+\u0015,A\u000fE\u0003R\u000bu,\u0011)J?J+EKU-`\t\u0016c\u0015)W0N\u0003b{6*R-!\u0003u!\u0015\tV!`\u0003BKuLU#U%f{F)\u0012'B3~kU\u000b\u0014+`\u0017\u0016K\u0016A\b#B)\u0006{\u0016\tU%`%\u0016#&+W0E\u000b2\u000b\u0015lX'V\u0019R{6*R-!\u0003\u0001\"\u0015\tV!`\u0003BKuLU#U%f{F)\u0012'B3~k\u0015JT0E\u000b\u001a\u000bU\u000b\u0014+\u0002C\u0011\u000bE+Q0B!&{&+\u0012+S3~#U\tT!Z?6Kej\u0018#F\r\u0006+F\n\u0016\u0011\u0002A\u0011\u000bE+Q0B!&{&+\u0012+S3~#U\tT!Z?6\u000b\u0005l\u0018#F\r\u0006+F\nV\u0001\"\t\u0006#\u0016iX!Q\u0013~\u0013V\t\u0016*Z?\u0012+E*Q-`\u001b\u0006Cv\fR#G\u0003VcE\u000bI\u0001\"\t\u0006#\u0016iX!Q\u0013~\u0013V\t\u0016*Z?\u0012+E*Q-`\u001bVcEk\u0018#F\r\u0006+F\nV\u0001#\t\u0006#\u0016iX!Q\u0013~\u0013V\t\u0016*Z?\u0012+E*Q-`\u001bVcEk\u0018#F\r\u0006+F\n\u0016\u0011\u0002+\u001d,G\u000fR1uC\u0006\u0003\u0018\u000eR3mCf\u0004\u0016M]1ngR\u0011\u00111\u0018\t\n\u007f\u0005u\u0016\u0011YAa\u0003\u0003L1!a0A\u0005\u0019!V\u000f\u001d7fgA\u0019q(a1\n\u0007\u0005\u0015\u0007I\u0001\u0004E_V\u0014G.Z\u0001\u0010C^\f\u0017\u000e^\"p[BdW\r^5p]\u0006Q\u0001.Y:SKN,H\u000e^:\u0002\u0015\u001d,GOU3tk2$8\u000f\u0006\u0002\u0002PB\u0019a)!5\n\u0007\u0005M\u0007G\u0001\bECR\f\u0017\t]5SKN,H\u000e^:\u0002\u001b\u001d,GOU3tk2$(k\\<t)\t\t)&A\u0007dC:\u001cW\r\u001c*fcV,7\u000f^\u0001\u0011Kb,7-\u001e;f/&$\bNU3uef,B!a8\u0002dR1\u0011\u0011]At\u0003c\u00042\u0001WAr\t\u0019\t)\u000f\u000bb\u00017\n\tA\u000bC\u0004\u0002j\"\u0002\r!a;\u0002\u0013=\u0004XM]1uS>t\u0007#B \u0002n\u0006\u0005\u0018bAAx\u0001\nIa)\u001e8di&|g\u000e\r\u0005\n\u0003gD\u0003\u0013!a\u0001\u0003k\f!\"\\1y%\u0016$(/[3t!\ry\u0014q_\u0005\u0004\u0003s\u0004%aA%oi\u0006QR\r_3dkR,w+\u001b;i%\u0016$(/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011q B\u000b+\t\u0011\tA\u000b\u0003\u0002v\n\r1F\u0001B\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=\u0001)\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\r\u0005\u0015\u0018F1\u0001\\\u0003UI7\u000f\u00165s_R$H.\u001b8h\u000bb\u001cW\r\u001d;j_:$B!a\u0012\u0003\u001c!9!Q\u0004\u0016A\u0002\t}\u0011AA3y!\u0011\u0011\tCa\u000b\u000f\t\t\r\"q\u0005\b\u0005\u0003W\u0011)#C\u0001B\u0013\r\u0011I\u0003Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iCa\f\u0003\u0013QC'o\\<bE2,'b\u0001B\u0015\u0001\u0006qA)\u0019;b\u0003BL7i\\7nC:$\u0007C\u0001$-'\tac\b\u0006\u0002\u00034\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"A!\u0010+\t\t}\"1\u0001\t\u0005\u007f-\u0013\t\u0005\u0005\u0003O#\n\r\u0003\u0007\u0002B#\u0005\u0013\u0002BAR+\u0003HA\u0019\u0001L!\u0013\u0005\u0013is\u0013\u0011!A\u0001\u0006\u0003Y\u0006")
public class DataApiCommand {
    private final DataAPIConnection connection;
    private final Option<Seq<QueryParameter<?>>> params;
    private final Logger log;
    private RedshiftDataClient client;
    private String requestId;
    private final String DATA_API_RETRY_DELAY_MIN_KEY;
    private final String DATA_API_RETRY_DELAY_MAX_KEY;
    private final String DATA_API_RETRY_DELAY_MULT_KEY;
    private final String DATA_API_RETRY_DELAY_MIN_DEFAULT;
    private final String DATA_API_RETRY_DELAY_MAX_DEFAULT;
    private final String DATA_API_RETRY_DELAY_MULT_DEFAULT;

    public static Option<Seq<QueryParameter<?>>> $lessinit$greater$default$2() {
        return DataApiCommand$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger log() {
        return this.log;
    }

    private RedshiftDataClient client() {
        return this.client;
    }

    private void client_$eq(RedshiftDataClient x$1) {
        this.client = x$1;
    }

    private String requestId() {
        return this.requestId;
    }

    private void requestId_$eq(String x$1) {
        this.requestId = x$1;
    }

    public boolean execute(String sql) {
        this.checkExecuteAndWait((Seq<String>)new .colon.colon((Object)sql, (List)Nil$.MODULE$));
        return this.hasResults();
    }

    public long executeUpdate(String sql) {
        this.checkExecuteAndWait((Seq<String>)new .colon.colon((Object)sql, (List)Nil$.MODULE$));
        return this.getResultRows();
    }

    public RedshiftResults executeQueryInterruptibly(String sql) {
        this.checkExecuteAndWait((Seq<String>)new .colon.colon((Object)sql, (List)Nil$.MODULE$));
        return this.getResults();
    }

    public boolean executeBatch(Seq<String> sqls) {
        this.checkExecuteAndWait(sqls);
        return this.hasResults();
    }

    public boolean cancel() {
        return this.cancelRequest();
    }

    private String applicationName() {
        return "Client:" + Utils$.MODULE$.getApplicationName(this.connection.params());
    }

    private void checkExecuteAndWait(Seq<String> sqls) {
        Seq updatedSqls;
        if (sqls == null || sqls.isEmpty() || sqls.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
            throw new IllegalArgumentException("Data API cannot execute missing or empty commands!");
        }
        if (this.connection.queryGroup().isDefined()) {
            String strQG = "set query_group to '" + this.connection.queryGroup().get() + "'";
            v0 = (Seq)((Growable)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{strQG}))).$plus$plus$eq(sqls);
        } else {
            v0 = updatedSqls = sqls;
        }
        if (this.params.isDefined() && updatedSqls.length() > 1) {
            throw new IllegalArgumentException("Data API parameters require a single command with no query group specified!");
        }
        if (updatedSqls.length() == 1) {
            this.singleExecuteAndWait((String)updatedSqls.head());
            return;
        }
        this.batchExecuteAndWait(updatedSqls);
    }

    private void singleExecuteAndWait(String sql) {
        Seq sqlParams;
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Cannot execute null or empty command!");
        }
        this.initializeDataApiClient();
        ExecuteStatementRequest.Builder statementRequestBuilder = ExecuteStatementRequest.builder().database((String)this.connection.params().dataApiDatabase().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Data API database is required!");
        })).sql(sql).statementName(this.applicationName());
        Object object = this.connection.params().dataApiCluster().isDefined() ? statementRequestBuilder.clusterIdentifier((String)this.connection.params().dataApiCluster().get()) : BoxedUnit.UNIT;
        Object object2 = this.connection.params().dataApiWorkgroup().isDefined() ? statementRequestBuilder.workgroupName((String)this.connection.params().dataApiWorkgroup().get()) : BoxedUnit.UNIT;
        Object object3 = this.connection.params().dataApiUser().isDefined() ? statementRequestBuilder.dbUser((String)this.connection.params().dataApiUser().get()) : BoxedUnit.UNIT;
        Object object4 = this.connection.params().secretId().isDefined() ? statementRequestBuilder.secretArn((String)this.connection.params().secretId().get()) : BoxedUnit.UNIT;
        Object object5 = this.params.isDefined() ? ((sqlParams = (Seq)((IterableOps)this.params.get()).map((Function1 & Serializable)qp -> {
            if (qp.value().isEmpty() || qp.value().get().toString().isEmpty()) {
                throw new IllegalArgumentException("Query parameters must not be null or non-empty!");
            }
            return (SqlParameter)SqlParameter.builder().name(qp.name()).value(qp.value().get().toString()).build();
        })).nonEmpty() ? statementRequestBuilder.parameters((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(sqlParams).asJava()) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        ExecuteStatementResponse result = (ExecuteStatementResponse)this.executeWithRetry((Function0 & Serializable)() -> this.client().executeStatement((ExecuteStatementRequest)statementRequestBuilder.build()), this.executeWithRetry$default$2());
        this.requestId_$eq(result.id());
        this.log().info("Issued Redshift Data API execute statement with request id: {}", (Object)this.requestId());
        this.awaitCompletion();
    }

    private void batchExecuteAndWait(Seq<String> sqls) {
        if (sqls == null || sqls.isEmpty() || sqls.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()))) {
            throw new IllegalArgumentException("Batch execution requires at least one command!");
        }
        this.initializeDataApiClient();
        BatchExecuteStatementRequest.Builder statementRequestBuilder = BatchExecuteStatementRequest.builder().database((String)this.connection.params().dataApiDatabase().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Data API database is required!");
        })).sqls((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(sqls).asJava()).statementName(this.applicationName());
        Object object = this.connection.params().dataApiCluster().isDefined() ? statementRequestBuilder.clusterIdentifier((String)this.connection.params().dataApiCluster().get()) : BoxedUnit.UNIT;
        Object object2 = this.connection.params().dataApiWorkgroup().isDefined() ? statementRequestBuilder.workgroupName((String)this.connection.params().dataApiWorkgroup().get()) : BoxedUnit.UNIT;
        Object object3 = this.connection.params().dataApiUser().isDefined() ? statementRequestBuilder.dbUser((String)this.connection.params().dataApiUser().get()) : BoxedUnit.UNIT;
        Object object4 = this.connection.params().secretId().isDefined() ? statementRequestBuilder.secretArn((String)this.connection.params().secretId().get()) : BoxedUnit.UNIT;
        if (this.params.isDefined()) {
            throw new IllegalArgumentException("Parameters are not permitted with Data API batch execution!");
        }
        BatchExecuteStatementResponse result = (BatchExecuteStatementResponse)this.executeWithRetry((Function0 & Serializable)() -> this.client().batchExecuteStatement((BatchExecuteStatementRequest)statementRequestBuilder.build()), this.executeWithRetry$default$2());
        this.requestId_$eq(result.id());
        this.log().info("Issued Redshift Data API batch execute statement with request id: {}", (Object)this.requestId());
        this.awaitCompletion();
    }

    private void initializeDataApiClient() {
        this.client_$eq(Utils$.MODULE$.createDataApiClient(this.connection.params().dataApiRegion(), Utils$.MODULE$.createDataApiClient$default$2()));
    }

    public String DATA_API_RETRY_DELAY_MIN_KEY() {
        return this.DATA_API_RETRY_DELAY_MIN_KEY;
    }

    public String DATA_API_RETRY_DELAY_MAX_KEY() {
        return this.DATA_API_RETRY_DELAY_MAX_KEY;
    }

    public String DATA_API_RETRY_DELAY_MULT_KEY() {
        return this.DATA_API_RETRY_DELAY_MULT_KEY;
    }

    public String DATA_API_RETRY_DELAY_MIN_DEFAULT() {
        return this.DATA_API_RETRY_DELAY_MIN_DEFAULT;
    }

    public String DATA_API_RETRY_DELAY_MAX_DEFAULT() {
        return this.DATA_API_RETRY_DELAY_MAX_DEFAULT;
    }

    public String DATA_API_RETRY_DELAY_MULT_DEFAULT() {
        return this.DATA_API_RETRY_DELAY_MULT_DEFAULT;
    }

    private Tuple3<Object, Object, Object> getDataApiDelayParams() {
        double retryDelayMin = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkConfigValue(this.DATA_API_RETRY_DELAY_MIN_KEY(), this.DATA_API_RETRY_DELAY_MIN_DEFAULT())));
        double retryDelayMax = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkConfigValue(this.DATA_API_RETRY_DELAY_MAX_KEY(), this.DATA_API_RETRY_DELAY_MAX_DEFAULT())));
        double retryDelayMult = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.getSparkConfigValue(this.DATA_API_RETRY_DELAY_MULT_KEY(), this.DATA_API_RETRY_DELAY_MULT_DEFAULT())));
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)retryDelayMin), (Object)BoxesRunTime.boxToDouble((double)retryDelayMax), (Object)BoxesRunTime.boxToDouble((double)retryDelayMult));
    }

    private void awaitCompletion() {
        StatusString statusString;
        StatusString statusString2;
        DescribeStatementRequest describeStatementRequest = (DescribeStatementRequest)DescribeStatementRequest.builder().id(this.requestId()).build();
        DescribeStatementResponse describeResult = null;
        Tuple3<Object, Object, Object> tuple3 = this.getDataApiDelayParams();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double retryDelayMin = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double retryDelayMax = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double retryDelayMult = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)retryDelayMin), (Object)BoxesRunTime.boxToDouble((double)retryDelayMax), (Object)BoxesRunTime.boxToDouble((double)retryDelayMult));
        double retryDelayMin2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double retryDelayMax2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double retryDelayMult2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        double period = retryDelayMin2;
        do {
            Thread.sleep((long)period);
            period *= retryDelayMult2;
            period = Math.min(period, retryDelayMax2);
            describeResult = this.client().describeStatement(describeStatementRequest);
            StatusString statusString3 = describeResult.status();
            StatusString statusString4 = StatusString.FINISHED;
            if (!(statusString3 == null ? statusString4 != null : !statusString3.equals(statusString4))) break;
            StatusString statusString5 = describeResult.status();
            StatusString statusString6 = StatusString.ABORTED;
            if (!(statusString5 == null ? statusString6 != null : !statusString5.equals(statusString6))) break;
            statusString2 = describeResult.status();
            statusString = StatusString.FAILED;
        } while (statusString2 == null ? statusString != null : !statusString2.equals(statusString));
        StatusString statusString7 = describeResult.status();
        StatusString statusString8 = StatusString.ABORTED;
        if (!(statusString7 != null ? !statusString7.equals(statusString8) : statusString8 != null)) {
            throw new DataApiRuntimeException("DataAPI query was aborted");
        }
        StatusString statusString9 = describeResult.status();
        StatusString statusString10 = StatusString.FAILED;
        if (!(statusString9 != null ? !statusString9.equals(statusString10) : statusString10 != null)) {
            String error = (String)Option$.MODULE$.apply((Object)describeResult.error()).getOrElse((Function0 & Serializable)() -> "unknown error");
            throw new DataApiRuntimeException("DataAPI query execution failed: " + error);
        }
        this.log().info("The following Redshift Data API request id completed successfully: {}", (Object)this.requestId());
    }

    private boolean hasResults() {
        DescribeStatementRequest describeStatementRequest = (DescribeStatementRequest)DescribeStatementRequest.builder().id(this.requestId()).build();
        DescribeStatementResponse describeResults = this.client().describeStatement(describeStatementRequest);
        return Predef$.MODULE$.Boolean2boolean(describeResults.hasResultSet());
    }

    private DataApiResults getResults() {
        DescribeStatementRequest describeStatementRequest = (DescribeStatementRequest)DescribeStatementRequest.builder().id(this.requestId()).build();
        DescribeStatementResponse describeResults = this.client().describeStatement(describeStatementRequest);
        String resultId = (String)Option$.MODULE$.apply((Object)describeResults.subStatements()).map((Function1 & Serializable)x$4 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.nonEmpty())).map((Function1 & Serializable)x$6 -> ((SubStatementData)x$6.last()).id()).getOrElse((Function0 & Serializable)() -> this.requestId());
        GetStatementResultRequest statementResultRequest = (GetStatementResultRequest)GetStatementResultRequest.builder().id(resultId).build();
        GetStatementResultResponse results = this.client().getStatementResult(statementResultRequest);
        return new DataApiResults(results);
    }

    private long getResultRows() {
        DescribeStatementRequest describeStatementRequest = (DescribeStatementRequest)DescribeStatementRequest.builder().id(this.requestId()).build();
        DescribeStatementResponse describeResults = this.client().describeStatement(describeStatementRequest);
        if (describeResults.subStatements() == null || ((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(describeResults.subStatements()).asScala()).isEmpty()) {
            return Predef$.MODULE$.Long2long(describeResults.resultRows());
        }
        return Predef$.MODULE$.Long2long(((SubStatementData)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(describeResults.subStatements()).asScala()).last()).resultRows());
    }

    private boolean cancelRequest() {
        CancelStatementRequest cancelRequest = (CancelStatementRequest)CancelStatementRequest.builder().id(this.requestId()).build();
        CancelStatementResponse cancelResult = this.client().cancelStatement(cancelRequest);
        return Predef$.MODULE$.Boolean2boolean(cancelResult.status());
    }

    private <T> T executeWithRetry(Function0<T> operation, int maxRetries) {
        Tuple3<Object, Object, Object> tuple3 = this.getDataApiDelayParams();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double retryDelayMin = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double retryDelayMax = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double retryDelayMult = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)retryDelayMin), (Object)BoxesRunTime.boxToDouble((double)retryDelayMax), (Object)BoxesRunTime.boxToDouble((double)retryDelayMult));
        double retryDelayMin2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double retryDelayMax2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double retryDelayMult2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        int attempt = 0;
        double delay = retryDelayMin2;
        while (attempt <= maxRetries) {
            Throwable ex;
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply(operation);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                return (T)result;
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (this.isThrottlingException(ex2) && attempt < maxRetries) {
                    this.log().warn("Data API throttling detected (attempt " + ++attempt + "/" + maxRetries + "), retrying after " + delay + "ms: " + ex2.getMessage());
                    double jitteredDelay = delay + ThreadLocalRandom.current().nextDouble(0.0, delay * 0.1);
                    Thread.sleep((long)jitteredDelay);
                    delay = Math.min(delay * retryDelayMult2, retryDelayMax2);
                    continue;
                }
            }
            if (bl && this.isThrottlingException(ex = failure.exception())) {
                throw new RuntimeException("Data API operation failed after " + maxRetries + " retries due to throttling", ex);
            }
            if (bl) {
                Throwable ex3 = failure.exception();
                throw ex3;
            }
            throw new MatchError((Object)try_);
        }
        throw new RuntimeException("Data API operation failed after " + maxRetries + " retries");
    }

    private <T> int executeWithRetry$default$2() {
        return 5;
    }

    private boolean isThrottlingException(Throwable ex) {
        Throwable throwable = ex;
        if (throwable instanceof ValidationException) {
            ValidationException validationException = (ValidationException)throwable;
            return Option$.MODULE$.apply((Object)validationException.getMessage()).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.contains("Throttling")));
        }
        return false;
    }

    public DataApiCommand(DataAPIConnection connection, Option<Seq<QueryParameter<?>>> params) {
        this.connection = connection;
        this.params = params;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.client = null;
        this.requestId = "";
        this.DATA_API_RETRY_DELAY_MIN_KEY = "spark.datasource.redshift.community.data_api_retry_delay_min";
        this.DATA_API_RETRY_DELAY_MAX_KEY = "spark.datasource.redshift.community.data_api_retry_delay_max";
        this.DATA_API_RETRY_DELAY_MULT_KEY = "spark.datasource.redshift.community.data_api_retry_delay_mult";
        this.DATA_API_RETRY_DELAY_MIN_DEFAULT = "100.0";
        this.DATA_API_RETRY_DELAY_MAX_DEFAULT = "250.0";
        this.DATA_API_RETRY_DELAY_MULT_DEFAULT = "1.25";
    }
}

