/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.SetAccumulator;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.Utils$Write$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import java.io.Serializable;
import java.net.URI;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3Client;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g!\u0002\b\u0010\u0001=I\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011!\u0002!\u0011!Q\u0001\n%BQA\u0016\u0001\u0005\u0002]Cq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004g\u0001\u0001\u0006IA\u0018\u0005\u0007O\u0002!\ta\u00045\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!A\u0011q\u0006\u0001\u0005\u0002=\t\t\u0004C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAR\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003o\u0003A\u0011BA]\u00059\u0011V\rZ:iS\u001a$xK]5uKJT!\u0001E\t\u0002\u0011I,Gm\u001d5jMRT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011acF\u0001\u0007O&$\b.\u001e2\u000b\u0003a\t!![8\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\bsK\u0012\u001c\b.\u001b4u/J\f\u0007\u000f]3s\u0007\u0001\u0001\"a\t\u0014\u000e\u0003\u0011R!!J\b\u0002\t\u0011\fG/Y\u0005\u0003O\u0011\u0012qBU3eg\"Lg\r^,sCB\u0004XM]\u0001\u0010gN\u001aE.[3oi\u001a\u000b7\r^8ssB)1D\u000b\u0017;\u001d&\u00111\u0006\b\u0002\n\rVt7\r^5p]J\u0002\"!\f\u001d\u000e\u00039R!a\f\u0019\u0002\u0017\r\u0014X\rZ3oi&\fGn\u001d\u0006\u0003cI\nA!Y;uQ*\u00111\u0007N\u0001\u0007C^\u001c8\u000fZ6\u000b\u0005U2\u0014AB1nCj|gNC\u00018\u0003!\u0019xN\u001a;xCJ,\u0017BA\u001d/\u0005Y\tuo]\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\bCA\u001eL\u001d\ta\u0014J\u0004\u0002>\u0011:\u0011ah\u0012\b\u0003\u007f\u0019s!\u0001Q#\u000f\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u000b\u0013A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI!AS\b\u0002\u0015A\u000b'/Y7fi\u0016\u00148/\u0003\u0002M\u001b\n\u0001R*\u001a:hK\u0012\u0004\u0016M]1nKR,'o\u001d\u0006\u0003\u0015>\u0001\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u0005M\u001c$BA*3\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018BA+Q\u0005!\u00196g\u00117jK:$\u0018A\u0002\u001fj]&$h\bF\u0002Y5n\u0003\"!\u0017\u0001\u000e\u0003=AQ\u0001I\u0002A\u0002\tBQ\u0001K\u0002A\u0002%\n1\u0001\\8h+\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0017aA8sO&\u0011Q\r\u0019\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u000fGJ,\u0017\r^3UC\ndWmU9m)\u0011I\u0017/!\u0004\u0011\u0005)tgBA6m!\t\tE$\u0003\u0002n9\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\tiG\u0004C\u0003&\r\u0001\u0007!\u000fE\u0002t\u0003\u000fq1\u0001^A\u0001\u001d\t)XP\u0004\u0002ww:\u0011q/\u001f\b\u0003\u0003bL\u0011aY\u0005\u0003u\n\fa!\u00199bG\",\u0017B\u0001\n}\u0015\tQ(-\u0003\u0002\u007f\u007f\u0006\u00191/\u001d7\u000b\u0005Ia\u0018\u0002BA\u0002\u0003\u000b\tq\u0001]1dW\u0006<WM\u0003\u0002\u007f\u007f&!\u0011\u0011BA\u0006\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002\u0004\u0005\u0015\u0001BBA\b\r\u0001\u0007!(\u0001\u0004qCJ\fWn]\u0001\bG>\u0004\u0018pU9m)%I\u0017QCA\u0013\u0003O\tY\u0003C\u0004\u0002\u0018\u001d\u0001\r!!\u0007\u0002\rM\u001c\u0007.Z7b!\u0011\tY\"!\t\u000e\u0005\u0005u!\u0002BA\u0010\u0003\u000b\tQ\u0001^=qKNLA!a\t\u0002\u001e\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u0005=q\u00011\u0001;\u0011\u0019\tIc\u0002a\u0001Y\u0005)1M]3eg\"1\u0011QF\u0004A\u0002%\f1\"\\1oS\u001a,7\u000f^+sY\u0006q1m\\7nK:$\u0018i\u0019;j_:\u001cHCBA\u001a\u0003\u0007\ni\u0005E\u0003\u00026\u0005u\u0012N\u0004\u0003\u00028\u0005mbbA!\u0002:%\tQ$C\u0002\u0002\u0004qIA!a\u0010\u0002B\t!A*[:u\u0015\r\t\u0019\u0001\b\u0005\b\u0003\u000bB\u0001\u0019AA$\u00031!\u0018M\u00197f\u0007>lW.\u001a8u!\u0011Y\u0012\u0011J5\n\u0007\u0005-CD\u0001\u0004PaRLwN\u001c\u0005\b\u0003/A\u0001\u0019AA\r\u00039!wNU3eg\"Lg\r\u001e'pC\u0012$B\"a\u0015\u0002Z\u0005\r\u0014QMA4\u0003S\u00022aGA+\u0013\r\t9\u0006\b\u0002\u0005+:LG\u000fC\u0004\u0002\\%\u0001\r!!\u0018\u0002\t\r|gN\u001c\t\u0004G\u0005}\u0013bAA1I\t\u0011\"+\u001a3tQ&4GoQ8o]\u0016\u001cG/[8o\u0011\u0015)\u0013\u00021\u0001s\u0011\u0019\ty!\u0003a\u0001u!1\u0011\u0011F\u0005A\u00021Bq!!\f\n\u0001\u0004\t9%A\rgS:$WK\\:vaB|'\u000f^3e\u001b\u0006\u00048*Z=UsB,G\u0003BA8\u0003o\u0002RaGA%\u0003c\u0002B!a\u0007\u0002t%!\u0011QOA\u000f\u0005!!\u0015\r^1UsB,\u0007bBA=\u0015\u0001\u0007\u0011\u0011O\u0001\tI\u0006$\u0018\rV=qK\u0006QQO\u001c7pC\u0012$\u0015\r^1\u0015\u001d\u0005\u001d\u0013qPAF\u0003\u001b\u000b\t*!&\u0002\u001a\"9\u0011\u0011Q\u0006A\u0002\u0005\r\u0015AC:rY\u000e{g\u000e^3yiB!\u0011QQAD\u001b\t\t)!\u0003\u0003\u0002\n\u0006\u0015!AC*R\u0019\u000e{g\u000e^3yi\")Qe\u0003a\u0001e\"1\u0011qR\u0006A\u0002%\fq\u0001^3na\u0012K'\u000f\u0003\u0004\u0002\u0014.\u0001\r![\u0001\u000bi\u0016l\u0007OR8s[\u0006$\bBBAL\u0017\u0001\u0007\u0011.\u0001\u0006ok2d7\u000b\u001e:j]\u001eDq!a'\f\u0001\u0004\ti*A\u0004ue&l7i\u0015,\u0011\u0007m\ty*C\u0002\u0002\"r\u0011qAQ8pY\u0016\fg.\u0001\btCZ,Gk\u001c*fIND\u0017N\u001a;\u0015\u0015\u0005M\u0013qUAU\u0003W\u000b)\fC\u0004\u0002\u00022\u0001\r!a!\t\u000b\u0015b\u0001\u0019\u0001:\t\u000f\u00055F\u00021\u0001\u00020\u0006A1/\u0019<f\u001b>$W\r\u0005\u0003\u0002\u0006\u0006E\u0016\u0002BAZ\u0003\u000b\u0011\u0001bU1wK6{G-\u001a\u0005\u0007\u0003\u001fa\u0001\u0019\u0001\u001e\u0002%\rDWmY6Tg\t+8m[3u+N\fw-\u001a\u000b\u0007\u0003'\nY,!0\t\r\u0005=Q\u00021\u0001;\u0011\u0019\ty,\u0004a\u0001Y\u0005i1M]3egB\u0013xN^5eKJ\u0004")
public class RedshiftWriter {
    private final RedshiftWrapper redshiftWrapper;
    private final Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public String createTableSql(Dataset<Row> data, Parameters.MergedParameters params) {
        Object object;
        Object object2;
        String schemaSql = this.redshiftWrapper.schemaString(data.schema(), (Option<Parameters.MergedParameters>)new Some((Object)params));
        Option<String> option = params.distStyle();
        if (option instanceof Some) {
            Some some = (Some)option;
            String style = (String)some.value();
            object2 = "DISTSTYLE " + style;
        } else if (None$.MODULE$.equals(option)) {
            object2 = "";
        } else {
            throw new MatchError(option);
        }
        String distStyleDef = object2;
        Option<String> option2 = params.distKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String key = (String)some.value();
            object = "DISTKEY (" + key + ")";
        } else if (None$.MODULE$.equals(option2)) {
            object = "";
        } else {
            throw new MatchError(option2);
        }
        String distKeyDef = object;
        String sortKeyDef = (String)params.sortKeySpec().getOrElse((Function0 & Serializable)() -> "");
        TableName table = (TableName)params.table().get();
        return "CREATE TABLE IF NOT EXISTS " + table + " (" + schemaSql + ") " + distStyleDef + " " + distKeyDef + " " + sortKeyDef;
    }

    private String copySql(StructType schema, Parameters.MergedParameters params, AwsCredentialsProvider creds, String manifestUrl) {
        Object object;
        String fixedUrl;
        String credsString;
        block7: {
            credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(params, creds);
            fixedUrl = Utils$.MODULE$.fixS3Url(manifestUrl);
            String string = params.tempFormat();
            switch (string == null ? 0 : string.hashCode()) {
                case -75029036: {
                    if (!"PARQUET".equals(string)) break;
                    object = "PARQUET";
                    break block7;
                }
                case 2021682: {
                    if (!"AVRO".equals(string)) break;
                    object = "AVRO 'auto'";
                    break block7;
                }
            }
            String string2 = string;
            String string3 = "CSV";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String string4 = string;
                String string5 = "CSV GZIP";
                if (string4 != null ? !string4.equals(string5) : string5 != null) {
                    throw new MatchError((Object)string);
                }
            }
            object = string + " NULL AS '" + params.nullString() + "'";
        }
        String format = object;
        String columns = params.includeColumnList() ? "(" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Function1 & Serializable)name -> "\"" + name + "\"", ClassTag$.MODULE$.apply(String.class))).mkString(",") + ") " : "";
        String string = format;
        String string6 = "PARQUET";
        String regionClause = !(string != null ? !string.equals(string6) : string6 != null) ? "" : (String)params.tempDirRegion().map((Function1 & Serializable)region -> "REGION '" + region + "'").getOrElse((Function0 & Serializable)() -> "");
        String string7 = format;
        String string8 = "PARQUET";
        String serializeToJSON = !(string7 != null ? !string7.equals(string8) : string8 != null) ? "SERIALIZETOJSON" : "";
        String copySqlStatement = "COPY " + params.table().get() + " " + columns + "FROM '" + fixedUrl + "' FORMAT AS " + format + " " + serializeToJSON + " manifest " + regionClause + " " + params.extraCopyOptions();
        return copySqlStatement + " CREDENTIALS '" + credsString + "'";
    }

    public List<String> commentActions(Option<String> tableComment, StructType schema) {
        return (List)tableComment.toList().map((Function1 & Serializable)desc -> "COMMENT ON TABLE %s IS '" + desc.replace("'", "''") + "'").$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$commentActions$2(f))).map((Function1 & Serializable)f -> "COMMENT ON COLUMN %s.\"" + f.name().replace("\"", "\\\"") + "\" IS '" + f.metadata().getString("description").replace("'", "''") + "'", ClassTag$.MODULE$.apply(String.class))));
    }

    private void doRedshiftLoad(RedshiftConnection conn, Dataset<Row> data, Parameters.MergedParameters params, AwsCredentialsProvider creds, Option<String> manifestUrl2) {
        String createStatement = this.createTableSql(data, params);
        this.log().info("Creating table within Redshift: {}", params.table().get());
        this.redshiftWrapper.executeInterruptibly(conn, createStatement);
        List preActions = (List)this.commentActions(params.description(), data.schema()).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])params.preActions()));
        preActions.foreach((Function1 & Serializable)action -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$1(this, params, conn, action)));
        manifestUrl2.foreach((Function1 & Serializable)manifestUrl -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$2(this, data, params, creds, conn, manifestUrl)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])params.postActions()), (Function1 & Serializable)action -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$8(this, params, conn, action)));
    }

    private Option<DataType> findUnsupportedMapKeyType(DataType dataType) {
        MapType mapType;
        boolean bl;
        while (true) {
            bl = false;
            mapType = null;
            DataType dataType2 = dataType;
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)field -> this.findUnsupportedMapKeyType(field.dataType()), ClassTag$.MODULE$.apply(Option.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                dataType = arrayType.elementType();
                continue;
            }
            if (!(dataType2 instanceof MapType)) break;
            bl = true;
            mapType = (MapType)dataType2;
            DataType dataType3 = mapType.keyType();
            DataType other = mapType.valueType();
            if (!StringType$.MODULE$.equals(dataType3)) break;
            dataType = other;
        }
        if (bl) {
            DataType keyType = mapType.keyType();
            return new Some((Object)keyType);
        }
        return None$.MODULE$;
    }

    private Option<String> unloadData(SQLContext sqlContext, Dataset<Row> data, String tempDir, String tempFormat, String nullString, boolean trimCSV) {
        DataFrameWriter dataFrameWriter;
        SetAccumulator nonEmptyPartitions;
        block13: {
            Function1[] conversionFunctions = (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()), (Function1 & Serializable)field -> {
                boolean bl = false;
                DataType dataType = null;
                DataType dataType2 = field.dataType();
                if (dataType2 instanceof DecimalType) {
                    String string = tempFormat;
                    String string2 = "PARQUET";
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        return (Function1 & Serializable)v -> {
                            if (v == null) {
                                return null;
                            }
                            return v.toString();
                        };
                    }
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    String string = tempFormat;
                    String string3 = "PARQUET";
                    if (string == null ? string3 != null : !string.equals(string3)) {
                        SimpleDateFormat dateFormat = Conversions$.MODULE$.createRedshiftDateFormat();
                        return (Function1 & Serializable)v -> {
                            if (v == null) {
                                return null;
                            }
                            return dateFormat.format((Date)v);
                        };
                    }
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    bl = true;
                    dataType = dataType2;
                    String string = tempFormat;
                    String string4 = "PARQUET";
                    if (string == null ? string4 != null : !string.equals(string4)) {
                        return (Function1 & Serializable)v -> {
                            if (v == null) {
                                return null;
                            }
                            return Conversions$.MODULE$.createRedshiftTimestampFormat().format(((Timestamp)v).toLocalDateTime());
                        };
                    }
                }
                if (bl) {
                    return (Function1 & Serializable)v -> {
                        if (v == null) {
                            return null;
                        }
                        return DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp((Timestamp)v), ZoneId.systemDefault().getId()));
                    };
                }
                return (Function1 & Serializable)v -> v;
            }, ClassTag$.MODULE$.apply(Function1.class));
            nonEmptyPartitions = new SetAccumulator();
            sqlContext.sparkContext().register(nonEmptyPartitions);
            StructField[] complexFields = (StructField[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$unloadData$7(x$4)));
            String string = tempFormat;
            String string2 = "AVRO";
            if (!(string != null ? !string.equals(string2) : string2 != null) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])complexFields))) {
                throw new IllegalArgumentException("Cannot write complex type fields " + Predef$.MODULE$.wrapRefArray((Object[])complexFields).mkString(", ") + " with tempformat AVRO; use CSV or CSV GZIP instead.");
            }
            this.findUnsupportedMapKeyType((DataType)data.schema()).foreach((Function1 & Serializable)dt -> {
                throw new IllegalArgumentException("Cannot write map with key type " + dt + "; Only maps with StringType keys are supported.");
            });
            Map mapping = tempFormat.startsWith("CSV") ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])complexFields), (Function1 & Serializable)field -> new Tuple2((Object)field.name(), (Object)functions$.MODULE$.to_json(functions$.MODULE$.col(field.name()))), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            Dataset complexTypesReplaced = data.withColumns(mapping);
            RDD qual$1 = complexTypesReplaced.rdd();
            Function1 & Serializable x$1 = (Function1 & Serializable)iter -> {
                block0: {
                    if (!iter.hasNext()) break block0;
                    nonEmptyPartitions.add(BoxesRunTime.boxToInteger((int)TaskContext$.MODULE$.get().partitionId()));
                }
                return iter.map((Function1 & Serializable)row -> {
                    Object[] convertedValues = new Object[conversionFunctions.length];
                    for (int i = 0; i < conversionFunctions.length; ++i) {
                        convertedValues[i] = conversionFunctions[i].apply(row.apply(i));
                    }
                    return Row$.MODULE$.fromSeq((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.genericArrayOps((Object)convertedValues)));
                });
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            RDD convertedRows = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
            StructType schemaWithLowercaseColumnNames = StructType$.MODULE$.apply((Seq)complexTypesReplaced.schema().map((Function1 & Serializable)f -> f.copy(f.name().toLowerCase(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4())));
            if (((IterableOnceOps)schemaWithLowercaseColumnNames.map((Function1 & Serializable)x$5 -> x$5.name())).toSet().size() != complexTypesReplaced.schema().size()) {
                throw new IllegalArgumentException("Cannot save table to Redshift because two or more column names would be identical after conversion to lowercase: " + ((IterableOnceOps)complexTypesReplaced.schema().map((Function1 & Serializable)x$6 -> x$6.name())).mkString(", "));
            }
            StructType convertedSchema = StructType$.MODULE$.apply((Seq)schemaWithLowercaseColumnNames.map((Function1 & Serializable)x0$1 -> {
                StructField structField = x0$1;
                String string = tempFormat;
                String string2 = "PARQUET";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return structField;
                }
                if (structField != null) {
                    String name = structField.name();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    if (structField.dataType() instanceof DecimalType) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    if (DateType$.MODULE$.equals(dataType)) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                return structField;
            }));
            this.log().info("Unloading data to S3");
            DataFrameWriter writer = sqlContext.createDataFrame(convertedRows, convertedSchema).write();
            String string3 = tempFormat;
            switch (string3 == null ? 0 : string3.hashCode()) {
                case -348566700: {
                    if (!"CSV GZIP".equals(string3)) break;
                    dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("ignoreLeadingWhiteSpace", trimCSV).option("ignoreTrailingWhiteSpace", trimCSV).option("compression", "gzip");
                    break block13;
                }
                case -75029036: {
                    if (!"PARQUET".equals(string3)) break;
                    dataFrameWriter = writer.format("parquet");
                    break block13;
                }
                case 67046: {
                    if (!"CSV".equals(string3)) break;
                    dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("ignoreLeadingWhiteSpace", trimCSV).option("ignoreTrailingWhiteSpace", trimCSV);
                    break block13;
                }
                case 2021682: {
                    if (!"AVRO".equals(string3)) break;
                    dataFrameWriter = writer.format("avro");
                    break block13;
                }
            }
            throw new MatchError((Object)string3);
        }
        dataFrameWriter.save(tempDir);
        if (nonEmptyPartitions.value().isEmpty()) {
            return None$.MODULE$;
        }
        FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
        Regex partitionIdRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^part-(?:r-)?(\\d+)[^\\d+].*$"));
        Set nonEmptyPartitionIds = nonEmptyPartitions.value().toSet();
        Seq filesToLoad = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir))), (Function1 & Serializable)status -> new Tuple2((Object)status.getPath().getName(), (Object)BoxesRunTime.boxToLong((long)status.getLen())), ClassTag$.MODULE$.apply(Tuple2.class)))).collect((PartialFunction)new Serializable(null, partitionIdRegex, nonEmptyPartitionIds){
            private static final long serialVersionUID = 0L;
            private final Regex partitionIdRegex$1;
            private final Set nonEmptyPartitionIds$1;

            public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String id;
                Option option;
                String string;
                A1 A1 = x1;
                if (A1 != null && (string = (String)A1._1()) != null && !(option = this.partitionIdRegex$1.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOps)option.get()).apply(0)))))) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                String id;
                Option option;
                String string;
                Tuple2<String, Object> tuple2 = x1;
                return tuple2 != null && (string = (String)tuple2._1()) != null && !(option = this.partitionIdRegex$1.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOps)option.get()).apply(0)))));
            }
            {
                this.partitionIdRegex$1 = partitionIdRegex$1;
                this.nonEmptyPartitionIds$1 = nonEmptyPartitionIds$1;
            }
        });
        String sameFileSystemDir = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString()), "/");
        String sanitizedTempDir = Utils$.MODULE$.fixS3Url(sameFileSystemDir);
        Seq manifestEntries = (Seq)filesToLoad.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String file = (String)tuple2._1();
                long length = tuple2._2$mcJ$sp();
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\"url\":\"" + sanitizedTempDir + "/" + file + "\",\n           | \"mandatory\":true,\n           | \"meta\": {\"content_length\":" + length + "}}"));
            }
            throw new MatchError((Object)tuple2);
        });
        String manifest = "{\"entries\": [" + manifestEntries.mkString(",\n") + "]}";
        String manifestPath = sameFileSystemDir + "/manifest.json";
        try (FSDataOutputStream fsDataOut = fs.create(new Path(manifestPath));){
            fsDataOut.write(manifest.getBytes("utf-8"));
        }
        return new Some((Object)manifestPath);
    }

    public void saveToRedshift(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
        }
        if (!params.useStagingTable()) {
            this.log().warn("Setting useStagingTable=false is deprecated; instead, we recommend that you drop the target table yourself. For more details on this deprecation, seehttps://github.com/databricks/spark-redshift/pull/157");
        }
        AwsCredentialsProvider credsProvider = AWSCredentialsUtils$.MODULE$.load(params, sqlContext.sparkContext().hadoopConfiguration());
        this.checkS3BucketUsage(params, credsProvider);
        String string = params.tempFormat();
        String string2 = "AVRO";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames()), (Function1 & Serializable)fieldName -> {
                RedshiftWriter.$anonfun$saveToRedshift$1(fieldName);
                return BoxedUnit.UNIT;
            });
        }
        if (params.checkS3BucketUsage()) {
            Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        }
        Utils$.MODULE$.collectMetrics(params, Utils$.MODULE$.collectMetrics$default$2());
        Option<String> manifestUrl = this.unloadData(sqlContext, data, params.createPerQueryTempDir(), params.tempFormat(), params.nullString(), params.legacyTrimCSVWrites());
        if (StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)params.parameters().apply((Object)Parameters$.MODULE$.PARAM_COPY_DELAY()))) > 0L) {
            this.log().info("Sleeping {} milliseconds before proceeding to redshift copy", (Object)BoxesRunTime.boxToLong((long)params.copyDelay()));
            Thread.sleep(params.copyDelay());
        }
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Write$.MODULE$, params, sqlContext);
        Utils$.MODULE$.retry(params.copyRetryCount(), params.copyDelay(), (JFunction0.mcV.sp & Serializable)() -> {
            $this.redshiftWrapper.setAutoCommit(conn, false);
            try (RedshiftConnection conn = $this.redshiftWrapper.getConnectorWithQueryGroup(params, queryGroup);){
                try {
                    TableName table = (TableName)params.table().get();
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(table.unescapedDatabaseName()))) {
                        String useDbStr = "use " + table.escapedDatabaseName();
                        v0 = BoxesRunTime.boxToBoolean((boolean)$this.redshiftWrapper.executeInterruptibly(conn, useDbStr));
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    SaveMode saveMode = saveMode;
                    SaveMode saveMode2 = SaveMode.Overwrite;
                    if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null)) {
                        this.log().info("Dropping table within Redshift: {}", (Object)table);
                        $this.redshiftWrapper.executeInterruptibly(conn, "DROP TABLE IF EXISTS " + table + ";");
                        if (!params.useStagingTable()) {
                            $this.redshiftWrapper.commit(conn);
                            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(table.unescapedDatabaseName()))) {
                                String useDbStr = "use " + table.escapedDatabaseName();
                                v2 = BoxesRunTime.boxToBoolean((boolean)$this.redshiftWrapper.executeInterruptibly(conn, useDbStr));
                            } else {
                                v2 = BoxedUnit.UNIT;
                            }
                        } else {
                            v2 = BoxedUnit.UNIT;
                        }
                    } else {
                        v2 = BoxedUnit.UNIT;
                    }
                    this.log().info("Loading new Redshift data to: {}", (Object)table);
                    this.doRedshiftLoad(conn, data, params, credsProvider, manifestUrl);
                    $this.redshiftWrapper.commit(conn);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        block18: {
                            try {
                                this.log().error("Exception thrown during Redshift load; will roll back transaction: {}", (Object)throwable2.getMessage());
                                $this.redshiftWrapper.rollback(conn);
                            }
                            catch (Throwable throwable4) {
                                Throwable throwable5;
                                Throwable throwable6 = throwable4;
                                if (throwable6 != null && NonFatal$.MODULE$.apply(throwable5 = throwable6)) {
                                    this.log().error("Exception while rolling back transaction: {}", (Object)throwable5.getMessage());
                                    break block18;
                                }
                                throw throwable4;
                            }
                        }
                        throw throwable2;
                    }
                    throw throwable;
                }
            }
        });
    }

    private void checkS3BucketUsage(Parameters.MergedParameters params, AwsCredentialsProvider credsProvider) {
        if (!params.checkS3BucketUsage()) {
            return;
        }
        S3Client s3Client = (S3Client)this.s3ClientFactory.apply((Object)credsProvider, (Object)params);
        String string = params.tempFormat();
        String string2 = "PARQUET";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Utils$.MODULE$.checkRedshiftAndS3OnSameRegionParquetWrite(params, s3Client);
        } else {
            Utils$.MODULE$.checkRedshiftAndS3OnSameRegion(params, s3Client);
        }
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params, s3Client);
    }

    public static final /* synthetic */ boolean $anonfun$commentActions$2(StructField f) {
        return f.metadata().contains("description");
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$1(RedshiftWriter $this, Parameters.MergedParameters params$1, RedshiftConnection conn$1, String action) {
        String actionSql = action.contains("%s") ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(action), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params$1.table().get()})) : action;
        return $this.redshiftWrapper.executeInterruptibly(conn$1, actionSql);
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$2(RedshiftWriter $this, Dataset data$1, Parameters.MergedParameters params$1, AwsCredentialsProvider creds$1, RedshiftConnection conn$1, String manifestUrl) {
        boolean bl;
        String copyStatement = $this.copySql(data$1.schema(), params$1, creds$1, manifestUrl);
        try {
            bl = $this.redshiftWrapper.executeInterruptibly(conn$1, copyStatement);
        }
        catch (SQLException e) {
            None$ none$;
            block7: {
                $this.log().error("SQLException thrown while running COPY query; will attempt to retrieve more information by querying the STL_LOAD_ERRORS table: {}", (Object)e.getMessage());
                $this.redshiftWrapper.rollback(conn$1);
                String errorLookupQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              | SELECT *\n              | FROM stl_load_errors\n              | WHERE query = pg_last_query_id()\n            "));
                try {
                    RedshiftResults results = $this.redshiftWrapper.executeQueryInterruptibly(conn$1, errorLookupQuery);
                    if (results.next()) {
                        int errCode = results.getInt("err_code");
                        String errReason = results.getString("err_reason").trim();
                        String columnLength = (String)Option$.MODULE$.apply((Object)results.getString("col_length")).map((Function1 & Serializable)x$1 -> x$1.trim()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1 & Serializable)n -> "(" + n + ")").getOrElse((Function0 & Serializable)() -> "");
                        String exceptionMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |Error (code " + errCode + ") while loading data into Redshift: \"" + errReason + "\"\n                   |Table name: " + params$1.table().get() + "\n                   |Column name: " + results.getString("colname").trim() + "\n                   |Column type: " + results.getString("type").trim() + columnLength + "\n                   |Raw line: " + results.getString("raw_line") + "\n                   |Raw field value: " + results.getString("raw_field_value") + "\n                  "));
                        none$ = new Some((Object)new SQLException(exceptionMessage, e));
                    } else {
                        none$ = None$.MODULE$;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        $this.log().error("Error occurred while querying STL_LOAD_ERRORS: {}", (Object)throwable2.getMessage());
                        none$ = None$.MODULE$;
                        break block7;
                    }
                    throw throwable;
                }
            }
            None$ detailedException = none$;
            throw (Throwable)detailedException.getOrElse((Function0 & Serializable)() -> e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$8(RedshiftWriter $this, Parameters.MergedParameters params$1, RedshiftConnection conn$1, String action) {
        String actionSql = action.contains("%s") ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(action), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{params$1.table().get()})) : action;
        return $this.redshiftWrapper.executeInterruptibly(conn$1, actionSql);
    }

    public static final /* synthetic */ boolean $anonfun$unloadData$7(StructField x$4) {
        DataType dataType = x$4.dataType();
        return dataType instanceof MapType ? true : (dataType instanceof StructType ? true : dataType instanceof ArrayType);
    }

    public static final /* synthetic */ boolean $anonfun$saveToRedshift$2(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_';
    }

    public static final /* synthetic */ void $anonfun$saveToRedshift$1(String fieldName) {
        boolean isValid;
        char firstChar = fieldName.charAt(0);
        boolean bl = isValid = (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(firstChar)) || firstChar == '_') && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(fieldName))), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$saveToRedshift$2(BoxesRunTime.unboxToChar((Object)c))));
        if (!isValid) {
            throw new IllegalArgumentException("The field name '" + fieldName + "' is not supported when using the Avro tempformat. Try using the CSV tempformat  instead. For more details, see https://github.com/databricks/spark-redshift/issues/84");
        }
    }

    public RedshiftWriter(RedshiftWrapper redshiftWrapper, Function2<AwsCredentialsProvider, Parameters.MergedParameters, S3Client> s3ClientFactory) {
        this.redshiftWrapper = redshiftWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

