/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.package$;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;

public final class FilterPushdown$ {
    public static final FilterPushdown$ MODULE$ = new FilterPushdown$();

    public String buildWhereClause(StructType schema, Seq<Filter> filters, boolean escapeQuote) {
        String filterExpressions = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)f -> MODULE$.buildFilterExpression(schema, (Filter)f, escapeQuote))).mkString(" AND ");
        if (filterExpressions.isEmpty()) {
            return "";
        }
        return "WHERE " + filterExpressions;
    }

    public boolean buildWhereClause$default$3() {
        return false;
    }

    public Option<String> buildFilterExpression(StructType schema, Filter filter, boolean escapeQuote) {
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            if (!this.attributeIsComplexDatatype(schema, attr)) {
                return this.buildComparison$1(attr, value, "=", escapeQuote, schema);
            }
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            if (!this.attributeIsComplexDatatype(schema, attr)) {
                return this.buildComparison$1(attr, value, "<", escapeQuote, schema);
            }
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            if (!this.attributeIsComplexDatatype(schema, attr)) {
                return this.buildComparison$1(attr, value, ">", escapeQuote, schema);
            }
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (!this.attributeIsComplexDatatype(schema, attr)) {
                return this.buildComparison$1(attr, value, "<=", escapeQuote, schema);
            }
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (!this.attributeIsComplexDatatype(schema, attr)) {
                return this.buildComparison$1(attr, value, ">=", escapeQuote, schema);
            }
        }
        if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            return this.getTypeForAttribute(schema, attr).map((Function1 & Serializable)dataType -> "\"" + attr + "\" IS NOT NULL");
        }
        if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            return this.getTypeForAttribute(schema, attr).map((Function1 & Serializable)dataType -> "\"" + attr + "\" IS NULL");
        }
        return None$.MODULE$;
    }

    public boolean buildFilterExpression$default$3() {
        return true;
    }

    private Option<DataType> getTypeForAttribute(StructType schema, String attribute) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)attribute)) {
            return new Some((Object)schema.apply(attribute).dataType());
        }
        return None$.MODULE$;
    }

    private boolean attributeIsComplexDatatype(StructType schema, String attribute) {
        Some some;
        Some some2;
        Some some3;
        Option<DataType> option = this.getTypeForAttribute(schema, attribute);
        return option instanceof Some && (some3 = (Some)option).value() instanceof StructType ? true : (option instanceof Some && (some2 = (Some)option).value() instanceof MapType ? true : option instanceof Some && (some = (Some)option).value() instanceof ArrayType);
    }

    private final Option buildComparison$1(String attr, Object value, String comparisonOp, boolean escapeQuote, StructType schema$2) {
        return this.getTypeForAttribute(schema$2, attr).map((Function1 & Serializable)dataType -> {
            Option<Object> option;
            DataType dataType2 = dataType;
            Object object = StringType$.MODULE$.equals(dataType2) ? (escapeQuote ? "''" + value.toString().replace("'", "\\'\\'") + "''" : "'" + value.toString().replace("'", "\\'\\'") + "'") : (DateType$.MODULE$.equals(dataType2) ? (escapeQuote ? "''" + (Date)value + "''" : "'" + (Date)value + "'") : (TimestampType$.MODULE$.equals(dataType2) ? (escapeQuote ? "''" + (Timestamp)value + "''" : "'" + (Timestamp)value + "'") : (dataType2 != null && !(option = TimestampNTZTypeExtractor$.MODULE$.unapply(dataType2)).isEmpty() && !package$.MODULE$.legacyTimestampHandling() ? (escapeQuote ? "''" + (LocalDateTime)value + "''" : "'" + (LocalDateTime)value + "'") : (value instanceof Float ? value + "::float4" : value.toString()))));
            String sqlEscapedValue = object;
            return "\"" + attr + "\" " + comparisonOp + " " + sqlEscapedValue;
        });
    }

    private FilterPushdown$() {
    }
}

