/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.RedshiftConstraintViolationException;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import scala.Function0;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public final class AWSCredentialsUtils$ {
    public static final AWSCredentialsUtils$ MODULE$ = new AWSCredentialsUtils$();

    public String getRedshiftCredentialsString(Parameters.MergedParameters params, AwsCredentialsProvider credentialsProvider) {
        if (Utils$.MODULE$.isRedshiftS3ConnectionViaIAMRoleOnly() && (params.temporaryAWSCredentials().isDefined() || params.forwardSparkS3Credentials())) {
            throw new RedshiftConstraintViolationException("Only the aws_iam_role option for configuring credentials is supported when configuration " + Utils$.MODULE$.CONNECTOR_REDSHIFT_S3_CONNECTION_IAM_ROLE_ONLY() + " is set to true.");
        }
        if (params.iamRole().isDefined()) {
            return "aws_iam_role=" + params.iamRole().get();
        }
        if (params.temporaryAWSCredentials().isDefined()) {
            return AWSCredentialsUtils$.awsCredsToString$1(((AwsCredentialsProvider)params.temporaryAWSCredentials().get()).resolveCredentials());
        }
        if (params.forwardSparkS3Credentials()) {
            return AWSCredentialsUtils$.awsCredsToString$1(credentialsProvider.resolveCredentials());
        }
        throw new IllegalStateException("No Redshift S3 authentication mechanism was specified");
    }

    public AwsCredentialsProvider staticCredentialsProvider(AwsCredentials credentials) {
        return StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    public AwsCredentialsProvider load(Parameters.MergedParameters params, Configuration hadoopConfiguration) {
        return (AwsCredentialsProvider)params.temporaryAWSCredentials().getOrElse((Function0 & Serializable)() -> MODULE$.loadFromURI(params.rootTempDir(), hadoopConfiguration));
    }

    private AwsCredentialsProvider loadFromURI(String tempPath, Configuration hadoopConfiguration) {
        String string;
        block8: {
            URI uri = new URI(tempPath);
            String uriScheme = uri.getScheme();
            string = uriScheme;
            switch (string == null ? 0 : string.hashCode()) {
                case 3616: {
                    if ("s3".equals(string)) {
                        break;
                    }
                    break block8;
                }
                case 112193: {
                    if ("s3a".equals(string)) {
                        break;
                    }
                    break block8;
                }
                case 112206: {
                    if ("s3n".equals(string)) {
                        break;
                    }
                    break block8;
                }
                default: {
                    break block8;
                }
            }
            return DefaultCredentialsProvider.builder().build();
        }
        throw new IllegalArgumentException("Unrecognized scheme " + string + "; expected s3, s3n, or s3a");
    }

    private static final String awsCredsToString$1(AwsCredentials credentials) {
        AwsCredentials awsCredentials = credentials;
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials awsSessionCredentials = (AwsSessionCredentials)awsCredentials;
            return "aws_access_key_id=" + awsSessionCredentials.accessKeyId() + ";aws_secret_access_key=" + awsSessionCredentials.secretAccessKey() + ";token=" + awsSessionCredentials.sessionToken();
        }
        return "aws_access_key_id=" + awsCredentials.accessKeyId() + ";aws_secret_access_key=" + awsCredentials.secretAccessKey();
    }

    private AWSCredentialsUtils$() {
    }
}

