/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.FilterPushdown$;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftFileFormat;
import io.github.spark_redshift_community.spark.redshift.RedshiftRelation$;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter;
import io.github.spark_redshift_community.spark.redshift.RowEncoderUtils$;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.TimestampNTZTypeExtractor$;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import io.github.spark_redshift_community.spark.redshift.Utils$Read$;
import io.github.spark_redshift_community.spark.redshift.Utils$Write$;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftConnection;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftResults;
import io.github.spark_redshift_community.spark.redshift.data.RedshiftWrapper;
import io.github.spark_redshift_community.spark.redshift.package$;
import io.github.spark_redshift_community.spark.redshift.pushdown.RedshiftSQLStatement;
import io.github.spark_redshift_community.spark.redshift.pushdown.SqlToS3TempCache$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\reh\u0001\u0002\u001d:\u0001\u0012C\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005S\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000fC\u0005\u00028\u0001\u0011\t\u0012)A\u0005e\"Q\u0011\u0011\b\u0001\u0003\u0016\u0004%\t!a\u000f\t\u0013\u0005u\u0002A!E!\u0002\u0013y\bBCA \u0001\tU\r\u0011\"\u0001\u0002B!Q\u0011Q\u000b\u0001\u0003\u0012\u0003\u0006I!a\u0011\t\u0015\u0005]\u0003A!b\u0001\n\u0003\tI\u0006\u0003\u0006\u0002d\u0001\u0011\t\u0011)A\u0005\u00037Bq!!\u001c\u0001\t\u0003\ty\u0007C\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0003\u0002\u0004\"A\u0011Q\u0013\u0001!\u0002\u0013\t)\t\u0003\u0006\u0002\u0018\u0002A)\u0019!C!\u00033Cq!a'\u0001\t\u0003\ni\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\u0005\u0001\t\u0013\u00119\u0003C\u0004\u0003F\u0001!IAa\u0012\t\u000f\t=\u0003\u0001\"\u0001\u0003R!I!\u0011\u000f\u0001\u0012\u0002\u0013\u0005!1\u000f\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005KCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u0003D\u0002!IA!2\t\u000f\t-\u0007\u0001\"\u0003\u0003N\"9!Q\u001c\u0001\u0005\n\t}\u0007b\u0002Bz\u0001\u0011%!Q\u001f\u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007/Aqa!\f\u0001\t\u0013\u0019y\u0003C\u0004\u0004>\u0001!Iaa\u0010\t\u0013\r\u001d\u0003!!A\u0005\u0002\r%\u0003\"CB,\u0001E\u0005I\u0011AB-\u0011%\u0019i\u0006AI\u0001\n\u0003\u0019y\u0006C\u0005\u0004d\u0001\t\n\u0011\"\u0001\u0004f!I1\u0011\u000e\u0001\u0012\u0002\u0013\u000511\u000e\u0005\n\u0007_\u0002\u0011\u0011!C!\u0007cB\u0011b! \u0001\u0003\u0003%\taa \t\u0013\r\u001d\u0005!!A\u0005\u0002\r%\u0005\"CBH\u0001\u0005\u0005I\u0011IBI\u0011%\u0019y\nAA\u0001\n\u0003\u0019\t\u000bC\u0005\u0004&\u0002\t\t\u0011\"\u0011\u0004(\"I1\u0011\u0016\u0001\u0002\u0002\u0013\u000531V\u0004\t\u0007_K\u0004\u0012A\u001d\u00042\u001a9\u0001(\u000fE\u0001s\rM\u0006bBA7e\u0011\u000511\u0018\u0005\b\u0007{\u0013D\u0011AB`\u0011%\u0019yMMA\u0001\n\u0003\u001b\t\u000eC\u0005\u0004`J\n\t\u0011\"!\u0004b\"I1q\u001e\u001a\u0002\u0002\u0013%1\u0011\u001f\u0002\u0011%\u0016$7\u000f[5giJ+G.\u0019;j_:T!AO\u001e\u0002\u0011I,Gm\u001d5jMRT!\u0001P\u001f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yz\u0014\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011\u0001)Q\u0001\u0007O&$\b.\u001e2\u000b\u0003\t\u000b!![8\u0004\u0001M9\u0001!\u0012*V1z#\u0007C\u0001$Q\u001b\u00059%B\u0001%J\u0003\u001d\u0019x.\u001e:dKNT!AS&\u0002\u0007M\fHN\u0003\u0002=\u0019*\u0011QJT\u0001\u0007CB\f7\r[3\u000b\u0003=\u000b1a\u001c:h\u0013\t\tvI\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002G'&\u0011Ak\u0012\u0002\u0013!J,h.\u001a3GS2$XM]3e'\u000e\fg\u000e\u0005\u0002G-&\u0011qk\u0012\u0002\u0013\u0013:\u001cXM\u001d;bE2,'+\u001a7bi&|g\u000e\u0005\u0002Z96\t!L\u0003\u0002\\\u0017\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002^5\n9Aj\\4hS:<\u0007CA0c\u001b\u0005\u0001'\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004'a\u0002)s_\u0012,8\r\u001e\t\u0003?\u0016L!A\u001a1\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u001fI,Gm\u001d5jMR<&/\u00199qKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Yf\nA\u0001Z1uC&\u0011an\u001b\u0002\u0010%\u0016$7\u000f[5gi^\u0013\u0018\r\u001d9fe\u0006\u0001\"/\u001a3tQ&4Go\u0016:baB,'\u000fI\u0001\u0010gN\u001aE.[3oi\u001a\u000b7\r^8ssV\t!\u000f\u0005\u0004`gV|\u0018qE\u0005\u0003i\u0002\u0014\u0011BR;oGRLwN\u001c\u001a\u0011\u0005YlX\"A<\u000b\u0005aL\u0018\u0001B1vi\"T!A_>\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001?\u0002\u0007\r|W.\u0003\u0002\u007fo\n1\u0012iV*De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0005\u0003\u0002\u0002\u0005\u0005b\u0002BA\u0002\u0003;qA!!\u0002\u0002\u001c9!\u0011qAA\r\u001d\u0011\tI!a\u0006\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\"\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015B\u0001!B\u0013\tqt(\u0003\u0002={%\u0011!hO\u0005\u0004\u0003?I\u0014A\u0003)be\u0006lW\r^3sg&!\u00111EA\u0013\u0005AiUM]4fIB\u000b'/Y7fi\u0016\u00148OC\u0002\u0002 e\u0002B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0002tg)\u0019\u0011\u0011G=\u0002\u0011M,'O^5dKNLA!!\u000e\u0002,\tA\u0011)\\1{_:\u001c6'\u0001\ttg\rc\u0017.\u001a8u\r\u0006\u001cGo\u001c:zA\u00051\u0001/\u0019:b[N,\u0012a`\u0001\ba\u0006\u0014\u0018-\\:!\u0003))8/\u001a:TG\",W.Y\u000b\u0003\u0003\u0007\u0002RaXA#\u0003\u0013J1!a\u0012a\u0005\u0019y\u0005\u000f^5p]B!\u00111JA)\u001b\t\tiEC\u0002\u0002P%\u000bQ\u0001^=qKNLA!a\u0015\u0002N\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0017U\u001cXM]*dQ\u0016l\u0017\rI\u0001\u000bgFd7i\u001c8uKb$XCAA.!\u0011\ti&a\u0018\u000e\u0003%K1!!\u0019J\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\fgFd7i\u001c8uKb$\b\u0005K\u0002\u000b\u0003O\u00022aXA5\u0013\r\tY\u0007\u0019\u0002\niJ\fgn]5f]R\fa\u0001P5oSRtDCCA9\u0003s\nY(! \u0002\u0000Q!\u00111OA<!\r\t)\bA\u0007\u0002s!9\u0011qK\u0006A\u0002\u0005m\u0003\"B4\f\u0001\u0004I\u0007\"\u00029\f\u0001\u0004\u0011\bBBA\u001d\u0017\u0001\u0007q\u0010C\u0004\u0002@-\u0001\r!a\u0011\u0002'Q\f'\r\\3OC6,wJ]*vEF,XM]=\u0016\u0005\u0005\u0015\u0005\u0003BAD\u0003\u001fsA!!#\u0002\fB\u0019\u0011Q\u00021\n\u0007\u00055\u0005-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\u000b\u0019J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b\u0003\u0017\u0001\u0006;bE2,g*Y7f\u001fJ\u001cVOY9vKJL\b%\u0001\u0004tG\",W.Y\u000b\u0003\u0003\u0013\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\u000ba!\u001b8tKJ$HCBAR\u0003S\u000bI\rE\u0002`\u0003KK1!a*a\u0005\u0011)f.\u001b;\t\r1\u0004\u0002\u0019AAV!\u0011\ti+a1\u000f\t\u0005=\u0016q\u0018\b\u0005\u0003c\u000biL\u0004\u0003\u00024\u0006mf\u0002BA[\u0003ssA!!\u0004\u00028&\tq*\u0003\u0002N\u001d&\u0011A\bT\u0005\u0003\u0015.K1!!1J\u0003\u001d\u0001\u0018mY6bO\u0016LA!!2\u0002H\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u0003L\u0005bBAf!\u0001\u0007\u0011QZ\u0001\n_Z,'o\u001e:ji\u0016\u00042aXAh\u0013\r\t\t\u000e\u0019\u0002\b\u0005>|G.Z1o\u0003A)h\u000e[1oI2,GMR5mi\u0016\u00148\u000f\u0006\u0003\u0002X\u0006\r\b#B0\u0002Z\u0006u\u0017bAAnA\n)\u0011I\u001d:bsB\u0019a)a8\n\u0007\u0005\u0005xI\u0001\u0004GS2$XM\u001d\u0005\b\u0003K\f\u0002\u0019AAl\u0003\u001d1\u0017\u000e\u001c;feN\f!c\u00195fG.\u001c6GQ;dW\u0016$Xk]1hKR1\u00111UAv\u0003[Da!!\u000f\u0013\u0001\u0004y\bBBAx%\u0001\u0007Q/A\u0007de\u0016$7\u000f\u0015:pm&$WM]\u0001\nEVLG\u000eZ*dC:$b!!>\u0003\b\t5\u0001CBA|\u0003{\u0014\t!\u0004\u0002\u0002z*\u0019\u00111`&\u0002\u0007I$G-\u0003\u0003\u0002\u0000\u0006e(a\u0001*E\tB!\u0011Q\fB\u0002\u0013\r\u0011)!\u0013\u0002\u0004%><\bb\u0002B\u0005'\u0001\u0007!1B\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB)q,!7\u0002\u0006\"9\u0011Q]\nA\u0002\u0005]\u0017A\u00048fK\u0012\u001cuN\u001c<feNLwN\\\u000b\u0003\u0003\u001b\fqBY;jY\u0012,f\u000e\\8bIN#X\u000e\u001e\u000b\r\u0003\u000b\u00139B!\u0007\u0003\u001c\t}!\u0011\u0005\u0005\b\u0005\u0013)\u0002\u0019\u0001B\u0006\u0011\u001d\t)/\u0006a\u0001\u0003/DqA!\b\u0016\u0001\u0004\t))A\u0004uK6\u0004H)\u001b:\t\r\u0005=X\u00031\u0001v\u0011\u001d\u0011\u0019#\u0006a\u0001\u0005K\t\u0011b]:f\u00176\u001c8*Z=\u0011\u000b}\u000b)%!\"\u0015\u001d\u0005\u0015%\u0011\u0006B\u001d\u0005w\u0011iDa\u0010\u0003B!9!1\u0006\fA\u0002\t5\u0012!C:uCR,W.\u001a8u!\u0011\u0011yC!\u000e\u000e\u0005\tE\"b\u0001B\u001as\u0005A\u0001/^:iI><h.\u0003\u0003\u00038\tE\"\u0001\u0006*fIND\u0017N\u001a;T#2\u001bF/\u0019;f[\u0016tG\u000fC\u0004\u0002\u0018Z\u0001\r!!\u0013\t\u000f\tua\u00031\u0001\u0002\u0006\"1\u0011q\u001e\fA\u0002UDqAa\t\u0017\u0001\u0004\u0011)\u0003C\u0004\u0003DY\u0001\r!!\"\u0002\u0015QD'/Z1e\u001d\u0006lW-A\u0006qeVtWmU2iK6\fGCBA%\u0005\u0013\u0012Y\u0005C\u0004\u0002\u0018^\u0001\r!!\u0013\t\u000f\t5s\u00031\u0001\u0003\f\u000591m\u001c7v[:\u001c\u0018\u0001\u00052vS2$7kY1o\rJ|WnU)M+\u0011\u0011\u0019Fa\u0017\u0015\u0011\tU#1\u000eB7\u0005_\u0002b!a>\u0002~\n]\u0003\u0003\u0002B-\u00057b\u0001\u0001B\u0004\u0003\u0006a\u0011\rA!\u0018\u0012\t\t}#Q\r\t\u0004?\n\u0005\u0014b\u0001B2A\n9aj\u001c;iS:<\u0007cA0\u0003h%\u0019!\u0011\u000e1\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003,a\u0001\rA!\f\t\u000f\u0005]\u0005\u00041\u0001\u0002D!I!1\t\r\u0011\u0002\u0003\u0007\u0011QQ\u0001\u001bEVLG\u000eZ*dC:4%o\\7T#2#C-\u001a4bk2$HeM\u000b\u0005\u0005k\u0012Y)\u0006\u0002\u0003x)\"\u0011Q\u0011B=W\t\u0011Y\b\u0005\u0003\u0003~\t\u001dUB\u0001B@\u0015\u0011\u0011\tIa!\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BCA\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%%q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,Ga\u0002B\u00033\t\u0007!QL\u0001\u000eeVtG)\u0014'Ge>l7+\u0015'\u0015\t\tE%\u0011\u0015\t\u0007\u0005'\u0013YJ!\u0001\u000f\t\tU%\u0011\u0014\b\u0005\u0003\u001b\u00119*C\u0001b\u0013\r\t\t\rY\u0005\u0005\u0005;\u0013yJA\u0002TKFT1!!1a\u0011\u001d\u0011YC\u0007a\u0001\u0005[\tAcR3u\u0007\u0006\u001c\u0007.\u001a3TgE+XM]=QCRDGC\u0002B\u0013\u0005O\u0013I\u000bC\u0004\u0003,m\u0001\rA!\f\t\u000f\t\r3\u00041\u0001\u0002\u0006\u0006qQO\u001c7pC\u0012$\u0015\r^1U_N\u001bD\u0003\u0004B\u0013\u0005_\u0013\tLa/\u0003@\n\u0005\u0007b\u0002B\u00169\u0001\u0007!Q\u0006\u0005\b\u0005gc\u0002\u0019\u0001B[\u0003\u0011\u0019wN\u001c8\u0011\u0007)\u00149,C\u0002\u0003:.\u0014!CU3eg\"Lg\r^\"p]:,7\r^5p]\"9!Q\u0018\u000fA\u0002\u0005%\u0013\u0001\u0004:fgVdGoU2iK6\f\u0007BBAx9\u0001\u0007Q\u000fC\u0004\u0003Dq\u0001\r!!\"\u00027\r|gN^3si\u000e{W\u000e\u001d7fqRK\b/Z:U_N#(/\u001b8h)\u0011\tIEa2\t\u000f\t%W\u00041\u0001\u0002J\u0005Y\u0011N\u001c9viN\u001b\u0007.Z7b\u0003Ui\u0017\r]\"p[BdW\r\u001f+za\u0016\u001cHk\u001c&t_:$BAa4\u0003\\BA\u0011q\u0011Bi\u0003\u000b\u0013).\u0003\u0003\u0003T\u0006M%aA'baB!\u0011Q\fBl\u0013\r\u0011I.\u0013\u0002\u0007\u0007>dW/\u001c8\t\u000f\t%g\u00041\u0001\u0002J\u00059!/Z1e%\u0012#U\u0003\u0002Bq\u0005O$bAa9\u0003l\n5\bCBA|\u0003{\u0014)\u000f\u0005\u0003\u0003Z\t\u001dHa\u0002Bu?\t\u0007!Q\f\u0002\u0002)\"9!QX\u0010A\u0002\u0005%\u0003b\u0002Bx?\u0001\u0007!\u0011_\u0001\fM&dWm\u001d+p%\u0016\fG\r\u0005\u0004\u0003\u0014\nm\u0015QQ\u0001\u0013e\u0016\fGM\u0015#E\rJ|W\u000eU1scV,G/\u0006\u0003\u0003x\nuHC\u0002B}\u0005\u007f\u001c\t\u0001\u0005\u0004\u0002x\u0006u(1 \t\u0005\u00053\u0012i\u0010B\u0004\u0003j\u0002\u0012\rA!\u0018\t\u000f\tu\u0006\u00051\u0001\u0002J!9!q\u001e\u0011A\u0002\tE\u0018AD4fi\u001aKG.Z:U_J+\u0017\r\u001a\u000b\u0007\u0005c\u001c9a!\u0003\t\u000f\tu\u0011\u00051\u0001\u0002\u0006\"911B\u0011A\u0002\r5\u0011AA:d!\u0011\u0019ya!\u0005\u000e\u0003-K1aa\u0005L\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003e)\u0007\u0010\u001e:bGR\u001c%/\u001a3f]RL\u0017\r\\:Ge>lWK]5\u0015\t\t\u00152\u0011\u0004\u0005\b\u00077\u0011\u0003\u0019AB\u000f\u0003\r)(/\u001b\t\u0005\u0007?\u0019I#\u0004\u0002\u0004\")!11EB\u0013\u0003\rqW\r\u001e\u0006\u0003\u0007O\tAA[1wC&!11FB\u0011\u0005\r)&+S\u0001\u001eC\u0012$7I]3eK:$\u0018.\u00197t\u0003:$WI\\:ve\u0016\u001c6\r[3nKRA\u0011QQB\u0019\u0007k\u0019I\u0004C\u0004\u00044\r\u0002\r!!\"\u0002\u0011\u0019LG.\u001a)bi\"Dqaa\u000e$\u0001\u0004\u0011)#A\u0006de\u0016$WM\u001c;jC2\u001c\bbBB\u001eG\u0001\u0007\u0011QQ\u0001\u0007g\u000eDW-\\3\u0002\u001f\u001d,GOU3tk2$8k\u00195f[\u0006$\u0002\"!\u0013\u0004B\r\r3Q\t\u0005\b\u0005W!\u0003\u0019\u0001B\u0017\u0011\u001d\t9\n\na\u0001\u0003\u0007BqAa-%\u0001\u0004\u0011),\u0001\u0003d_BLHCCB&\u0007\u001f\u001a\tfa\u0015\u0004VQ!\u00111OB'\u0011\u001d\t9&\na\u0001\u00037BqaZ\u0013\u0011\u0002\u0003\u0007\u0011\u000eC\u0004qKA\u0005\t\u0019\u0001:\t\u0011\u0005eR\u0005%AA\u0002}D\u0011\"a\u0010&!\u0003\u0005\r!a\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\f\u0016\u0004S\ne\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0007CR3A\u001dB=\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"aa\u001a+\u0007}\u0014I(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r5$\u0006BA\"\u0005s\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB:!\u0011\u0019)ha\u001f\u000e\u0005\r]$\u0002BB=\u0007K\tA\u0001\\1oO&!\u0011\u0011SB<\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0019\t\tE\u0002`\u0007\u0007K1a!\"a\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)ga#\t\u0013\r5E&!AA\u0002\r\u0005\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004\u0014B11QSBN\u0005Kj!aa&\u000b\u0007\re\u0005-\u0001\u0006d_2dWm\u0019;j_:LAa!(\u0004\u0018\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tima)\t\u0013\r5e&!AA\u0002\t\u0015\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\r\u0005\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002N\u000e5\u0006\"CBGa\u0005\u0005\t\u0019\u0001B3\u0003A\u0011V\rZ:iS\u001a$(+\u001a7bi&|g\u000eE\u0002\u0002vI\u001aBAMB[IB\u0019qla.\n\u0007\re\u0006M\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007c\u000b\u0001c]2iK6\fG+\u001f9fg6\u000bGo\u00195\u0015\r\u000557\u0011YBf\u0011\u001d\u0019\u0019\r\u000ea\u0001\u0007\u000b\fqa]2iK6\f\u0017\u0007\u0005\u0003\u0002L\r\u001d\u0017\u0002BBe\u0003\u001b\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0007\u001b$\u0004\u0019ABc\u0003\u001d\u00198\r[3nCJ\nQ!\u00199qYf$\"ba5\u0004X\u000ee71\\Bo)\u0011\t\u0019h!6\t\u000f\u0005]S\u00071\u0001\u0002\\!)q-\u000ea\u0001S\")\u0001/\u000ea\u0001e\"1\u0011\u0011H\u001bA\u0002}Dq!a\u00106\u0001\u0004\t\u0019%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\r81\u001e\t\u0006?\u0006\u00153Q\u001d\t\t?\u000e\u001d\u0018N]@\u0002D%\u00191\u0011\u001e1\u0003\rQ+\b\u000f\\35\u0011%\u0019iONA\u0001\u0002\u0004\t\u0019(A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u001111\u001f\t\u0005\u0007k\u001a)0\u0003\u0003\u0004x\u000e]$AB(cU\u0016\u001cG\u000f")
public class RedshiftRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
scala.Serializable {
    private StructType schema;
    private final RedshiftWrapper redshiftWrapper;
    private final Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory;
    private final Parameters.MergedParameters params;
    private final Option<StructType> userSchema;
    private final transient SQLContext sqlContext;
    private final String tableNameOrSubquery;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<RedshiftWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3>, Parameters.MergedParameters, Option<StructType>>> unapply(RedshiftRelation redshiftRelation) {
        return RedshiftRelation$.MODULE$.unapply(redshiftRelation);
    }

    public static RedshiftRelation apply(RedshiftWrapper redshiftWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> function2, Parameters.MergedParameters mergedParameters, Option<StructType> option, SQLContext sQLContext) {
        return RedshiftRelation$.MODULE$.apply(redshiftWrapper, function2, mergedParameters, option, sQLContext);
    }

    public static boolean schemaTypesMatch(DataType dataType, DataType dataType2) {
        return RedshiftRelation$.MODULE$.schemaTypesMatch(dataType, dataType2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RedshiftWrapper redshiftWrapper() {
        return this.redshiftWrapper;
    }

    public Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory() {
        return this.s3ClientFactory;
    }

    public Parameters.MergedParameters params() {
        return this.params;
    }

    public Option<StructType> userSchema() {
        return this.userSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private String tableNameOrSubquery() {
        return this.tableNameOrSubquery;
    }

    private StructType schema$lzycompute() {
        RedshiftRelation redshiftRelation = this;
        synchronized (redshiftRelation) {
            if (!this.bitmap$0) {
                this.schema = (StructType)this.userSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    StructType structType;
                    String tableNameOrSubquery = (String)this.params().query().map((Function1 & Serializable & scala.Serializable)q -> new StringBuilder(2).append("(").append((String)q).append(")").toString()).orElse((Function0 & Serializable & scala.Serializable)() -> this.params().table().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString())).get();
                    try (RedshiftConnection conn = this.redshiftWrapper().getConnector(this.params());){
                        structType = this.redshiftWrapper().resolveTable(conn, tableNameOrSubquery, (Option<Parameters.MergedParameters>)new Some((Object)this.params()));
                    }
                    return structType;
                });
                this.bitmap$0 = true;
            }
        }
        return this.schema;
    }

    public StructType schema() {
        return !this.bitmap$0 ? this.schema$lzycompute() : this.schema;
    }

    public String toString() {
        return new StringBuilder(18).append("RedshiftRelation(").append(this.tableNameOrSubquery()).append(")").toString();
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        SaveMode saveMode = overwrite ? SaveMode.Overwrite : SaveMode.Append;
        RedshiftWriter writer = new RedshiftWriter(this.redshiftWrapper(), this.s3ClientFactory());
        writer.saveToRedshift(this.sqlContext(), data, saveMode, this.params());
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        return (Filter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).filterNot((Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$unhandledFilters$1(this, filter)));
    }

    private void checkS3BucketUsage(Parameters.MergedParameters params, AWSCredentialsProvider credsProvider) {
        if (!params.checkS3BucketUsage()) {
            return;
        }
        AmazonS3 s3Client = (AmazonS3)this.s3ClientFactory().apply((Object)credsProvider, (Object)params);
        Utils$.MODULE$.checkRedshiftAndS3OnSameRegion(params, s3Client);
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params, s3Client);
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        Object object;
        block8: {
            AWSCredentialsProvider credsProvider = AWSCredentialsUtils$.MODULE$.load(this.params(), this.sqlContext().sparkContext().hadoopConfiguration());
            this.checkS3BucketUsage(this.params(), credsProvider);
            Utils$.MODULE$.collectMetrics(this.params(), Utils$.MODULE$.collectMetrics$default$2());
            String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Read$.MODULE$, this.params(), this.sqlContext());
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty()) {
                String whereClause = FilterPushdown$.MODULE$.buildWhereClause(this.schema(), (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), FilterPushdown$.MODULE$.buildWhereClause$default$3());
                String countQuery = new StringBuilder(22).append("SELECT count(*) FROM ").append(this.tableNameOrSubquery()).append(" ").append(whereClause).toString();
                try (RedshiftConnection conn = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
                    this.log().info("Getting number of rows from Redshift");
                    RedshiftResults results = this.redshiftWrapper().executeQueryInterruptibly(conn, countQuery);
                    if (results.next()) {
                        long numRows = results.getLong(1);
                        this.log().info("Number of rows is {}", (Object)BoxesRunTime.boxToLong((long)numRows));
                        int parallelism = new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf("spark.sql.shuffle.partitions", "200"))).toInt();
                        InternalRow emptyRow = RowEncoderUtils$.MODULE$.expressionEncoderForSchema(StructType$.MODULE$.apply((Seq)Nil$.MODULE$)).createSerializer().apply((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Nil$.MODULE$})));
                        object = this.sqlContext().sparkContext().parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)numRows)), parallelism, ClassTag$.MODULE$.Long()).map((Function1 & Serializable & scala.Serializable)x$3 -> emptyRow, ClassTag$.MODULE$.apply(InternalRow.class));
                        break block8;
                    }
                    throw new IllegalStateException("Could not read count from Redshift");
                }
            }
            String tempDir = this.params().createPerQueryTempDir();
            String unloadSql = this.buildUnloadStmt(requiredColumns, filters, tempDir, credsProvider, this.params().sseKmsKey());
            try (RedshiftConnection conn = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
                this.log().info("Unloading data from Redshift");
                this.redshiftWrapper().executeInterruptibly(conn, unloadSql);
            }
            Seq<String> filesToRead = this.getFilesToRead(tempDir, this.sqlContext().sparkContext());
            StructType prunedSchema = this.pruneSchema(this.schema(), requiredColumns);
            String string = this.params().unloadS3Format();
            String string2 = "PARQUET";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? this.readRDDFromParquet(prunedSchema, filesToRead) : this.readRDD(prunedSchema, filesToRead);
        }
        return object;
    }

    public boolean needConversion() {
        return false;
    }

    private String buildUnloadStmt(String[] requiredColumns, Filter[] filters, String tempDir, AWSCredentialsProvider credsProvider, Option<String> sseKmsKey) {
        Predef$.MODULE$.assert(!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty());
        String columnList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(2).append("\"").append((String)col).append("\"").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
        String whereClause = FilterPushdown$.MODULE$.buildWhereClause(this.schema(), (Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), true);
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(this.params(), credsProvider.getCredentials());
        String escapedTableNameOrSubqury = this.tableNameOrSubquery().replace("\\", "\\\\").replace("'", "\\'");
        String query = new StringBuilder(14).append("SELECT ").append(columnList).append(" FROM ").append(escapedTableNameOrSubqury).append(" ").append(whereClause).toString();
        Utils$.MODULE$.lastBuildStmt().update((Object)Thread.currentThread().getName(), (Object)query);
        String fixedUrl = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(new URI(tempDir)).toString());
        String unloadClause = new StringBuilder(17).append("UNLOAD ('").append(query).append("') TO '").append(fixedUrl).append("'").toString();
        String credClause = new StringBuilder(19).append("WITH CREDENTIALS '").append(credsString).append("'").toString();
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        String manifestClause = !(string != null ? !string.equals(string2) : string2 != null) ? "FORMAT AS PARQUET  MANIFEST" : new StringBuilder(26).append("ESCAPE MANIFEST NULL AS '").append(this.params().nullString()).append("'").toString();
        String sseKmsClause = (String)sseKmsKey.map((Function1 & Serializable & scala.Serializable)key -> new StringBuilder(23).append("KMS_KEY_ID '").append((String)key).append("' ENCRYPTED").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String regionClause = (String)this.params().tempDirRegion().map((Function1 & Serializable & scala.Serializable)region -> new StringBuilder(12).append("REGION AS '").append((String)region).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraClause = String.valueOf(this.params().extraUnloadOptions());
        String string3 = unloadClause;
        String string4 = credClause;
        String string5 = manifestClause;
        String string6 = sseKmsClause;
        String string7 = regionClause;
        String string8 = extraClause;
        List unloadStmtList = Nil$.MODULE$.$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
        return unloadStmtList.mkString(" ");
    }

    private String buildUnloadStmt(RedshiftSQLStatement statement, StructType schema, String tempDir, AWSCredentialsProvider credsProvider, Option<String> sseKmsKey, String threadName) {
        Predef$.MODULE$.assert(schema.nonEmpty());
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(this.params(), credsProvider.getCredentials());
        String query = statement.statementString().replace("\\", "\\\\").replace("'", "\\'");
        Utils$.MODULE$.lastBuildStmt().update((Object)threadName, (Object)query);
        String fixedUrl = Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(new URI(tempDir)).toString());
        String unloadClause = new StringBuilder(33).append("UNLOAD ('SELECT * FROM (").append(query).append(")') TO '").append(fixedUrl).append("'").toString();
        String credClause = new StringBuilder(19).append("WITH CREDENTIALS '").append(credsString).append("'").toString();
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        String manifestClause = !(string != null ? !string.equals(string2) : string2 != null) ? "FORMAT AS PARQUET  MANIFEST" : new StringBuilder(26).append("ESCAPE MANIFEST NULL AS '").append(this.params().nullString()).append("'").toString();
        String sseKmsClause = (String)sseKmsKey.map((Function1 & Serializable & scala.Serializable)key -> new StringBuilder(23).append("KMS_KEY_ID '").append((String)key).append("' ENCRYPTED").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String regionClause = (String)this.params().tempDirRegion().map((Function1 & Serializable & scala.Serializable)region -> new StringBuilder(12).append("REGION AS '").append((String)region).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraClause = String.valueOf(this.params().extraUnloadOptions());
        String string3 = unloadClause;
        String string4 = credClause;
        String string5 = manifestClause;
        String string6 = sseKmsClause;
        String string7 = regionClause;
        String string8 = extraClause;
        List unloadStmtList = Nil$.MODULE$.$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3);
        return unloadStmtList.mkString(" ");
    }

    private StructType pruneSchema(StructType schema, String[] columns) {
        Map fieldMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)name -> (StructField)fieldMap.apply(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public <Row> RDD<Row> buildScanFromSQL(RedshiftSQLStatement statement, Option<StructType> schema, String threadName) {
        Option option;
        StructType structType;
        try (RedshiftConnection conn = this.redshiftWrapper().getConnector(this.params());){
            structType = this.getResultSchema(statement, schema, conn);
        }
        StructType resultSchema = structType;
        AWSCredentialsProvider credsProvider = AWSCredentialsUtils$.MODULE$.load(this.params(), this.sqlContext().sparkContext().hadoopConfiguration());
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Read$.MODULE$, this.params(), this.sqlContext());
        try (RedshiftConnection connWithQG = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
            this.checkS3BucketUsage(this.params(), credsProvider);
            Utils$.MODULE$.collectMetrics(this.params(), Utils$.MODULE$.collectMetrics$default$2());
            option = this.GetCachedS3QueryPath(statement, threadName).orElse((Function0 & Serializable & scala.Serializable)() -> this.unloadDataToS3(statement, connWithQG, resultSchema, credsProvider, threadName));
        }
        Option tempDir = option;
        Seq<String> filesToRead = this.getFilesToRead((String)tempDir.get(), this.sqlContext().sparkContext());
        String string = this.params().unloadS3Format();
        String string2 = "PARQUET";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.readRDDFromParquet(resultSchema, filesToRead) : this.readRDD(resultSchema, filesToRead);
    }

    public <Row> String buildScanFromSQL$default$3() {
        return Thread.currentThread().getName();
    }

    public Seq<Row> runDMLFromSQL(RedshiftSQLStatement statement) {
        Seq seq;
        String statementStr = statement.statementString();
        Utils$.MODULE$.lastBuildStmt().update((Object)Thread.currentThread().getName(), (Object)statementStr);
        String queryGroup = Utils$.MODULE$.queryGroupInfo(Utils$Write$.MODULE$, this.params(), this.sqlContext());
        this.redshiftWrapper().setAutoCommit(conn, false);
        try (RedshiftConnection conn = this.redshiftWrapper().getConnectorWithQueryGroup(this.params(), queryGroup);){
            Object object;
            if (this.params().table().isDefined() && new StringOps(Predef$.MODULE$.augmentString(((TableName)this.params().table().get()).unescapedDatabaseName())).nonEmpty()) {
                String useDbStr = new StringBuilder(4).append("use ").append(((TableName)this.params().table().get()).escapedDatabaseName()).toString();
                object = BoxesRunTime.boxToBoolean((boolean)this.redshiftWrapper().executeInterruptibly(conn, useDbStr));
            } else {
                object = BoxedUnit.UNIT;
            }
            long affectedRows = this.redshiftWrapper().executeUpdate(conn, statementStr);
            this.redshiftWrapper().commit(conn);
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)affectedRows)})), (List)Nil$.MODULE$);
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    private Option<String> GetCachedS3QueryPath(RedshiftSQLStatement statement, String threadName) {
        void var3_3;
        block1: {
            if (!this.params().pushdownS3ResultCache()) {
                return None$.MODULE$;
            }
            Option<String> cachedPath = SqlToS3TempCache$.MODULE$.getS3Path(statement.statementString());
            if (!cachedPath.isDefined()) break block1;
            Utils$.MODULE$.lastBuildStmt().update((Object)threadName, (Object)statement.statementString().replace("\\", "\\\\").replace("'", "\\'"));
        }
        return var3_3;
    }

    private Option<String> unloadDataToS3(RedshiftSQLStatement statement, RedshiftConnection conn, StructType resultSchema, AWSCredentialsProvider credsProvider, String threadName) {
        String newTempDir = this.params().createPerQueryTempDir();
        String unloadSql = this.buildUnloadStmt(statement, resultSchema, newTempDir, credsProvider, this.params().sseKmsKey(), threadName);
        this.log().info("Unloading data from Redshift");
        this.redshiftWrapper().executeInterruptibly(conn, unloadSql);
        SqlToS3TempCache$.MODULE$.setS3Path(statement.statementString(), newTempDir);
        return new Some((Object)newTempDir);
    }

    private StructType convertComplexTypesToString(StructType inputSchema) {
        return StructType$.MODULE$.apply((Seq)inputSchema.map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dataType = field.dataType();
            boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
            StructField structField = bl ? new StructField(field.name(), (DataType)StringType$.MODULE$, field.nullable(), field.metadata()) : field;
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private Map<String, Column> mapComplexTypesToJson(StructType inputSchema) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSchema.fields())).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$mapComplexTypesToJson$1(field))))).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)functions$.MODULE$.from_json(functions$.MODULE$.col(field.name()), field.dataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    private <T> RDD<T> readRDD(StructType resultSchema, Seq<String> filesToRead) {
        this.log().info("Reading S3 Text files");
        StructType noRepeatSchema = StructType$.MODULE$.apply((Seq)((TraversableLike)resultSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StructField structField = new StructField(new StringBuilder(5).append("field").append(index).toString(), f.dataType(), f.nullable(), f.metadata());
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
        StructType modifiedSchema = this.convertComplexTypesToString(noRepeatSchema);
        Dataset dataFrame = this.sqlContext().read().format(RedshiftFileFormat.class.getName()).schema(modifiedSchema).option("nullString", this.params().nullString()).option(Parameters$.MODULE$.PARAM_OVERRIDE_NULLABLE(), this.params().overrideNullable()).load(filesToRead);
        Map<String, Column> mapping = this.mapComplexTypesToJson(noRepeatSchema);
        return mapping.nonEmpty() ? dataFrame.withColumns(mapping).queryExecution().executedPlan().execute() : dataFrame.queryExecution().executedPlan().execute();
    }

    private <T> RDD<T> readRDDFromParquet(StructType resultSchema, Seq<String> filesToRead) {
        RDD rDD;
        boolean conversionNeeded;
        this.log().info("Reading S3 Parquet files");
        DataFrameReader reader = this.sqlContext().read().format("parquet");
        StructType modifiedSchema = this.convertComplexTypesToString(resultSchema);
        Object object = filesToRead.isEmpty() ? reader.schema(modifiedSchema) : BoxedUnit.UNIT;
        boolean overrideNullable = this.params().overrideNullable();
        Dataset data = reader.load(filesToRead);
        Map<String, Column> mapping = this.mapComplexTypesToJson(new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields())).zip((GenIterable)resultSchema, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField actualField = (StructField)tuple2._1();
            StructField expectedField = (StructField)tuple2._2();
            StructField structField = new StructField(actualField.name(), expectedField.dataType(), expectedField.nullable(), expectedField.metadata());
            return structField;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
        Dataset jsonLoaded = mapping.nonEmpty() ? data.withColumns(mapping) : data;
        StructType jsonLoadedSchema = jsonLoaded.schema();
        boolean schemasDoNotMatch = !RedshiftRelation$.MODULE$.schemaTypesMatch((DataType)resultSchema, (DataType)jsonLoadedSchema);
        boolean bl = conversionNeeded = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resultSchema.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)RedshiftRelation.$anonfun$readRDDFromParquet$2(field))) || overrideNullable || schemasDoNotMatch;
        if (schemasDoNotMatch) {
            this.log().warn("Expected schema does not match schema of loaded parquet");
        }
        if (conversionNeeded) {
            RDD qual$1 = jsonLoaded.queryExecution().executedPlan().execute().map((Function1 & Serializable & scala.Serializable)row -> {
                Seq typeConvertedRow = (Seq)((TraversableLike)row.toSeq(jsonLoadedSchema).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object f = tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Object object = Conversions$.MODULE$.parquetDataTypeConvert(f, resultSchema.fields()[i].dataType(), resultSchema.fields()[i].metadata().contains("redshift_type") ? resultSchema.fields()[i].metadata().getString("redshift_type") : null, overrideNullable);
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                return InternalRow$.MODULE$.apply(typeConvertedRow);
            }, ClassTag$.MODULE$.apply(InternalRow.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create(resultSchema);
                return iter.map((Function1)projection);
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
        } else {
            rDD = jsonLoaded.queryExecution().executedPlan().execute();
        }
        return rDD;
    }

    private Seq<String> getFilesToRead(String tempDir, SparkContext sc) {
        Seq seq;
        Path manifestPath;
        URI tempDirUri = URI.create(tempDir);
        URI cleanedTempDirUri = Utils$.MODULE$.removeCredentialsFromURI(tempDirUri);
        String tempDirScheme = tempDirUri.getScheme();
        Option<String> credentials = this.extractCredentialsFromUri(tempDirUri);
        Configuration conf = sc.hadoopConfiguration();
        FileSystem fs = FileSystem.get((URI)cleanedTempDirUri, (Configuration)conf);
        if (fs.exists(manifestPath = new Path(new StringBuilder(9).append(cleanedTempDirUri.toString()).append("/manifest").toString()))) {
            Seq correctedS3Files;
            Seq seq2;
            FSDataInputStream is = fs.open(manifestPath);
            try {
                this.log().info("Begin finding S3 files to read");
                ObjectMapper mapper = new ObjectMapper();
                JsonNode entries = mapper.readTree((Reader)new InputStreamReader((InputStream)is)).get("entries");
                Seq results = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(entries.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.get("url").asText()).toSeq();
                this.log().info("Found {} S3 file(s)", (Object)BoxesRunTime.boxToInteger((int)results.length()));
                seq2 = results;
            }
            finally {
                is.close();
                this.log().info("End finding S3 files to read");
            }
            Seq s3Files = seq2;
            seq = correctedS3Files = (Seq)s3Files.map((Function1 & Serializable & scala.Serializable)file -> this.addCredentialsAndEnsureScheme((String)file, credentials, tempDirScheme), Seq$.MODULE$.canBuildFrom());
        } else {
            this.log().debug("Manifest path not found");
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    private Option<String> extractCredentialsFromUri(URI uri) {
        return Option$.MODULE$.apply((Object)uri.getUserInfo());
    }

    private String addCredentialsAndEnsureScheme(String filePath, Option<String> credentials, String scheme) {
        String string;
        URI fileUri = URI.create(filePath);
        String bucket = fileUri.getHost();
        String prefixPath = new StringOps(Predef$.MODULE$.augmentString(fileUri.getPath())).stripPrefix("/");
        String filePathWithoutSchemeAndCreds = new StringBuilder(1).append(bucket).append("/").append(prefixPath).toString();
        Option<String> option = credentials;
        if (option instanceof Some) {
            Some some = (Some)option;
            String creds = (String)some.value();
            string = new StringBuilder(4).append(scheme).append("://").append(creds).append("@").append(filePathWithoutSchemeAndCreds).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(3).append(scheme).append("://").append(filePathWithoutSchemeAndCreds).toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private StructType getResultSchema(RedshiftSQLStatement statement, Option<StructType> schema, RedshiftConnection conn) {
        StructType resultSchema = (StructType)schema.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.redshiftWrapper().tableSchema(conn, statement, this.params()));
        if (resultSchema.isEmpty()) {
            throw new Exception(new StringBuilder(25).append("resultSchema isEmpty for ").append(statement.statementString()).toString());
        }
        return resultSchema;
    }

    public RedshiftRelation copy(RedshiftWrapper redshiftWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        return new RedshiftRelation(redshiftWrapper, s3ClientFactory, params, userSchema, sqlContext);
    }

    public RedshiftWrapper copy$default$1() {
        return this.redshiftWrapper();
    }

    public Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> copy$default$2() {
        return this.s3ClientFactory();
    }

    public Parameters.MergedParameters copy$default$3() {
        return this.params();
    }

    public Option<StructType> copy$default$4() {
        return this.userSchema();
    }

    public String productPrefix() {
        return "RedshiftRelation";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.redshiftWrapper();
                break;
            }
            case 1: {
                object = this.s3ClientFactory();
                break;
            }
            case 2: {
                object = this.params();
                break;
            }
            case 3: {
                object = this.userSchema();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RedshiftRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RedshiftRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        RedshiftRelation redshiftRelation = (RedshiftRelation)((Object)x$1);
        RedshiftWrapper redshiftWrapper = this.redshiftWrapper();
        RedshiftWrapper redshiftWrapper2 = redshiftRelation.redshiftWrapper();
        if (redshiftWrapper == null) {
            if (redshiftWrapper2 != null) {
                return false;
            }
        } else if (!redshiftWrapper.equals(redshiftWrapper2)) return false;
        Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> function2 = this.s3ClientFactory();
        Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> function22 = redshiftRelation.s3ClientFactory();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Parameters.MergedParameters mergedParameters = this.params();
        Parameters.MergedParameters mergedParameters2 = redshiftRelation.params();
        if (mergedParameters == null) {
            if (mergedParameters2 != null) {
                return false;
            }
        } else if (!((Object)mergedParameters).equals(mergedParameters2)) return false;
        Option<StructType> option = this.userSchema();
        Option<StructType> option2 = redshiftRelation.userSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!redshiftRelation.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$unhandledFilters$1(RedshiftRelation $this, Filter filter) {
        return FilterPushdown$.MODULE$.buildFilterExpression($this.schema(), filter, FilterPushdown$.MODULE$.buildFilterExpression$default$3()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$mapComplexTypesToJson$1(StructField field) {
        DataType dataType = field.dataType();
        boolean bl = dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$readRDDFromParquet$2(StructField field) {
        Option<Object> option;
        boolean bl;
        DataType dataType = field.dataType();
        boolean bl2 = StringType$.MODULE$.equals(dataType) ? field.metadata().contains("redshift_type") && ((SeqLike)new .colon.colon((Object)"super", (List)new .colon.colon((Object)"bpchar", (List)Nil$.MODULE$))).contains((Object)field.metadata().getString("redshift_type")) : ((bl = TimestampType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType))) ? true : !(option = TimestampNTZTypeExtractor$.MODULE$.unapply(dataType)).isEmpty() && !package$.MODULE$.legacyTimestampHandling());
        return bl2;
    }

    public RedshiftRelation(RedshiftWrapper redshiftWrapper, Function2<AWSCredentialsProvider, Parameters.MergedParameters, AmazonS3> s3ClientFactory, Parameters.MergedParameters params, Option<StructType> userSchema, SQLContext sqlContext) {
        this.redshiftWrapper = redshiftWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.params = params;
        this.userSchema = userSchema;
        this.sqlContext = sqlContext;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        if (params.checkS3BucketUsage() && sqlContext != null) {
            Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        }
        this.tableNameOrSubquery = (String)params.query().map((Function1 & Serializable & scala.Serializable)q -> new StringBuilder(2).append("(").append((String)q).append(")").toString()).orElse((Function0 & Serializable & scala.Serializable)() -> this.params().table().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString())).get();
    }
}

