/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.RedshiftInputFormat$;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0014)\u0001!\u0012\u0004\"B-\u0001\t\u0003Q\u0006\"C/\u0001\u0001\u0004\u0005\r\u0011\"\u0003_\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005l\u0001\u0001\u0007\t\u0011)Q\u0005?\"IA\u000e\u0001a\u0001\u0002\u0004%I!\u001c\u0005\n]\u0002\u0001\r\u00111A\u0005\n=D\u0011\"\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B \t\u0013I\u0004\u0001\u0019!a\u0001\n\u0013\u0019\b\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0011%9\b\u00011A\u0001B\u0003&q\tC\u0005y\u0001\u0001\u0007\t\u0019!C\u0005s\"IA\u0010\u0001a\u0001\u0002\u0004%I! \u0005\n\u007f\u0002\u0001\r\u0011!Q!\niD!\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003z\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005%\u0001\u00011A\u0001B\u0003&!\u0010\u0003\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\neD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010!Q\u00111\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002>\t\u0013\u0005U\u0001\u00011A\u0005\n\u0005]\u0001\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0011!\t)\u0003\u0001Q!\n\u0005e\u0001bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003SA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u0011q\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0016\u0011!\tI\u0004\u0001Q\u0001\u000e\u0005-\u0002\u0002CA\"\u0001\u0001\u0006i!a\u000b\t\u0011\u0005\u001d\u0003\u0001)A\u0007\u0003WA\u0001\"a\u0013\u0001A\u00035\u0011Q\n\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002V!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\"9\u00111\u0018\u0001\u0005\n\u00055%\u0001\u0006*fIND\u0017N\u001a;SK\u000e|'\u000f\u001a*fC\u0012,'O\u0003\u0002*U\u0005A!/\u001a3tQ&4GO\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0019gB\f'o[0sK\u0012\u001c\b.\u001b4u?\u000e|W.\\;oSRL(BA\u00181\u0003\u00199\u0017\u000e\u001e5vE*\t\u0011'\u0001\u0002j_N\u0011\u0001a\r\t\u0005iuzt)D\u00016\u0015\t1t'A\u0005nCB\u0014X\rZ;dK*\u0011\u0001(O\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0005\u0003}U\u0012ABU3d_J$'+Z1eKJ\u0004\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\t1\fgn\u001a\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015I\u0001\u0003M_:<\u0007c\u0001%L\u001b6\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0003BeJ\f\u0017\u0010\u0005\u0002O-:\u0011q\n\u0016\t\u0003!&k\u0011!\u0015\u0006\u0003%N\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0003+&\u000ba\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011Q+S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0003\"\u0001\u0018\u0001\u000e\u0003!\naA]3bI\u0016\u0014X#A0\u0011\u0005\u0001\u0014W\"A1\u000b\u0005E\u001a\u0015BA2b\u0005M\u0011UO\u001a4fe\u0016$\u0017J\u001c9viN#(/Z1n\u0003)\u0011X-\u00193fe~#S-\u001d\u000b\u0003M&\u0004\"\u0001S4\n\u0005!L%\u0001B+oSRDqA[\u0002\u0002\u0002\u0003\u0007q,A\u0002yIE\nqA]3bI\u0016\u0014\b%A\u0002lKf,\u0012aP\u0001\bW\u0016Lx\fJ3r)\t1\u0007\u000fC\u0004k\r\u0005\u0005\t\u0019A \u0002\t-,\u0017\u0010I\u0001\u0006m\u0006dW/Z\u000b\u0002\u000f\u0006Ia/\u00197vK~#S-\u001d\u000b\u0003MZDqA[\u0005\u0002\u0002\u0003\u0007q)\u0001\u0004wC2,X\rI\u0001\u0006gR\f'\u000f^\u000b\u0002uB\u0011\u0001j_\u0005\u0003\r&\u000b\u0011b\u001d;beR|F%Z9\u0015\u0005\u0019t\bb\u00026\r\u0003\u0003\u0005\rA_\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\u0007\u0015tG-A\u0004f]\u0012|F%Z9\u0015\u0007\u0019\f9\u0001C\u0004k\u001f\u0005\u0005\t\u0019\u0001>\u0002\t\u0015tG\rI\u0001\u0004GV\u0014\u0018aB2ve~#S-\u001d\u000b\u0004M\u0006E\u0001b\u00026\u0013\u0003\u0003\u0005\rA_\u0001\u0005GV\u0014\b%A\u0002f_\u001a,\"!!\u0007\u0011\u0007!\u000bY\"C\u0002\u0002\u001e%\u0013qAQ8pY\u0016\fg.A\u0004f_\u001a|F%Z9\u0015\u0007\u0019\f\u0019\u0003\u0003\u0005k+\u0005\u0005\t\u0019AA\r\u0003\u0011)wN\u001a\u0011\u0002\u0013\u0011,G.[7ji\u0016\u0014XCAA\u0016!\rA\u0015QF\u0005\u0004\u0003_I%\u0001\u0002\"zi\u0016\fQ\u0002Z3mS6LG/\u001a:`I\u0015\fHc\u00014\u00026!A!\u000eGA\u0001\u0002\u0004\tY#\u0001\u0006eK2LW.\u001b;fe\u0002\n!\"Z:dCB,7\t[1sQ\rQ\u0012Q\b\t\u0004\u0011\u0006}\u0012bAA!\u0013\n1\u0011N\u001c7j]\u0016\f\u0001\u0002\\5oK\u001a+W\r\u001a\u0015\u00047\u0005u\u0012AD2beJL\u0017mZ3SKR,(O\u001c\u0015\u00049\u0005u\u0012!\u00053fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K>\u0011\u0011qJ\u000f\u0004!\u0001\u0001\u0001fA\u000f\u0002>\u0005)1\r[1sgB1\u0011qKA1\u0003Wi!!!\u0017\u000b\t\u0005m\u0013QL\u0001\b[V$\u0018M\u00197f\u0015\r\ty&S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u00033\u00121\"\u0011:sCf\u0014UO\u001a4fe\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000b\u0019\fI'a\u001d\t\u000f\u0005-t\u00041\u0001\u0002n\u0005Q\u0011N\u001c9viN\u0003H.\u001b;\u0011\u0007Q\ny'C\u0002\u0002rU\u0012!\"\u00138qkR\u001c\u0006\u000f\\5u\u0011\u001d\t)h\ba\u0001\u0003o\nqaY8oi\u0016DH\u000fE\u00025\u0003sJ1!a\u001f6\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\u0017\u001d,G\u000f\u0015:pOJ,7o\u001d\u000b\u0003\u0003\u0003\u00032\u0001SAB\u0013\r\t))\u0013\u0002\u0006\r2|\u0017\r^\u0001\r]\u0016DHoS3z-\u0006dW/\u001a\u000b\u0003\u00033\tqbZ3u\u0007V\u0014(/\u001a8u-\u0006dW/\u001a\u000b\u0002\u000f\u0006iq-\u001a;DkJ\u0014XM\u001c;LKf$\u0012aP\u0001\u0006G2|7/\u001a\u000b\u0002M\u0006Aa-\u001b8e\u001d\u0016DH\u000fF\u0005{\u00037\u000bI+a-\u00028\"9\u0011QT\u0013A\u0002\u0005}\u0015A\u00014t!\u0011\t\t+!*\u000e\u0005\u0005\r&bAAOo%!\u0011qUAR\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\b\u0003W+\u0003\u0019AAW\u0003\u00111\u0017\u000e\\3\u0011\t\u0005\u0005\u0016qV\u0005\u0005\u0003c\u000b\u0019K\u0001\u0003QCRD\u0007BBA[K\u0001\u0007!0\u0001\u0003tSj,\u0007BBA]K\u0001\u0007!0\u0001\u0004pM\u001a\u001cX\r^\u0001\n]\u0016DHOV1mk\u0016\u0004")
public class RedshiftRecordReader
extends RecordReader<Long, String[]> {
    private BufferedInputStream reader;
    private Long key;
    private String[] value;
    private long start;
    private long end;
    private long cur;
    private boolean eof = false;
    private byte delimiter;
    private final byte escapeChar = (byte)92;
    private final byte lineFeed = (byte)10;
    private final byte carriageReturn = (byte)13;
    private final ArrayBuffer<Object> chars = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();

    private BufferedInputStream reader() {
        return this.reader;
    }

    private void reader_$eq(BufferedInputStream x$1) {
        this.reader = x$1;
    }

    private Long key() {
        return this.key;
    }

    private void key_$eq(Long x$1) {
        this.key = x$1;
    }

    private String[] value() {
        return this.value;
    }

    private void value_$eq(String[] x$1) {
        this.value = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private long cur() {
        return this.cur;
    }

    private void cur_$eq(long x$1) {
        this.cur = x$1;
    }

    private boolean eof() {
        return this.eof;
    }

    private void eof_$eq(boolean x$1) {
        this.eof = x$1;
    }

    private byte delimiter() {
        return this.delimiter;
    }

    private void delimiter_$eq(byte x$1) {
        this.delimiter = x$1;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
        Object object;
        FileSplit split = (FileSplit)inputSplit;
        Path file = split.getPath();
        Configuration conf = context.getConfiguration();
        this.delimiter_$eq((byte)RedshiftInputFormat$.MODULE$.getDelimiterOrDefault(conf));
        Predef$.MODULE$.require(this.delimiter() != this.escapeChar, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("The delimiter and the escape char cannot be the same but found ").append(this.delimiter()).append(".").toString());
        Predef$.MODULE$.require(this.delimiter() != this.lineFeed, (Function0 & Serializable & scala.Serializable)() -> "The delimiter cannot be the lineFeed character.");
        Predef$.MODULE$.require(this.delimiter() != this.carriageReturn, (Function0 & Serializable & scala.Serializable)() -> "The delimiter cannot be the carriage return.");
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        CompressionCodec codec = compressionCodecs.getCodec(file);
        if (codec != null) {
            throw new IOException(new StringBuilder(43).append("Do not support compressed files but found ").append(file).append(".").toString());
        }
        FileSystem fs = file.getFileSystem(conf);
        long size = fs.getFileStatus(file).getLen();
        this.start_$eq(this.findNext(fs, file, size, split.getStart()));
        this.end_$eq(this.findNext(fs, file, size, split.getStart() + split.getLength()));
        this.cur_$eq(this.start());
        FSDataInputStream in = fs.open(file);
        if (this.cur() > 0L) {
            in.seek(this.cur() - 1L);
            object = BoxesRunTime.boxToInteger((int)in.read());
        } else {
            object = BoxedUnit.UNIT;
        }
        this.reader_$eq(new BufferedInputStream((InputStream)in, 0x100000));
    }

    public float getProgress() {
        return this.start() >= this.end() ? 1.0f : package$.MODULE$.min((float)(this.cur() - this.start()) / (float)(this.end() - this.start()), 1.0f);
    }

    public boolean nextKeyValue() {
        boolean bl;
        if (this.cur() < this.end() && !this.eof()) {
            this.key_$eq(Predef$.MODULE$.long2Long(this.cur()));
            this.value_$eq(this.nextValue());
            bl = true;
        } else {
            this.key_$eq(null);
            this.value_$eq(null);
            bl = false;
        }
        return bl;
    }

    public String[] getCurrentValue() {
        return this.value();
    }

    public Long getCurrentKey() {
        return this.key();
    }

    public void close() {
        block0: {
            if (this.reader() == null) break block0;
            this.reader().close();
        }
    }

    private long findNext(FileSystem fs, Path file, long size, long offset) {
        if (offset == 0L) {
            return 0L;
        }
        if (offset >= size) {
            return size;
        }
        FSDataInputStream in = fs.open(file);
        long pos = offset;
        in.seek(pos);
        BufferedInputStream bis = new BufferedInputStream((InputStream)in, 0x100000);
        boolean escaped = true;
        boolean thisEof = false;
        while (escaped && !thisEof) {
            int v = bis.read();
            if (v < 0) {
                thisEof = true;
                continue;
            }
            ++pos;
            if (v == this.escapeChar) continue;
            escaped = false;
        }
        boolean endOfRecord = false;
        while (!(!escaped && endOfRecord || thisEof)) {
            int v = bis.read();
            if (v < 0) {
                thisEof = true;
                continue;
            }
            ++pos;
            if (v == this.escapeChar) {
                escaped = true;
                continue;
            }
            if (!escaped) {
                endOfRecord = v == this.lineFeed;
                continue;
            }
            escaped = false;
        }
        in.close();
        return pos;
    }

    private String[] nextValue() {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean escaped = false;
        boolean endOfRecord = false;
        while (!endOfRecord && !this.eof()) {
            boolean endOfField = false;
            this.chars.clear();
            while (!(endOfField || endOfRecord || this.eof())) {
                int v = this.reader().read();
                if (v < 0) {
                    this.eof_$eq(true);
                    continue;
                }
                this.cur_$eq(this.cur() + 1L);
                byte c = (byte)v;
                if (escaped) {
                    if (c != this.escapeChar && c != this.delimiter() && c != this.lineFeed && c != this.carriageReturn) {
                        throw new IllegalStateException(new StringBuilder(25).append("Found `").append(c).append("` (ASCII ").append(v).append(") after ").append(this.escapeChar).append(".").toString());
                    }
                    this.chars.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{c}));
                    escaped = false;
                    continue;
                }
                if (c == this.escapeChar) {
                    escaped = true;
                    continue;
                }
                if (c == this.delimiter()) {
                    endOfField = true;
                    continue;
                }
                if (c == this.lineFeed) {
                    endOfRecord = true;
                    continue;
                }
                this.chars.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{c}));
            }
            fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new String((byte[])this.chars.toArray(ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8"))}));
        }
        if (escaped) {
            throw new IllegalStateException("Found hanging escape char.");
        }
        return (String[])fields.toArray(ClassTag$.MODULE$.apply(String.class));
    }
}

