/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamAnyMatch;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArraysDotStream
extends AJavaparserNodeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamAnyMatch.class);
    private static final String METHOD_ASLIST = "asList";
    private static final String METHOD_STREAM = "stream";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream");
    }

    public boolean isDraft() {
        return false;
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-3631");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("UseArraysStream");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/use-arrays-stream.html";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        Expression filterPredicate;
        boolean useStreamOf;
        if (!(node.getNode() instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node.getNode();
        String methodCallIdentifier = methodCall.getNameAsString();
        if (!METHOD_STREAM.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        if (!(scope instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr scopeAsMethodCallExpr = (MethodCallExpr)scope;
        if (!METHOD_ASLIST.equals(scopeAsMethodCallExpr.getName().getIdentifier())) {
            return false;
        }
        Optional optParentScope = scopeAsMethodCallExpr.getScope();
        if (optParentScope.isEmpty()) {
            return false;
        }
        Expression parentScope = (Expression)optParentScope.get();
        if (!parentScope.isNameExpr()) {
            return false;
        }
        if (!parentScope.asNameExpr().getNameAsString().equals(Arrays.class.getSimpleName())) {
            return false;
        }
        if (scopeAsMethodCallExpr.getArguments().size() != 1) {
            useStreamOf = true;
        } else {
            filterPredicate = scopeAsMethodCallExpr.getArgument(0);
            Optional<ResolvedType> optType = MethodCallExprHelpers.optResolvedType(node.editNode(filterPredicate));
            if (optType.isEmpty()) {
                return false;
            }
            boolean bl = useStreamOf = !optType.get().isArray();
        }
        if (useStreamOf) {
            String methodRefClassName = ImportDeclarationHelpers.getStaticMethodClassRefMayAddImport(node, Stream.class);
            NameExpr nameExpr = new NameExpr(methodRefClassName);
            return this.tryReplace(node, (Node)new MethodCallExpr((Expression)nameExpr, "of", scopeAsMethodCallExpr.getArguments()));
        }
        filterPredicate = scopeAsMethodCallExpr.getArgument(0);
        NodeList replaceArguments = new NodeList((Node[])new Expression[]{filterPredicate});
        MethodCallExpr replacement = new MethodCallExpr(parentScope, METHOD_STREAM, replaceArguments);
        LOGGER.info("Turning {} into {}", (Object)methodCall, (Object)replacement);
        return this.tryReplace((Node)methodCall, (Node)replacement);
    }
}

