/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.resolution.SymbolResolver;
import eu.solven.cleanthat.SuppressCleanthat;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.meta.ICountMutatorIssues;
import eu.solven.cleanthat.engine.java.refactorer.meta.IJavaparserAstMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AJavaparserAstMutator
implements IJavaparserAstMutator,
ICountMutatorIssues {
    private static final Logger LOGGER = LoggerFactory.getLogger(AJavaparserAstMutator.class);
    private static final boolean SIMULATE_BEFORE_EXECUTE = Boolean.getBoolean("cleanthat.simulate_before_execute");
    private final AtomicInteger nbIdempotencyIssues = new AtomicInteger();

    public int getNbIdempotencyIssues() {
        return this.nbIdempotencyIssues.get();
    }

    protected abstract boolean processNotRecursively(NodeAndSymbolSolver<?> var1);

    public Optional<Node> walkAst(Node ast) {
        AtomicBoolean astHasMutated = new AtomicBoolean();
        ast.walk(node -> {
            boolean nodeHasMUtated = this.walkOneNode((Node)node);
            if (nodeHasMUtated) {
                astHasMutated.set(true);
            }
        });
        if (astHasMutated.get()) {
            return Optional.of(ast);
        }
        return Optional.empty();
    }

    private boolean walkOneNode(Node node) {
        if (node.findCompilationUnit().isEmpty()) {
            LOGGER.debug("We skip {} as it or one of its ancestor has been dropped from the AST", (Object)node);
            return false;
        }
        Optional optSuppressedParent = node.findAncestor(n -> n.isAnnotationPresent(SuppressCleanthat.class), new Class[]{NodeWithAnnotations.class});
        Optional optSuppressedChildren = node.findFirst(Node.class, n -> n instanceof NodeWithAnnotations && ((NodeWithAnnotations)n).isAnnotationPresent(SuppressCleanthat.class));
        if (node instanceof NodeWithAnnotations && ((NodeWithAnnotations)node).isAnnotationPresent(SuppressCleanthat.class) || optSuppressedParent.isPresent() || optSuppressedChildren.isPresent()) {
            LOGGER.debug("We skip {} due to {}", (Object)node, (Object)SuppressCleanthat.class.getName());
            return false;
        }
        CompilationUnit compilationUnit = (CompilationUnit)node.findCompilationUnit().get();
        SymbolResolver symbolSolver = node.getSymbolResolver();
        boolean hasTransformedClone = SIMULATE_BEFORE_EXECUTE ? this.simulateOnClone(node, symbolSolver, compilationUnit) : true;
        if (hasTransformedClone) {
            return this.executeOnNode(node, symbolSolver, compilationUnit);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean simulateOnClone(Node node, SymbolResolver symbolSolver, CompilationUnit compilationUnit) {
        boolean hasTransformedClone;
        Optional optParent = node.getParentNode();
        if (optParent.isEmpty()) {
            return false;
        }
        Node parentNode = (Node)optParent.get();
        Optional optGrandParent = parentNode.getParentNode();
        if (optGrandParent.isEmpty()) {
            return false;
        }
        Node clonedParentNode = parentNode.clone();
        this.restoreRealNode(clonedParentNode, optGrandParent, parentNode);
        int indexInParent = this.getIndexInParent(node, parentNode);
        Node clonedNode = (Node)clonedParentNode.getChildNodes().get(indexInParent);
        try {
            NodeAndSymbolSolver<Node> clonedNodeAndSymbolSolver = new NodeAndSymbolSolver<Node>(clonedNode, symbolSolver, compilationUnit, compilationUnit.getPackageDeclaration(), (NodeList<ImportDeclaration>)compilationUnit.getImports());
            try {
                LOGGER.trace("{} is going over {}", (Object)this.getClass().getSimpleName(), PepperLogHelper.getObjectAndClass((Object)clonedNode));
                hasTransformedClone = this.processNotRecursively(clonedNodeAndSymbolSolver);
            }
            catch (RuntimeException e) {
                String rangeInSourceCode = "Around lines: " + node.getTokenRange().map(Object::toString).orElse("-");
                String messageForIssueReporting = AJavaparserAstMutator.messageForIssueReporting((IMutator)this, clonedNode);
                throw new IllegalArgumentException("Issue with a cleanthat mutator. " + rangeInSourceCode + " " + messageForIssueReporting, e);
            }
            boolean nodeEqualsPostClone = node.equals((Object)clonedNode);
            if (hasTransformedClone && nodeEqualsPostClone) {
                LOGGER.warn("{} indicates it mutated `{}` but we observe no change", (Object)this, (Object)node);
            } else if (!hasTransformedClone && !nodeEqualsPostClone) {
                LOGGER.debug("This typically happens as we built MethodCallExpr (changing some parent) but finally discarded the change");
            }
        }
        finally {
            this.restoreRealNode(parentNode, optGrandParent, clonedParentNode);
        }
        return hasTransformedClone;
    }

    private void restoreRealNode(Node parentNode, Optional<Node> optGrandParent, Node clonedParentNode) {
        if (!optGrandParent.get().replace(clonedParentNode, parentNode)) {
            throw new IllegalStateException("Issue replacing Node by its clone");
        }
    }

    private int getIndexInParent(Node node, Node parentNode) {
        int indexInParent = -1;
        for (int i = 0; i < parentNode.getChildNodes().size(); ++i) {
            if (node != parentNode.getChildNodes().get(i)) continue;
            indexInParent = i;
            break;
        }
        if (indexInParent < 0) {
            throw new IllegalStateException("Can not find a child amongst its parent children");
        }
        return indexInParent;
    }

    private boolean executeOnNode(Node node, SymbolResolver symbolSolver, CompilationUnit compilationUnit) {
        boolean hasTransformedNode;
        NodeAndSymbolSolver<Node> nodeAndSymbolSolver = new NodeAndSymbolSolver<Node>(node, symbolSolver, compilationUnit, compilationUnit.getPackageDeclaration(), (NodeList<ImportDeclaration>)compilationUnit.getImports());
        try {
            LOGGER.trace("{} is going over {}", (Object)this.getClass().getSimpleName(), PepperLogHelper.getObjectAndClass((Object)node));
            hasTransformedNode = this.processNotRecursively(nodeAndSymbolSolver);
        }
        catch (RuntimeException e) {
            String rangeInSourceCode = "Around lines: " + node.getTokenRange().map(Object::toString).orElse("-");
            String messageForIssueReporting = AJavaparserAstMutator.messageForIssueReporting((IMutator)this, node);
            throw new IllegalArgumentException("Issue with a cleanthat mutator. " + rangeInSourceCode + " " + messageForIssueReporting, e);
        }
        if (node.findCompilationUnit().isEmpty()) {
            Optional broken = compilationUnit.findFirst(Node.class, n -> n.findCompilationUnit().isEmpty());
            if (broken.isPresent()) {
                LOGGER.warn("{} has corrupted the AST from `{}` around `{}`", new Object[]{this.getClass(), node, broken.get()});
            }
        } else {
            Optional broken = node.findFirst(Node.class, n -> n.findCompilationUnit().isEmpty());
            if (broken.isPresent()) {
                LOGGER.warn("{} has corrupted the AST from `{}` around `{}`", new Object[]{this.getClass(), node, broken.get()});
            }
        }
        if (hasTransformedNode) {
            LOGGER.debug("{} transformed something into `{}`", this.getClass(), (Object)node);
            this.idempotencySanityCheck(nodeAndSymbolSolver);
            return true;
        }
        if (SIMULATE_BEFORE_EXECUTE) {
            LOGGER.warn("A mutation has been rejected while it was accept on a duplicated node");
        }
        return false;
    }

    private void idempotencySanityCheck(NodeAndSymbolSolver<?> nodeAndSymbolSolver) {
        if (this.getIds().contains("NoOp")) {
            return;
        }
        Object node = nodeAndSymbolSolver.getNode();
        if (node.getParentNode().isEmpty()) {
            return;
        }
        if (node.findCompilationUnit().isEmpty()) {
            return;
        }
        boolean transformAgain = this.processNotRecursively(nodeAndSymbolSolver);
        if (transformAgain) {
            this.nbIdempotencyIssues.incrementAndGet();
            String messageForIssueReporting = AJavaparserAstMutator.messageForIssueReporting((IMutator)this, nodeAndSymbolSolver.getNode());
            LOGGER.warn("A mutator is not idem-potent. {}", (Object)messageForIssueReporting);
        }
    }

    public static String messageForIssueReporting(IMutator mutator, Node node) {
        String faultyCode = node.toString();
        String messageForIssueReporting = "\r\n\r\nPlease report it to 'https://github.com/solven-eu/cleanthat/issues' referring the faulty mutator: '" + mutator.getClass().getName() + " with as testCase: \r\n\r\n" + faultyCode;
        return messageForIssueReporting;
    }
}

