/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatMetaProperties;
import eu.solven.cleanthat.config.pojo.SourceCodeProperties;
import eu.solven.cleanthat.github.IHasSourceCodeProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonPropertyOrder(value={"syntax_version", "meta", "source_code", "engines"})
@JsonIgnoreProperties(value={"languages"})
@JsonDeserialize(builder=CleanthatRepositoryPropertiesBuilder.class)
public final class CleanthatRepositoryProperties
implements IHasSourceCodeProperties {
    public static final String PREVIOUS_SYNTAX_VERSION = "2021-08-02";
    public static final String LATEST_SYNTAX_VERSION = "2023-01-09";
    private String syntaxVersion;
    private CleanthatMetaProperties meta;
    private SourceCodeProperties sourceCode;
    private List<CleanthatEngineProperties> engines;

    public static CleanthatRepositoryProperties defaultRepository() {
        CleanthatRepositoryProperties root = CleanthatRepositoryProperties.builder().build();
        root.setSourceCode(SourceCodeProperties.defaultRoot());
        return root;
    }

    private static String $default$syntaxVersion() {
        return LATEST_SYNTAX_VERSION;
    }

    private static CleanthatMetaProperties $default$meta() {
        return CleanthatMetaProperties.builder().build();
    }

    private static SourceCodeProperties $default$sourceCode() {
        return SourceCodeProperties.defaultChild();
    }

    CleanthatRepositoryProperties(String syntaxVersion, CleanthatMetaProperties meta, SourceCodeProperties sourceCode, List<CleanthatEngineProperties> engines) {
        this.syntaxVersion = syntaxVersion;
        this.meta = meta;
        this.sourceCode = sourceCode;
        this.engines = engines;
    }

    public static CleanthatRepositoryPropertiesBuilder builder() {
        return new CleanthatRepositoryPropertiesBuilder();
    }

    public String getSyntaxVersion() {
        return this.syntaxVersion;
    }

    public CleanthatMetaProperties getMeta() {
        return this.meta;
    }

    @Override
    public SourceCodeProperties getSourceCode() {
        return this.sourceCode;
    }

    public List<CleanthatEngineProperties> getEngines() {
        return this.engines;
    }

    public void setSyntaxVersion(String syntaxVersion) {
        this.syntaxVersion = syntaxVersion;
    }

    public void setMeta(CleanthatMetaProperties meta) {
        this.meta = meta;
    }

    public void setSourceCode(SourceCodeProperties sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void setEngines(List<CleanthatEngineProperties> engines) {
        this.engines = engines;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CleanthatRepositoryProperties)) {
            return false;
        }
        CleanthatRepositoryProperties other = (CleanthatRepositoryProperties)o;
        String this$syntaxVersion = this.getSyntaxVersion();
        String other$syntaxVersion = other.getSyntaxVersion();
        if (this$syntaxVersion == null ? other$syntaxVersion != null : !this$syntaxVersion.equals(other$syntaxVersion)) {
            return false;
        }
        CleanthatMetaProperties this$meta = this.getMeta();
        CleanthatMetaProperties other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        SourceCodeProperties this$sourceCode = this.getSourceCode();
        SourceCodeProperties other$sourceCode = other.getSourceCode();
        if (this$sourceCode == null ? other$sourceCode != null : !((Object)this$sourceCode).equals(other$sourceCode)) {
            return false;
        }
        List<CleanthatEngineProperties> this$engines = this.getEngines();
        List<CleanthatEngineProperties> other$engines = other.getEngines();
        return !(this$engines == null ? other$engines != null : !((Object)this$engines).equals(other$engines));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $syntaxVersion = this.getSyntaxVersion();
        result = result * 59 + ($syntaxVersion == null ? 43 : $syntaxVersion.hashCode());
        CleanthatMetaProperties $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        SourceCodeProperties $sourceCode = this.getSourceCode();
        result = result * 59 + ($sourceCode == null ? 43 : ((Object)$sourceCode).hashCode());
        List<CleanthatEngineProperties> $engines = this.getEngines();
        result = result * 59 + ($engines == null ? 43 : ((Object)$engines).hashCode());
        return result;
    }

    public String toString() {
        return "CleanthatRepositoryProperties(syntaxVersion=" + this.getSyntaxVersion() + ", meta=" + this.getMeta() + ", sourceCode=" + this.getSourceCode() + ", engines=" + this.getEngines() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    @JsonPropertyOrder(value={"syntax_version", "meta", "source_code", "engines"})
    @JsonIgnoreProperties(value={"languages"})
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CleanthatRepositoryPropertiesBuilder {
        private boolean syntaxVersion$set;
        private String syntaxVersion$value;
        private boolean meta$set;
        private CleanthatMetaProperties meta$value;
        private boolean sourceCode$set;
        private SourceCodeProperties sourceCode$value;
        private ArrayList<CleanthatEngineProperties> engines;

        CleanthatRepositoryPropertiesBuilder() {
        }

        public CleanthatRepositoryPropertiesBuilder syntaxVersion(String syntaxVersion) {
            this.syntaxVersion$value = syntaxVersion;
            this.syntaxVersion$set = true;
            return this;
        }

        public CleanthatRepositoryPropertiesBuilder meta(CleanthatMetaProperties meta) {
            this.meta$value = meta;
            this.meta$set = true;
            return this;
        }

        public CleanthatRepositoryPropertiesBuilder sourceCode(SourceCodeProperties sourceCode) {
            this.sourceCode$value = sourceCode;
            this.sourceCode$set = true;
            return this;
        }

        public CleanthatRepositoryPropertiesBuilder engine(CleanthatEngineProperties engine) {
            if (this.engines == null) {
                this.engines = new ArrayList();
            }
            this.engines.add(engine);
            return this;
        }

        public CleanthatRepositoryPropertiesBuilder engines(Collection<? extends CleanthatEngineProperties> engines) {
            if (engines == null) {
                throw new NullPointerException("engines cannot be null");
            }
            if (this.engines == null) {
                this.engines = new ArrayList();
            }
            this.engines.addAll(engines);
            return this;
        }

        public CleanthatRepositoryPropertiesBuilder clearEngines() {
            if (this.engines != null) {
                this.engines.clear();
            }
            return this;
        }

        public CleanthatRepositoryProperties build() {
            List<CleanthatEngineProperties> engines;
            switch (this.engines == null ? 0 : this.engines.size()) {
                case 0: {
                    engines = Collections.emptyList();
                    break;
                }
                case 1: {
                    engines = Collections.singletonList(this.engines.get(0));
                    break;
                }
                default: {
                    engines = Collections.unmodifiableList(new ArrayList<CleanthatEngineProperties>(this.engines));
                }
            }
            String syntaxVersion$value = this.syntaxVersion$value;
            if (!this.syntaxVersion$set) {
                syntaxVersion$value = CleanthatRepositoryProperties.$default$syntaxVersion();
            }
            CleanthatMetaProperties meta$value = this.meta$value;
            if (!this.meta$set) {
                meta$value = CleanthatRepositoryProperties.$default$meta();
            }
            SourceCodeProperties sourceCode$value = this.sourceCode$value;
            if (!this.sourceCode$set) {
                sourceCode$value = CleanthatRepositoryProperties.$default$sourceCode();
            }
            return new CleanthatRepositoryProperties(syntaxVersion$value, meta$value, sourceCode$value, engines);
        }

        public String toString() {
            return "CleanthatRepositoryProperties.CleanthatRepositoryPropertiesBuilder(syntaxVersion$value=" + this.syntaxVersion$value + ", meta$value=" + this.meta$value + ", sourceCode$value=" + this.sourceCode$value + ", engines=" + this.engines + ")";
        }
    }
}

