/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.solven.cleanthat.config.IGitService;
import eu.solven.pepper.collection.PepperMapHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;

public class GitService
implements IGitService,
InitializingBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GitService.class);
    private static final String KEY_GIT_COMMIT_ID = "git.commit.id";

    public void afterPropertiesSet() throws IOException {
        this.getProperties().entrySet().forEach(e -> {
            if (KEY_GIT_COMMIT_ID.equals(e.getKey())) {
                LOGGER.info("Git info: {}", e);
            } else {
                LOGGER.debug("Git info: {}", e);
            }
        });
    }

    @Override
    public Map<String, ?> getProperties() throws IOException {
        ClassPathResource resource = new ClassPathResource("/git.json");
        if (!resource.exists()) {
            LOGGER.warn("We failed finding the resource: {}", (Object)resource.getPath());
            resource = new ClassPathResource("/git.fallback.json");
        }
        return (Map)new ObjectMapper().readValue(resource.getInputStream(), Map.class);
    }

    @Override
    public String getSha1() {
        Map<String, ?> properties;
        try {
            properties = this.getProperties();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return PepperMapHelper.getRequiredString(properties, (Object)KEY_GIT_COMMIT_ID, (Object[])new Object[0]);
    }

    public static String safeGetSha1() {
        GitService gitService = new GitService();
        try {
            gitService.afterPropertiesSet();
        }
        catch (IOException e) {
            LOGGER.warn("Issue fetching git.sha1", (Throwable)e);
            return "error";
        }
        return gitService.getSha1();
    }
}

