/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.formatter;

import eu.solven.cleanthat.engine.EngineAndLinters;
import eu.solven.cleanthat.engine.ICodeFormatterApplier;
import eu.solven.cleanthat.formatter.ILintFixer;
import eu.solven.cleanthat.formatter.ILintFixerWithPath;
import eu.solven.cleanthat.formatter.PathAndContent;
import eu.solven.cleanthat.language.IEngineProperties;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeFormatterApplier
implements ICodeFormatterApplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeFormatterApplier.class);
    public static final AtomicInteger NB_EXCEPTIONS = new AtomicInteger();

    @Override
    public String applyProcessors(EngineAndLinters engineAndSteps, PathAndContent pathAndContent) throws IOException {
        String code = pathAndContent.getContent();
        Path filepath = pathAndContent.getPath();
        AtomicReference<String> outputRef = new AtomicReference<String>(code);
        IEngineProperties engineProperties = engineAndSteps.getEngineProperties();
        engineAndSteps.getLinters().forEach(linter -> {
            try {
                String output = this.applyProcessor(engineProperties, (ILintFixer)linter, pathAndContent);
                if (output == null) {
                    throw new IllegalStateException("Null code.");
                }
                String input = (String)outputRef.get();
                if (!input.equals(output)) {
                    LOGGER.debug("Mutated a file given: {}", linter);
                    outputRef.set(output);
                }
            }
            catch (IOException | RuntimeException e) {
                NB_EXCEPTIONS.incrementAndGet();
                LOGGER.warn("Issue over file='" + filepath + "' with linter=" + linter + " in engine={}. Please report it to: https://github.com/solven-eu/cleanthat/issues", (Object)engineProperties.getEngine(), (Object)e);
            }
        });
        return outputRef.get();
    }

    protected String applyProcessor(IEngineProperties engineProperties, ILintFixer lintFixer, PathAndContent pathAndContent) throws IOException {
        Objects.requireNonNull(pathAndContent, "pathAndContent should not be null");
        if (lintFixer instanceof ILintFixerWithPath) {
            return ((ILintFixerWithPath)lintFixer).doFormat(pathAndContent);
        }
        return lintFixer.doFormat(pathAndContent.getContent());
    }
}

