/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script.runtime;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPluginContext;
import jadx.plugins.script.runtime.data.JadxScriptAllOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Ljadx/plugins/script/runtime/JadxScriptData;", "", "jadxInstance", "Ljadx/api/JadxDecompiler;", "pluginContext", "Ljadx/api/plugins/JadxPluginContext;", "options", "Ljadx/plugins/script/runtime/data/JadxScriptAllOptions;", "scriptFile", "Ljava/io/File;", "(Ljadx/api/JadxDecompiler;Ljadx/api/plugins/JadxPluginContext;Ljadx/plugins/script/runtime/data/JadxScriptAllOptions;Ljava/io/File;)V", "afterLoad", "", "Lkotlin/Function0;", "", "getAfterLoad", "()Ljava/util/List;", "error", "", "getError", "()Z", "setError", "(Z)V", "getJadxInstance", "()Ljadx/api/JadxDecompiler;", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "getLog", "()Lio/github/oshai/kotlinlogging/KLogger;", "getOptions", "()Ljadx/plugins/script/runtime/data/JadxScriptAllOptions;", "getPluginContext", "()Ljadx/api/plugins/JadxPluginContext;", "getScriptFile", "()Ljava/io/File;", "scriptName", "", "getScriptName", "()Ljava/lang/String;", "jadx-script-runtime"})
public final class JadxScriptData {
    @NotNull
    private final JadxDecompiler jadxInstance;
    @NotNull
    private final JadxPluginContext pluginContext;
    @NotNull
    private final JadxScriptAllOptions options;
    @NotNull
    private final File scriptFile;
    @NotNull
    private final String scriptName;
    @NotNull
    private final KLogger log;
    @NotNull
    private final List<Function0<Unit>> afterLoad;
    private boolean error;

    public JadxScriptData(@NotNull JadxDecompiler jadxInstance, @NotNull JadxPluginContext pluginContext, @NotNull JadxScriptAllOptions options2, @NotNull File scriptFile) {
        Intrinsics.checkNotNullParameter((Object)jadxInstance, (String)"jadxInstance");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        this.jadxInstance = jadxInstance;
        this.pluginContext = pluginContext;
        this.options = options2;
        this.scriptFile = scriptFile;
        String string = this.scriptFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.scriptName = StringsKt.removeSuffix((String)string, (CharSequence)".jadx.kts");
        this.log = KotlinLogging.INSTANCE.logger("JadxScript:" + this.scriptName);
        this.afterLoad = new ArrayList();
    }

    @NotNull
    public final JadxDecompiler getJadxInstance() {
        return this.jadxInstance;
    }

    @NotNull
    public final JadxPluginContext getPluginContext() {
        return this.pluginContext;
    }

    @NotNull
    public final JadxScriptAllOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final File getScriptFile() {
        return this.scriptFile;
    }

    @NotNull
    public final String getScriptName() {
        return this.scriptName;
    }

    @NotNull
    public final KLogger getLog() {
        return this.log;
    }

    @NotNull
    public final List<Function0<Unit>> getAfterLoad() {
        return this.afterLoad;
    }

    public final boolean getError() {
        return this.error;
    }

    public final void setError(boolean bl) {
        this.error = bl;
    }
}

