/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script;

import io.github.oshai.kotlinlogging.KLogger;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPluginContext;
import jadx.plugins.script.ScriptCache;
import jadx.plugins.script.ScriptEval$buildCompileConf$;
import jadx.plugins.script.ScriptEval$buildEvalConf$;
import jadx.plugins.script.runtime.JadxScriptData;
import jadx.plugins.script.runtime.JadxScriptTemplate;
import jadx.plugins.script.runtime.data.JadxScriptAllOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.EvaluationResult;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ResultValue;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationConfigurationKeys;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.host.ConfigurationFromTemplateKt;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.host.ScriptingHostConfigurationKeys;
import kotlin.script.experimental.jvm.JvmScriptCachingKt;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationBuilder;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKeys;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.script.experimental.jvmhost.BasicJvmScriptingHost;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u001e\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u001a"}, d2={"Ljadx/plugins/script/ScriptEval;", "", "<init>", "()V", "process", "", "Ljadx/plugins/script/runtime/JadxScriptData;", "context", "Ljadx/api/plugins/JadxPluginContext;", "scriptOptions", "Ljadx/plugins/script/runtime/data/JadxScriptAllOptions;", "eval", "", "scriptingHost", "Lkotlin/script/experimental/jvmhost/BasicJvmScriptingHost;", "compileConf", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "scriptData", "processEvalResult", "res", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lkotlin/script/experimental/api/EvaluationResult;", "buildScriptingHost", "buildCompileConf", "buildEvalConf", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "jadx-script-plugin"})
@SourceDebugExtension(value={"SMAP\nScriptEval.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptEval.kt\njadx/plugins/script/ScriptEval\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 BasicJvmScriptingHost.kt\nkotlin/script/experimental/jvmhost/BasicJvmScriptingHostKt\n*L\n1#1,103:1\n774#2:104\n865#2,2:105\n29#3,3:107\n33#4,9:110\n43#4,9:119\n*S KotlinDebug\n*F\n+ 1 ScriptEval.kt\njadx/plugins/script/ScriptEval\n*L\n29#1:104\n29#1:105,2\n51#1:107,3\n94#1:110,9\n97#1:119,9\n*E\n"})
public final class ScriptEval {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JadxScriptData> process(@NotNull JadxPluginContext context, @NotNull JadxScriptAllOptions scriptOptions) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scriptOptions, (String)"scriptOptions");
        JadxDecompiler jadx = context.getDecompiler();
        List list = jadx.getArgs().getInputFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputFiles(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File f = (File)element$iv$iv;
            boolean bl = false;
            String string = f.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".jadx.kts", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scripts = (List)destination$iv$iv;
        if (scripts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        BasicJvmScriptingHost scriptingHost = this.buildScriptingHost(context);
        ScriptCompilationConfiguration compileConf = this.buildCompileConf();
        List scriptDataList = new ArrayList();
        for (File scriptFile : scripts) {
            Intrinsics.checkNotNull((Object)jadx);
            Intrinsics.checkNotNull((Object)scriptFile);
            JadxScriptData scriptData = new JadxScriptData(jadx, context, scriptOptions, scriptFile);
            scriptDataList.add(scriptData);
            this.eval(scriptingHost, compileConf, scriptData);
        }
        return scriptDataList;
    }

    private final void eval(BasicJvmScriptingHost scriptingHost, ScriptCompilationConfiguration compileConf, JadxScriptData scriptData) {
        scriptData.getLog().debug(() -> ScriptEval.eval$lambda$1(scriptData));
        ScriptEvaluationConfiguration evalConf = this.buildEvalConf(scriptData);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ResultWithDiagnostics result = scriptingHost.eval(ScriptHostUtilKt.toScriptSource((File)scriptData.getScriptFile()), compileConf, evalConf);
        this.processEvalResult((ResultWithDiagnostics<EvaluationResult>)result, scriptData);
        long execTime = System.currentTimeMillis() - start$iv;
        scriptData.getLog().debug(() -> ScriptEval.eval$lambda$3(scriptData, execTime));
    }

    private final void processEvalResult(ResultWithDiagnostics<EvaluationResult> res, JadxScriptData scriptData) {
        KLogger log = scriptData.getLog();
        block6: for (ScriptDiagnostic r : res.getReports()) {
            String msg = ScriptDiagnostic.render$default((ScriptDiagnostic)r, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)14, null);
            switch (WhenMappings.$EnumSwitchMapping$0[r.getSeverity().ordinal()]) {
                case 1: 
                case 2: {
                    log.error(r.getException(), () -> ScriptEval.processEvalResult$lambda$4(msg));
                    continue block6;
                }
                case 3: {
                    log.warn(() -> ScriptEval.processEvalResult$lambda$5(msg));
                    continue block6;
                }
                case 4: {
                    log.info(() -> ScriptEval.processEvalResult$lambda$6(msg));
                    continue block6;
                }
                case 5: {
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterator iterator = res;
        if (iterator instanceof ResultWithDiagnostics.Success) {
            ResultValue retVal = ((EvaluationResult)((ResultWithDiagnostics.Success)res).getValue()).getReturnValue();
            if (retVal instanceof ResultValue.Error) {
                log.error(((ResultValue.Error)retVal).getError(), ScriptEval::processEvalResult$lambda$7);
            } else if (retVal instanceof ResultValue.Value) {
                log.info(() -> ScriptEval.processEvalResult$lambda$8(retVal));
            } else if (!(retVal instanceof ResultValue.Unit) && !Intrinsics.areEqual((Object)retVal, (Object)ResultValue.NotEvaluated.INSTANCE)) {
                throw new NoWhenBranchMatchedException();
            }
        } else if (iterator instanceof ResultWithDiagnostics.Failure) {
            scriptData.setError(true);
            log.error(() -> ScriptEval.processEvalResult$lambda$9(scriptData));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final BasicJvmScriptingHost buildScriptingHost(@NotNull JadxPluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new BasicJvmScriptingHost(new ScriptingHostConfiguration(arg_0 -> ScriptEval.buildScriptingHost$lambda$11(context, arg_0)), null, null, 6, null);
    }

    @NotNull
    public final ScriptCompilationConfiguration buildCompileConf() {
        ScriptingHostConfiguration baseHostConfiguration$iv = null;
        Function1 body$iv = buildCompileConf$$inlined$createJvmCompilationConfigurationFromTemplate$default$1.INSTANCE;
        boolean $i$f$createJvmCompilationConfigurationFromTemplate = false;
        return ConfigurationFromTemplateKt.createCompilationConfigurationFromTemplate((KotlinType)new KotlinType(Reflection.getOrCreateKotlinClass(JadxScriptTemplate.class), false, 2, null), (ScriptingHostConfiguration)HostConfigurationKt.withDefaultsFrom(baseHostConfiguration$iv, (ScriptingHostConfiguration)JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()), (KClass)Reflection.getOrCreateKotlinClass(ScriptCompilationConfiguration.class), (Function1)body$iv);
    }

    @NotNull
    public final ScriptEvaluationConfiguration buildEvalConf(@NotNull JadxScriptData scriptData) {
        Intrinsics.checkNotNullParameter((Object)scriptData, (String)"scriptData");
        ScriptingHostConfiguration baseHostConfiguration$iv = null;
        Function1 body$iv = buildEvalConf$$inlined$createJvmEvaluationConfigurationFromTemplate$default$1.INSTANCE;
        boolean $i$f$createJvmEvaluationConfigurationFromTemplate = false;
        ScriptEvaluationConfiguration baseEvalConf = ConfigurationFromTemplateKt.createEvaluationConfigurationFromTemplate((KotlinType)new KotlinType(Reflection.getOrCreateKotlinClass(JadxScriptTemplate.class), false, 2, null), (ScriptingHostConfiguration)HostConfigurationKt.withDefaultsFrom(baseHostConfiguration$iv, (ScriptingHostConfiguration)JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()), (KClass)Reflection.getOrCreateKotlinClass(ScriptEvaluationConfiguration.class), (Function1)body$iv);
        ScriptEvaluationConfiguration[] scriptEvaluationConfigurationArray = new ScriptEvaluationConfiguration[]{baseEvalConf};
        return new ScriptEvaluationConfiguration(scriptEvaluationConfigurationArray, arg_0 -> ScriptEval.buildEvalConf$lambda$12(scriptData, arg_0));
    }

    private static final Object eval$lambda$1(JadxScriptData $scriptData) {
        return "Loading script: " + $scriptData.getScriptFile().getAbsolutePath();
    }

    private static final Object eval$lambda$3(JadxScriptData $scriptData, long $execTime) {
        return "Script '" + $scriptData.getScriptName() + "' executed in " + Duration.toString-impl((long)DurationKt.toDuration((long)$execTime, (DurationUnit)DurationUnit.MILLISECONDS));
    }

    private static final Object processEvalResult$lambda$4(String $msg) {
        return "Script execution error: " + $msg;
    }

    private static final Object processEvalResult$lambda$5(String $msg) {
        return "Script execution issue: " + $msg;
    }

    private static final Object processEvalResult$lambda$6(String $msg) {
        return "Script report: " + $msg;
    }

    private static final Object processEvalResult$lambda$7() {
        return "Script execution error:";
    }

    private static final Object processEvalResult$lambda$8(ResultValue $retVal) {
        return "Script execution result: " + $retVal;
    }

    private static final Object processEvalResult$lambda$9(JadxScriptData $scriptData) {
        return "Script execution failed: " + $scriptData.getScriptName();
    }

    private static final Unit buildScriptingHost$lambda$11$lambda$10(JadxPluginContext $context, JvmScriptingHostConfigurationBuilder $this$jvm) {
        Intrinsics.checkNotNullParameter((Object)$this$jvm, (String)"$this$jvm");
        $this$jvm.invoke(JvmScriptCachingKt.getCompilationCache((JvmScriptingHostConfigurationKeys)((JvmScriptingHostConfigurationKeys)$this$jvm)), (Object)new ScriptCache().build($context));
        return Unit.INSTANCE;
    }

    private static final Unit buildScriptingHost$lambda$11(JadxPluginContext $context, ScriptingHostConfiguration.Builder $this$ScriptingHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptingHostConfiguration, (String)"$this$ScriptingHostConfiguration");
        $this$ScriptingHostConfiguration.invoke((PropertiesCollection.Builder)JvmScriptingHostConfigurationKt.getJvm((ScriptingHostConfigurationKeys)((ScriptingHostConfigurationKeys)$this$ScriptingHostConfiguration)), arg_0 -> ScriptEval.buildScriptingHost$lambda$11$lambda$10($context, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit buildEvalConf$lambda$12(JadxScriptData $scriptData, ScriptEvaluationConfiguration.Builder $this$ScriptEvaluationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptEvaluationConfiguration, (String)"$this$ScriptEvaluationConfiguration");
        Object[] objectArray = new JadxScriptData[]{$scriptData};
        $this$ScriptEvaluationConfiguration.invoke(ScriptEvaluationKt.getConstructorArgs((ScriptEvaluationConfigurationKeys)((ScriptEvaluationConfigurationKeys)$this$ScriptEvaluationConfiguration)), objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

