/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script;

import io.github.oshai.kotlinlogging.KLogger;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPluginContext;
import jadx.plugins.script.ScriptCache;
import jadx.plugins.script.ScriptEval$special$;
import jadx.plugins.script.runtime.JadxScriptData;
import jadx.plugins.script.runtime.JadxScriptTemplate;
import jadx.plugins.script.runtime.data.JadxScriptAllOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.api.CompiledScript;
import kotlin.script.experimental.api.EvaluationResult;
import kotlin.script.experimental.api.KotlinType;
import kotlin.script.experimental.api.ResultValue;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationConfigurationKeys;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ConfigurationFromTemplateKt;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.host.ScriptingHostConfigurationKeys;
import kotlin.script.experimental.jvm.JvmScriptCachingKt;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationBuilder;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKeys;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.script.experimental.jvmhost.BasicJvmScriptingHost;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u001e\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Ljadx/plugins/script/ScriptEval;", "", "<init>", "()V", "process", "", "Ljadx/plugins/script/runtime/JadxScriptData;", "init", "Ljadx/api/plugins/JadxPluginContext;", "scriptOptions", "Ljadx/plugins/script/runtime/data/JadxScriptAllOptions;", "compile", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lkotlin/script/experimental/api/CompiledScript;", "script", "Lkotlin/script/experimental/api/SourceCode;", "(Lkotlin/script/experimental/api/SourceCode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "eval", "", "scriptData", "processEvalResult", "res", "Lkotlin/script/experimental/api/EvaluationResult;", "Companion", "jadx-script-plugin"})
@SourceDebugExtension(value={"SMAP\nScriptEval.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptEval.kt\njadx/plugins/script/ScriptEval\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 BasicJvmScriptingHost.kt\nkotlin/script/experimental/jvmhost/BasicJvmScriptingHostKt\n*L\n1#1,107:1\n774#2:108\n865#2,2:109\n17#3,6:111\n33#4,9:117\n43#4,9:126\n*S KotlinDebug\n*F\n+ 1 ScriptEval.kt\njadx/plugins/script/ScriptEval\n*L\n49#1:108\n49#1:109,2\n68#1:111,6\n37#1:117,9\n39#1:126,9\n*E\n"})
public final class ScriptEval {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BasicJvmScriptingHost scriptingHost = new BasicJvmScriptingHost(new ScriptingHostConfiguration(ScriptEval::scriptingHost$lambda$11), null, null, 6, null);
    @NotNull
    private static final ScriptCompilationConfiguration compileConf;
    @NotNull
    private static final ScriptEvaluationConfiguration baseEvalConf;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JadxScriptData> process(@NotNull JadxPluginContext init, @NotNull JadxScriptAllOptions scriptOptions) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        Intrinsics.checkNotNullParameter((Object)scriptOptions, (String)"scriptOptions");
        JadxDecompiler jadx = init.getDecompiler();
        List list = jadx.getArgs().getInputFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputFiles(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File f = (File)element$iv$iv;
            boolean bl = false;
            String string = f.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".jadx.kts", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scripts = (List)destination$iv$iv;
        if (scripts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List scriptDataList = new ArrayList();
        for (File scriptFile : scripts) {
            Intrinsics.checkNotNull((Object)jadx);
            Intrinsics.checkNotNull((Object)scriptFile);
            JadxScriptData scriptData = new JadxScriptData(jadx, init, scriptOptions, scriptFile);
            scriptDataList.add(scriptData);
            this.eval(scriptData);
        }
        return scriptDataList;
    }

    @Nullable
    public final Object compile(@NotNull SourceCode script, @NotNull Continuation<? super ResultWithDiagnostics<? extends CompiledScript>> $completion) {
        return scriptingHost.getCompiler().invoke(script, compileConf, $completion);
    }

    private final void eval(JadxScriptData scriptData) {
        scriptData.getLog().debug(() -> ScriptEval.eval$lambda$1(scriptData));
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ResultWithDiagnostics result = scriptingHost.eval(ScriptHostUtilKt.toScriptSource((File)scriptData.getScriptFile()), compileConf, ScriptEval.Companion.buildEvalConf(scriptData));
        this.processEvalResult((ResultWithDiagnostics<EvaluationResult>)result, scriptData);
        long execTime = System.currentTimeMillis() - start$iv;
        scriptData.getLog().debug(() -> ScriptEval.eval$lambda$3(scriptData, execTime));
    }

    private final void processEvalResult(ResultWithDiagnostics<EvaluationResult> res, JadxScriptData scriptData) {
        KLogger log = scriptData.getLog();
        block6: for (ScriptDiagnostic r : res.getReports()) {
            String msg = ScriptDiagnostic.render$default((ScriptDiagnostic)r, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)14, null);
            switch (WhenMappings.$EnumSwitchMapping$0[r.getSeverity().ordinal()]) {
                case 1: 
                case 2: {
                    log.error(r.getException(), () -> ScriptEval.processEvalResult$lambda$4(msg));
                    continue block6;
                }
                case 3: {
                    log.warn(() -> ScriptEval.processEvalResult$lambda$5(msg));
                    continue block6;
                }
                case 4: {
                    log.info(() -> ScriptEval.processEvalResult$lambda$6(msg));
                    continue block6;
                }
                case 5: {
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        Iterator iterator = res;
        if (iterator instanceof ResultWithDiagnostics.Success) {
            ResultValue retVal = ((EvaluationResult)((ResultWithDiagnostics.Success)res).getValue()).getReturnValue();
            if (retVal instanceof ResultValue.Error) {
                log.error(((ResultValue.Error)retVal).getError(), ScriptEval::processEvalResult$lambda$7);
            } else if (retVal instanceof ResultValue.Value) {
                log.info(() -> ScriptEval.processEvalResult$lambda$8(retVal));
            } else if (!(retVal instanceof ResultValue.Unit) && !Intrinsics.areEqual((Object)retVal, (Object)ResultValue.NotEvaluated.INSTANCE)) {
                throw new NoWhenBranchMatchedException();
            }
        } else if (iterator instanceof ResultWithDiagnostics.Failure) {
            scriptData.setError(true);
            log.error(() -> ScriptEval.processEvalResult$lambda$9(scriptData));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final Object eval$lambda$1(JadxScriptData $scriptData) {
        return "Loading script: " + $scriptData.getScriptFile().getAbsolutePath();
    }

    private static final Object eval$lambda$3(JadxScriptData $scriptData, long $execTime) {
        return "Script '" + $scriptData.getScriptName() + "' executed in " + Duration.toString-impl((long)DurationKt.toDuration((long)$execTime, (DurationUnit)DurationUnit.MILLISECONDS));
    }

    private static final Object processEvalResult$lambda$4(String $msg) {
        return "Script execution error: " + $msg;
    }

    private static final Object processEvalResult$lambda$5(String $msg) {
        return "Script execution issue: " + $msg;
    }

    private static final Object processEvalResult$lambda$6(String $msg) {
        return "Script report: " + $msg;
    }

    private static final Object processEvalResult$lambda$7() {
        return "Script execution error:";
    }

    private static final Object processEvalResult$lambda$8(ResultValue $retVal) {
        return "Script execution result: " + $retVal;
    }

    private static final Object processEvalResult$lambda$9(JadxScriptData $scriptData) {
        return "Script execution failed: " + $scriptData.getScriptName();
    }

    private static final Unit scriptingHost$lambda$11$lambda$10(JvmScriptingHostConfigurationBuilder $this$jvm) {
        Intrinsics.checkNotNullParameter((Object)$this$jvm, (String)"$this$jvm");
        $this$jvm.invoke(JvmScriptCachingKt.getCompilationCache((JvmScriptingHostConfigurationKeys)((JvmScriptingHostConfigurationKeys)$this$jvm)), (Object)new ScriptCache().build());
        return Unit.INSTANCE;
    }

    private static final Unit scriptingHost$lambda$11(ScriptingHostConfiguration.Builder $this$ScriptingHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptingHostConfiguration, (String)"$this$ScriptingHostConfiguration");
        $this$ScriptingHostConfiguration.invoke((PropertiesCollection.Builder)JvmScriptingHostConfigurationKt.getJvm((ScriptingHostConfigurationKeys)((ScriptingHostConfigurationKeys)$this$ScriptingHostConfiguration)), ScriptEval::scriptingHost$lambda$11$lambda$10);
        return Unit.INSTANCE;
    }

    static {
        ScriptingHostConfiguration baseHostConfiguration$iv = null;
        Function1 body$iv = special$$inlined$createJvmCompilationConfigurationFromTemplate$default$1.INSTANCE;
        boolean $i$f$createJvmCompilationConfigurationFromTemplate = false;
        compileConf = ConfigurationFromTemplateKt.createCompilationConfigurationFromTemplate((KotlinType)new KotlinType(Reflection.getOrCreateKotlinClass(JadxScriptTemplate.class), false, 2, null), (ScriptingHostConfiguration)HostConfigurationKt.withDefaultsFrom(baseHostConfiguration$iv, (ScriptingHostConfiguration)JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()), (KClass)Reflection.getOrCreateKotlinClass(ScriptCompilationConfiguration.class), (Function1)body$iv);
        baseHostConfiguration$iv = null;
        body$iv = special$$inlined$createJvmEvaluationConfigurationFromTemplate$default$1.INSTANCE;
        boolean $i$f$createJvmEvaluationConfigurationFromTemplate = false;
        baseEvalConf = ConfigurationFromTemplateKt.createEvaluationConfigurationFromTemplate((KotlinType)new KotlinType(Reflection.getOrCreateKotlinClass(JadxScriptTemplate.class), false, 2, null), (ScriptingHostConfiguration)HostConfigurationKt.withDefaultsFrom(baseHostConfiguration$iv, (ScriptingHostConfiguration)JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()), (KClass)Reflection.getOrCreateKotlinClass(ScriptEvaluationConfiguration.class), (Function1)body$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljadx/plugins/script/ScriptEval$Companion;", "", "<init>", "()V", "scriptingHost", "Lkotlin/script/experimental/jvmhost/BasicJvmScriptingHost;", "getScriptingHost", "()Lkotlin/script/experimental/jvmhost/BasicJvmScriptingHost;", "compileConf", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getCompileConf", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "baseEvalConf", "Lkotlin/script/experimental/api/ScriptEvaluationConfiguration;", "buildEvalConf", "scriptData", "Ljadx/plugins/script/runtime/JadxScriptData;", "jadx-script-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BasicJvmScriptingHost getScriptingHost() {
            return scriptingHost;
        }

        @NotNull
        public final ScriptCompilationConfiguration getCompileConf() {
            return compileConf;
        }

        private final ScriptEvaluationConfiguration buildEvalConf(JadxScriptData scriptData) {
            ScriptEvaluationConfiguration[] scriptEvaluationConfigurationArray = new ScriptEvaluationConfiguration[]{baseEvalConf};
            return new ScriptEvaluationConfiguration(scriptEvaluationConfigurationArray, arg_0 -> Companion.buildEvalConf$lambda$0(scriptData, arg_0));
        }

        private static final Unit buildEvalConf$lambda$0(JadxScriptData $scriptData, ScriptEvaluationConfiguration.Builder $this$ScriptEvaluationConfiguration) {
            Intrinsics.checkNotNullParameter((Object)$this$ScriptEvaluationConfiguration, (String)"$this$ScriptEvaluationConfiguration");
            Object[] objectArray = new JadxScriptData[]{$scriptData};
            $this$ScriptEvaluationConfiguration.invoke(ScriptEvaluationKt.getConstructorArgs((ScriptEvaluationConfigurationKeys)((ScriptEvaluationConfigurationKeys)$this$ScriptEvaluationConfiguration)), objectArray);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

