/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.plugins.tools.JadxPluginsTools;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxExternalPluginsLoader
implements JadxPluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JadxExternalPluginsLoader.class);
    private final List<URLClassLoader> classLoaders = new ArrayList<URLClassLoader>();

    public List<JadxPlugin> load() {
        this.close();
        long start = System.currentTimeMillis();
        HashMap<Class<? extends JadxPlugin>, JadxPlugin> map = new HashMap<Class<? extends JadxPlugin>, JadxPlugin>();
        this.loadFromClsLoader(map, JadxExternalPluginsLoader.thisClassLoader());
        this.loadInstalledPlugins(map);
        ArrayList<JadxPlugin> list = new ArrayList<JadxPlugin>(map.size());
        list.addAll(map.values());
        list.sort(Comparator.comparing(p -> p.getClass().getSimpleName()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collected {} plugins in {}ms", (Object)list.size(), (Object)(System.currentTimeMillis() - start));
        }
        return list;
    }

    public JadxPlugin loadFromJar(Path jar) {
        HashMap<Class<? extends JadxPlugin>, JadxPlugin> map = new HashMap<Class<? extends JadxPlugin>, JadxPlugin>();
        this.loadFromJar(map, jar);
        int loaded = map.size();
        if (loaded == 0) {
            throw new JadxRuntimeException("No plugin found in jar: " + String.valueOf(jar));
        }
        if (loaded > 1) {
            String plugins = map.values().stream().map(p -> p.getPluginInfo().getPluginId()).collect(Collectors.joining(", "));
            throw new JadxRuntimeException("Expect only one plugin per jar: " + String.valueOf(jar) + ", but found: " + loaded + " - " + plugins);
        }
        return (JadxPlugin)Utils.first(map.values());
    }

    private void loadFromClsLoader(Map<Class<? extends JadxPlugin>, JadxPlugin> map, ClassLoader classLoader) {
        ServiceLoader.load(JadxPlugin.class, classLoader).stream().filter(p -> p.type().getClassLoader() == classLoader).filter(p -> !map.containsKey(p.type())).forEach(p -> map.put(p.type(), (JadxPlugin)p.get()));
    }

    private void loadInstalledPlugins(Map<Class<? extends JadxPlugin>, JadxPlugin> map) {
        List<Path> jars = JadxPluginsTools.getInstance().getEnabledPluginJars();
        for (Path jar : jars) {
            this.loadFromJar(map, jar);
        }
    }

    private void loadFromJar(Map<Class<? extends JadxPlugin>, JadxPlugin> map, Path jar) {
        try {
            File jarFile = jar.toFile();
            String clsLoaderName = "jadx-plugin:" + jarFile.getName();
            URL[] urls = new URL[]{jarFile.toURI().toURL()};
            URLClassLoader pluginClsLoader = new URLClassLoader(clsLoaderName, urls, JadxExternalPluginsLoader.thisClassLoader());
            this.classLoaders.add(pluginClsLoader);
            this.loadFromClsLoader(map, pluginClsLoader);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to load plugins from jar: " + String.valueOf(jar), (Throwable)e);
        }
    }

    private static ClassLoader thisClassLoader() {
        return JadxExternalPluginsLoader.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            for (URLClassLoader classLoader : this.classLoaders) {
                try {
                    classLoader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.classLoaders.clear();
        }
    }
}

