/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginInfo;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.tools.JadxExternalPluginsLoader;
import jadx.plugins.tools.data.JadxInstalledPlugins;
import jadx.plugins.tools.data.JadxPluginMetadata;
import jadx.plugins.tools.data.JadxPluginUpdate;
import jadx.plugins.tools.resolvers.IJadxPluginResolver;
import jadx.plugins.tools.resolvers.ResolversRegistry;
import jadx.plugins.tools.utils.PluginFiles;
import jadx.plugins.tools.utils.PluginUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class JadxPluginsTools {
    private static final JadxPluginsTools INSTANCE = new JadxPluginsTools();

    public static JadxPluginsTools getInstance() {
        return INSTANCE;
    }

    private JadxPluginsTools() {
    }

    public JadxPluginMetadata install(String locationId) {
        JadxPluginMetadata pluginMetadata = this.resolveMetadata(locationId);
        this.install(pluginMetadata);
        return pluginMetadata;
    }

    public JadxPluginMetadata resolveMetadata(String locationId) {
        JadxPluginMetadata pluginMetadata = ResolversRegistry.resolve(locationId).orElseThrow(() -> new RuntimeException("Failed to resolve locationId: " + locationId));
        this.fillMetadata(pluginMetadata);
        return pluginMetadata;
    }

    public List<JadxPluginUpdate> updateAll() {
        JadxInstalledPlugins plugins = this.loadPluginsJson();
        int size = plugins.getInstalled().size();
        ArrayList<JadxPluginUpdate> updates = new ArrayList<JadxPluginUpdate>(size);
        ArrayList<JadxPluginMetadata> newList = new ArrayList<JadxPluginMetadata>(size);
        for (JadxPluginMetadata plugin : plugins.getInstalled()) {
            JadxPluginMetadata newVersion = this.update(plugin);
            if (newVersion != null) {
                updates.add(new JadxPluginUpdate(plugin, newVersion));
                newList.add(newVersion);
                continue;
            }
            newList.add(plugin);
        }
        if (!updates.isEmpty()) {
            plugins.setUpdated(System.currentTimeMillis());
            plugins.setInstalled(newList);
            this.savePluginsJson(plugins);
        }
        return updates;
    }

    public Optional<JadxPluginUpdate> update(String pluginId) {
        JadxInstalledPlugins plugins = this.loadPluginsJson();
        JadxPluginMetadata plugin = plugins.getInstalled().stream().filter(p -> p.getPluginId().equals(pluginId)).findFirst().orElseThrow(() -> new RuntimeException("Plugin not found: " + pluginId));
        JadxPluginMetadata newVersion = this.update(plugin);
        if (newVersion == null) {
            return Optional.empty();
        }
        plugins.setUpdated(System.currentTimeMillis());
        plugins.getInstalled().remove(plugin);
        plugins.getInstalled().add(newVersion);
        this.savePluginsJson(plugins);
        return Optional.of(new JadxPluginUpdate(plugin, newVersion));
    }

    public boolean uninstall(String pluginId) {
        JadxInstalledPlugins plugins = this.loadPluginsJson();
        Optional<JadxPluginMetadata> found = plugins.getInstalled().stream().filter(p -> p.getPluginId().equals(pluginId)).findFirst();
        if (found.isEmpty()) {
            return false;
        }
        JadxPluginMetadata plugin = found.get();
        this.deletePluginJar(plugin);
        plugins.getInstalled().remove(plugin);
        this.savePluginsJson(plugins);
        return true;
    }

    public List<JadxPluginMetadata> getInstalled() {
        return this.loadPluginsJson().getInstalled();
    }

    public List<Path> getAllPluginJars() {
        ArrayList<Path> list = new ArrayList<Path>();
        for (JadxPluginMetadata pluginMetadata : this.loadPluginsJson().getInstalled()) {
            list.add(PluginFiles.INSTALLED_DIR.resolve(pluginMetadata.getJar()));
        }
        JadxPluginsTools.collectFromDir(list, PluginFiles.DROPINS_DIR);
        return list;
    }

    @Nullable
    private JadxPluginMetadata update(JadxPluginMetadata plugin) {
        IJadxPluginResolver resolver = ResolversRegistry.getById(plugin.getResolverId());
        if (!resolver.isUpdateSupported()) {
            return null;
        }
        Optional<JadxPluginMetadata> updateOpt = resolver.resolve(plugin.getLocationId());
        if (updateOpt.isEmpty()) {
            return null;
        }
        JadxPluginMetadata update = updateOpt.get();
        if (Objects.equals(update.getVersion(), plugin.getVersion())) {
            return null;
        }
        this.fillMetadata(update);
        this.install(update);
        return update;
    }

    public void install(JadxPluginMetadata metadata) {
        String version = metadata.getVersion();
        String fileName = metadata.getPluginId() + (String)(version != null ? "-" + version : "") + ".jar";
        Path pluginJar = PluginFiles.INSTALLED_DIR.resolve(fileName);
        this.copyJar(Paths.get(metadata.getJar(), new String[0]), pluginJar);
        metadata.setJar(PluginFiles.INSTALLED_DIR.relativize(pluginJar).toString());
        JadxInstalledPlugins plugins = this.loadPluginsJson();
        plugins.getInstalled().stream().filter(p -> p.getPluginId().equals(metadata.getPluginId())).forEach(this::deletePluginJar);
        plugins.getInstalled().remove(metadata);
        plugins.getInstalled().add(metadata);
        plugins.setUpdated(System.currentTimeMillis());
        this.savePluginsJson(plugins);
    }

    private void fillMetadata(JadxPluginMetadata metadata) {
        Path tmpJar;
        if (JadxPluginsTools.needDownload(metadata.getJar())) {
            tmpJar = FileUtils.createTempFile((String)"plugin.jar");
            PluginUtils.downloadFile(metadata.getJar(), tmpJar);
            metadata.setJar(tmpJar.toAbsolutePath().toString());
        } else {
            tmpJar = Paths.get(metadata.getJar(), new String[0]);
        }
        this.fillMetadataFromJar(metadata, tmpJar);
    }

    private void fillMetadataFromJar(JadxPluginMetadata metadata, Path jar) {
        try (JadxExternalPluginsLoader loader = new JadxExternalPluginsLoader();){
            JadxPlugin jadxPlugin = loader.loadFromJar(jar);
            JadxPluginInfo pluginInfo = jadxPlugin.getPluginInfo();
            metadata.setPluginId(pluginInfo.getPluginId());
            metadata.setName(pluginInfo.getName());
            metadata.setDescription(pluginInfo.getDescription());
            metadata.setHomepage(pluginInfo.getHomepage());
        }
    }

    private static boolean needDownload(String jar) {
        return jar.startsWith("https://") || jar.startsWith("http://");
    }

    private void copyJar(Path sourceJar, Path destJar) {
        try {
            Files.copy(sourceJar, destJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy plugin jar: " + sourceJar + " to: " + destJar, e);
        }
    }

    private void deletePluginJar(JadxPluginMetadata plugin) {
        try {
            Files.deleteIfExists(PluginFiles.INSTALLED_DIR.resolve(plugin.getJar()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Gson buildGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    private JadxInstalledPlugins loadPluginsJson() {
        JadxInstalledPlugins jadxInstalledPlugins;
        block9: {
            if (!Files.isRegularFile(PluginFiles.PLUGINS_JSON, new LinkOption[0])) {
                return new JadxInstalledPlugins();
            }
            BufferedReader reader = Files.newBufferedReader(PluginFiles.PLUGINS_JSON, StandardCharsets.UTF_8);
            try {
                jadxInstalledPlugins = (JadxInstalledPlugins)JadxPluginsTools.buildGson().fromJson((Reader)reader, JadxInstalledPlugins.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read file: " + PluginFiles.PLUGINS_JSON);
                }
            }
            ((Reader)reader).close();
        }
        return jadxInstalledPlugins;
    }

    private void savePluginsJson(JadxInstalledPlugins data) {
        if (data.getInstalled().isEmpty()) {
            try {
                Files.deleteIfExists(PluginFiles.PLUGINS_JSON);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to remove file: " + PluginFiles.PLUGINS_JSON, e);
            }
            return;
        }
        data.getInstalled().sort(null);
        try (BufferedWriter writer = Files.newBufferedWriter(PluginFiles.PLUGINS_JSON, StandardCharsets.UTF_8, new OpenOption[0]);){
            JadxPluginsTools.buildGson().toJson((Object)data, (Appendable)writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file: " + PluginFiles.PLUGINS_JSON, e);
        }
    }

    private static void collectFromDir(List<Path> list, Path dir) {
        try (Stream<Path> files = Files.list(dir);){
            files.filter(p -> p.getFileName().toString().endsWith(".jar")).forEach(list::add);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

