/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.plugins.tools.JadxPluginsTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxExternalPluginsLoader
implements JadxPluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JadxExternalPluginsLoader.class);
    private final List<URLClassLoader> classLoaders = new ArrayList<URLClassLoader>();

    public List<JadxPlugin> load() {
        this.close();
        long start = System.currentTimeMillis();
        HashMap<Class<? extends JadxPlugin>, JadxPlugin> map = new HashMap<Class<? extends JadxPlugin>, JadxPlugin>();
        ClassLoader classLoader = JadxPluginsTools.class.getClassLoader();
        this.loadFromClsLoader(map, classLoader);
        this.loadInstalledPlugins(map, classLoader);
        ArrayList<JadxPlugin> list = new ArrayList<JadxPlugin>(map.size());
        list.addAll(map.values());
        list.sort(Comparator.comparing(p -> p.getClass().getSimpleName()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collected {} plugins in {}ms", (Object)list.size(), (Object)(System.currentTimeMillis() - start));
        }
        return list;
    }

    public JadxPlugin loadFromJar(Path jar) {
        JadxPlugin jadxPlugin;
        block8: {
            HashMap<Class<? extends JadxPlugin>, JadxPlugin> map = new HashMap<Class<? extends JadxPlugin>, JadxPlugin>();
            ClassLoader classLoader = JadxPluginsTools.class.getClassLoader();
            this.loadFromClsLoader(map, classLoader);
            HashSet clspPlugins = new HashSet(map.keySet());
            URLClassLoader pluginClassLoader = this.loadFromJar(map, classLoader, jar);
            try {
                jadxPlugin = map.entrySet().stream().filter(entry -> !clspPlugins.contains(entry.getKey())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new RuntimeException("No plugin found in jar: " + jar));
                if (pluginClassLoader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pluginClassLoader != null) {
                        try {
                            pluginClassLoader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load plugin jar: " + jar, e);
                }
            }
            pluginClassLoader.close();
        }
        return jadxPlugin;
    }

    private void loadFromClsLoader(Map<Class<? extends JadxPlugin>, JadxPlugin> map, ClassLoader classLoader) {
        ServiceLoader.load(JadxPlugin.class, classLoader).stream().filter(p -> !map.containsKey(p.type())).forEach(p -> map.put(p.type(), (JadxPlugin)p.get()));
    }

    private void loadInstalledPlugins(Map<Class<? extends JadxPlugin>, JadxPlugin> map, ClassLoader classLoader) {
        List<Path> jars = JadxPluginsTools.getInstance().getAllPluginJars();
        for (Path jar : jars) {
            this.classLoaders.add(this.loadFromJar(map, classLoader, jar));
        }
    }

    private URLClassLoader loadFromJar(Map<Class<? extends JadxPlugin>, JadxPlugin> map, ClassLoader classLoader, Path jar) {
        try {
            File jarFile = jar.toFile();
            URL[] urls = new URL[]{jarFile.toURI().toURL()};
            URLClassLoader pluginClsLoader = new URLClassLoader("jadx-plugin:" + jarFile.getName(), urls, classLoader);
            this.loadFromClsLoader(map, pluginClsLoader);
            return pluginClsLoader;
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to load plugins, jar: " + jar, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            for (URLClassLoader classLoader : this.classLoaders) {
                try {
                    classLoader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.classLoaders.clear();
        }
    }
}

