/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.kotlin.smap.utils;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.utils.Utils;
import jadx.plugins.kotlin.smap.model.ClassAliasRename;
import jadx.plugins.kotlin.smap.model.SMAP;
import jadx.plugins.kotlin.smap.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ljadx/plugins/kotlin/smap/utils/KotlinSmapUtils;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "getClassAlias", "Ljadx/plugins/kotlin/smap/model/ClassAliasRename;", "cls", "Ljadx/core/dex/nodes/ClassNode;", "annotation", "Ljadx/plugins/kotlin/smap/model/SMAP;", "splitAndCheckClsName", "originCls", "fullClsName", "", "jadx-kotlin-source-debug-extension"})
@SourceDebugExtension(value={"SMAP\nKotlinSmapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmapUtils.kt\njadx/plugins/kotlin/smap/utils/KotlinSmapUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class KotlinSmapUtils {
    @NotNull
    public static final KotlinSmapUtils INSTANCE = new KotlinSmapUtils();
    @NotNull
    private static final Logger LOG;

    private KotlinSmapUtils() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    @JvmStatic
    @Nullable
    public static final ClassAliasRename getClassAlias(@NotNull ClassNode cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        SMAP sMAP = ExtensionsKt.getSourceDebugExtension(cls);
        if (sMAP == null) {
            return null;
        }
        SMAP annotation = sMAP;
        return INSTANCE.getClassAlias(cls, annotation);
    }

    private final ClassAliasRename getClassAlias(ClassNode cls, SMAP annotation) {
        String firstValue = StringsKt.replace$default((String)annotation.getFileMappings().get(0).getPath(), (String)"/", (String)".", (boolean)false, (int)4, null);
        try {
            String string;
            block8: {
                block7: {
                    String string2;
                    String p0 = string = ((Object)StringsKt.trim((CharSequence)firstValue)).toString();
                    boolean bl = false;
                    String string3 = string2 = !(((CharSequence)p0).length() == 0) ? string : null;
                    if (string2 == null) break block7;
                    String p02 = string2;
                    boolean bl2 = false;
                    string = Utils.cleanObjectName((String)p02);
                    if (string != null) break block8;
                }
                return null;
            }
            String clsName = string;
            ClassAliasRename alias = this.splitAndCheckClsName(cls, clsName);
            if (alias != null) {
                RenameReasonAttr.forNode((AttrNode)((AttrNode)cls)).append("from SourceDebugExtension");
                return alias;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse SourceDebugExtension", (Throwable)e);
        }
        return null;
    }

    private final ClassAliasRename splitAndCheckClsName(ClassNode originCls, String fullClsName) {
        if (!NameMapper.isValidFullIdentifier((String)fullClsName)) {
            return null;
        }
        String pkg = null;
        String name = null;
        int dot = StringsKt.lastIndexOf$default((CharSequence)fullClsName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dot == -1) {
            pkg = "";
            name = fullClsName;
        } else {
            String string = fullClsName.substring(0, dot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            pkg = string;
            String string2 = fullClsName.substring(dot + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            name = string2;
        }
        ClassInfo originClsInfo = originCls.getClassInfo();
        String originName = originClsInfo.getShortName();
        if (Intrinsics.areEqual((Object)originName, (Object)name) || StringsKt.contains$default((CharSequence)name, (CharSequence)"$", (boolean)false, (int)2, null) || !NameMapper.isValidIdentifier((String)name) || StringsKt.startsWith$default((String)pkg, (String)"java.", (boolean)false, (int)2, null)) {
            return null;
        }
        ClassNode newClsNode = originCls.root().resolveClass(fullClsName);
        return newClsNode != null ? null : new ClassAliasRename(pkg, name);
    }

    static {
        Logger logger = LoggerFactory.getLogger(KotlinSmapUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

