/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.javaconvert;

import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.input.data.impl.EmptyLoadResult;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.plugins.input.dex.DexInputPlugin;
import jadx.plugins.input.javaconvert.ConvertResult;
import jadx.plugins.input.javaconvert.JavaConvertLoader;
import jadx.plugins.input.javaconvert.JavaConvertOptions;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class JavaConvertPlugin
implements JadxInputPlugin,
JadxPluginOptions {
    public static final String PLUGIN_ID = "java-convert";
    private final DexInputPlugin dexInput = new DexInputPlugin();
    private final JavaConvertOptions options = new JavaConvertOptions();
    private final JavaConvertLoader loader = new JavaConvertLoader(this.options);

    public JadxPluginInfo getPluginInfo() {
        return new JadxPluginInfo(PLUGIN_ID, "JavaConvert", "Convert .jar and .class files to dex", "java-input");
    }

    public ILoadResult loadFiles(List<Path> input) {
        ConvertResult result = this.loader.process(input);
        if (result.isEmpty()) {
            result.close();
            return EmptyLoadResult.INSTANCE;
        }
        return this.dexInput.loadFiles(result.getConverted(), (Closeable)result);
    }

    public void setOptions(Map<String, String> options) {
        this.options.apply(options);
    }

    public List<OptionDescription> getOptionsDescriptions() {
        return this.options.buildOptionsDescriptions();
    }
}

