/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.javaconvert;

import jadx.api.plugins.options.OptionDescription;
import jadx.api.plugins.options.impl.BaseOptionsParser;
import jadx.api.plugins.options.impl.JadxOptionDescription;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JavaConvertOptions
extends BaseOptionsParser {
    private static final String MODE_OPT = "java-convert.mode";
    private static final String D8_DESUGAR_OPT = "java-convert.d8-desugar";
    private Mode mode = Mode.BOTH;
    private boolean d8Desugar = false;

    public void apply(Map<String, String> options) {
        this.mode = (Mode)((Object)this.getOption(options, MODE_OPT, name -> Mode.valueOf(name.toUpperCase(Locale.ROOT)), (Object)Mode.BOTH));
        this.d8Desugar = this.getBooleanOption(options, D8_DESUGAR_OPT, false);
    }

    public List<OptionDescription> buildOptionsDescriptions() {
        return Arrays.asList(new JadxOptionDescription(MODE_OPT, "Convert mode", "both", Arrays.asList("dx", "d8", "both")), new JadxOptionDescription(D8_DESUGAR_OPT, "Use desugar in d8", "no", Arrays.asList("yes", "no")));
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isD8Desugar() {
        return this.d8Desugar;
    }

    public static enum Mode {
        DX,
        D8,
        BOTH;

    }
}

